/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.datamanager.adapters;

import java.io.*;
import java.net.*;
import java.util.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class FileDataAdapter implements DataAdapter
{
/**
 *
 * @param dataResults
 * @throws gov.va.med.nhin.adapter.datamanager.DataManagerException
 *
 * this method reads field ^T data pairs of information from the filename specified in the data query
 * the information is returned through the setData method of the DataResult
 */
    public List getData(DataQuery dataQuery)
    {
        List<Map> ret = new ArrayList<Map>();

        try {
            String filename = (String)dataQuery.getParameter("filename");
            String pathAndFileName = Utils.getResource(filename).getPath();
            if(pathAndFileName.length()>5 && pathAndFileName.startsWith("file:/")){
                pathAndFileName = pathAndFileName.substring(6);
            }
            File f = new File(URLDecoder.decode(pathAndFileName));
            if (f.exists()) {
                BufferedReader demographicsFile = new BufferedReader(new InputStreamReader((InputStream) Utils.getResource(filename).getContent()));
                String line = null;
                String[] tmp;
                HashMap<String, String> dataResult = new HashMap<String, String>();
                while ((line = demographicsFile.readLine()) != null) {
                    if (line.length() == 0) {
                        ret.add(dataResult);
                        dataResult = new HashMap<String, String>();
                    } else {
                        tmp = line.split("\t");
                        dataResult.put(tmp[0], tmp[1]);
                    }
                }
                ret.add(dataResult);
                demographicsFile.close();
            } else {
                throw new DataManagerException("File not found - "+f.toString());
            }
        } catch (Throwable t) {
            throw new DataManagerException("An error occurred when getting data.", t);
        }

        return ret;
    }
}
