/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.datamanager.adapters;

import java.util.*;

import org.apache.commons.beanutils.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class AggregatorDataAdapter implements DataAdapter
{
    public List getData(DataQuery dataQuery)
    {
        List ret = new ArrayList();
        String driverQueryName = dataQuery.getProperty("driverQueryName");
        String singleQueryName = dataQuery.getProperty("singleQueryName");
        String setProperties = dataQuery.getProperty("setProperties");
        
        DataQuery driverQuery = setUpQuery(dataQuery, driverQueryName);

        List driverResults = driverQuery.getResults();

        if (!NullChecker.isNullOrEmpty(driverResults)) {
            if (NullChecker.isNullOrEmpty(singleQueryName)) {
                HashMap<String, List> result = new HashMap<String, List>();
                ret.add(result);
                for (Object driverResult : driverResults) {
                    for (String resultName : dataQuery.getResultBySourceNames()) {
                        DataQuery resultQuery = setUpQuery(dataQuery, resultName);

                        for (String rn : driverQuery.getResultNames()) {
                            if (resultQuery.isParameter(rn)) {
                                resultQuery.setParameter(rn, getValue(driverResult, rn));
                            }
                        }

                        if (!NullChecker.isNullOrEmpty(setProperties)) {
                            for (String setProperty : setProperties.split(",")) {
                                String key = dataQuery.getProperty(setProperty);
                                if (!NullChecker.isNullOrEmpty(key)) {
                                    resultQuery.setProperty(setProperty, getValue(driverResult, key).toString());
                                }
                            }
                        }

                        List resultResults = resultQuery.getResults();
                        if (!NullChecker.isNullOrEmpty(resultResults)) {
                            List storedResults = result.get(resultName);
                            if (storedResults != null) {
                                storedResults.addAll(resultResults);
                            }
                            else {
                                result.put(resultName, resultResults);
                            }
                        }
                    }
                }
            }
            else {
                for (Object driverResult : driverResults) {
                    DataQuery resultQuery = setUpQuery(dataQuery, singleQueryName);

                    for (String rn : driverQuery.getResultNames()) {
                        if (resultQuery.isParameter(rn)) {
                            resultQuery.setParameter(rn, getValue(driverResult, rn));
                        }
                    }

                    if (!NullChecker.isNullOrEmpty(setProperties)) {
                        for (String setProperty : setProperties.split(",")) {
                            String key = dataQuery.getProperty(setProperty);
                            if (!NullChecker.isNullOrEmpty(key)) {
                                resultQuery.setProperty(setProperty, getValue(driverResult, key).toString());
                            }
                        }
                    }

                    List resultResults = resultQuery.getResults();
                    if (!NullChecker.isNullOrEmpty(resultResults)) {
                        ret.addAll(resultResults);
                    }
                }
            }
        }

        return ret;
    }

    private DataQuery setUpQuery(DataQuery dataQuery, String queryName)
    {
        DataQuery ret = dataQuery.getDataManager().getQuery(queryName);
        for (String parameterName : dataQuery.getParameterNames()) {
            if (ret.isParameter(parameterName)) {
                ret.setParameter(parameterName, dataQuery.getParameter(parameterName));
            }
        }
        return ret;
    }
    
    private Object getValue(Object bean, String property)
    {
        Object ret;
        
        if (bean instanceof Map) {
            ret = ((Map)bean).get(property);
        }
        else {
            try {
                ret = PropertyUtils.getProperty(bean, property);
            }
            catch (Exception e) {
                ret = null;
            }
        }
        
        return ret;
    }
}
