/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.patientcorrelation;

import gov.hhs.fha.nhinc.common.nhinccommon.AssertionType;
import gov.hhs.fha.nhinc.common.nhinccommon.CeType;
import gov.hhs.fha.nhinc.common.nhinccommon.HomeCommunityType;
import gov.hhs.fha.nhinc.common.nhinccommon.PersonNameType;
import gov.hhs.fha.nhinc.common.nhinccommon.UserType;
import java.text.*;
import java.util.*;
import javax.xml.bind.*;

import org.jmock.*;
import org.jmock.integration.junit4.*;
import org.junit.*;
import org.junit.runner.*;
import static org.junit.Assert.*;

import gov.hhs.fha.nhinc.transform.subdisc.*;
import org.hl7.v3.*;

import gov.va.med.nhin.adapter.audit.*;
import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.facilitymanager.*;
import gov.va.med.nhin.adapter.propertylookup.*;
import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author       VAZQUD
 */
@RunWith(JMock.class)
public class AdapterPatientCorrelationTest
{
    static private final String TEST_SENDING_HCID = "1.1";
    static private final String TEST_SENDING_AA = "1.1";
    static private final String TEST_RECEIVING_HCID = "2.2";
    static private final String TEST_RECEIVING_AA = "2.2";
    static private final String TEST_AA_NAME = "Test Assigning Authority";
    
    private Mockery context = new JUnit4Mockery();

    public AdapterPatientCorrelationTest()
    {
    }

    /**
     * Test of retrievePatientCorrelations method, of class AdapterPatientCorrelation.
     */
    /*
    @Test
    public void testRetrievePatientCorrelations()
    {
        System.out.println("retrievePatientCorrelations");
        RetrievePatientCorrelationsRequestType retrievePatientCorrelationsRequest = null;
        AdapterPatientCorrelation instance = new AdapterPatientCorrelation();
        RetrievePatientCorrelationsResponseType expResult = null;
        RetrievePatientCorrelationsResponseType result = instance.retrievePatientCorrelations(retrievePatientCorrelationsRequest);
        assertEquals(expResult, result);
        // TODO review the generated test code and remove the default call to fail.
        fail("The test case is a prototype.");
    }
    */
    
    /**
     * Test of addPatientCorrelation method, of class AdapterPatientCorrelation.
     */
    @Test
    public void testAddPatientCorrelationNullRequest()
    {
        System.out.println("addPatientCorrelationNullRequest");
        AddPatientCorrelationRequestType request = null;
        AdapterPatientCorrelation instance = new AdapterPatientCorrelation();
        AddPatientCorrelationResponseType expResult = null;
        
        try {
            AddPatientCorrelationResponseType result = instance.addPatientCorrelation(request);
            fail("This should not happen!");
        }
        catch (Throwable t) {
            assertTrue(true);
        }
    }

    @Test
    public void testAddPatientCorrelationNoPatient()
    {
        System.out.println("addPatientCorrelationNullRequest");
        AddPatientCorrelationRequestType request = new AddPatientCorrelationRequestType();
        AdapterPatientCorrelation instance = new AdapterPatientCorrelation();
        AddPatientCorrelationResponseType expResult = null;
        
        try {
            AddPatientCorrelationResponseType result = instance.addPatientCorrelation(request);
            fail("This should not happen!");
        }
        catch (Throwable t) {
            assertTrue(true);
        }
    }
    
    @Test
    public void testAddPatientCorrelation()
    {
        System.out.println("addPatientCorrelationNullRequest");
        AddPatientCorrelationRequestType request = new AddPatientCorrelationRequestType();
        
        final Map demographics = new HashMap() {{
            put("nameGiven", new ArrayList() {{
                add("Test");
                add("Middle");
            }});
            put("namePrefix", null);
            put("nameSuffix", null);
            put("nameFamily", "Patient");
            put("genderCode", "M");
            put("birthDate", "20120724");
            put("SSN", "666003333");
            put("MRN", "1234567890V123456");
        }};

        final Map demographicsExt = new HashMap() {{
            put("homeAddressStreet", new ArrayList() {{
                add("1234 Test Lane");
                add("Apt 37");
            }});
            put("homeAddressCity", "Test City");
            put("homeAddressState", "LA");
            put("homeAddressPostal", "70124");
            put("phoneHome", "tel:+1-333-777-8888");
            put("maritalStatusCod", "S");
            put("multipleBirthCode", "N");
        }};
        
        PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305(
                (String)demographics.get("nameFamily"),
                (List<String>)demographics.get("nameGiven"),
                (String)demographics.get("namePrefix"),
                (String)demographics.get("nameSuffix"),
                (String)demographics.get("birthDate"),
                (String)demographicsExt.get("homeAddressCity"),
                (String)demographicsExt.get("homeAddressState"),
                (List<String>)demographicsExt.get("homeAddressStreet"),
                (String)demographicsExt.get("homeAddressPostal"),
                (String)demographicsExt.get("phoneHome"),
                (String)demographics.get("genderCode"),
                (String)demographicsExt.get("multipleBirthCode"),
                (String)demographicsExt.get("maritalStatusCode"),
                (String)demographics.get("MRN"),
                TEST_SENDING_HCID,
                TEST_SENDING_AA,
                (String)demographics.get("SSN"));
        PRPAIN201301UV02 prpain201301UV02 = HL7PRPA201301Transforms.createPRPA201301(prpain201305UV02, TEST_RECEIVING_HCID);
        II localPatientId = new II();
        localPatientId.setAssigningAuthorityName(TEST_AA_NAME);
        localPatientId.setRoot(TEST_RECEIVING_AA);
        localPatientId.setExtension("1234567890V123456");
        prpain201301UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient().getId().add(localPatientId);
        request.setPRPAIN201301UV02(prpain201301UV02);

        AssertionType assertion = new AssertionType();
        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId("urn:oid:" + TEST_SENDING_HCID);
        assertion.setHomeCommunity(homeCommunity);
        UserType user = new UserType();
        user.setUserName("remoteUser");
        PersonNameType personName = new PersonNameType();
        personName.setFamilyName("User");
        personName.setGivenName("Test");
        user.setPersonName(personName);
        user.setOrg(homeCommunity);
        assertion.setUserInfo(user);
        CeType role = new CeType();
        role.setCode("12345");
        user.setRoleCoded(role);
        CeType pou = new CeType();
        pou.setCode("TREATMENT");
        assertion.setPurposeOfDisclosureCoded(pou);
        request.setAssertion(assertion);
        
        final Facility facility = new Facility();
        facility.setFacilityNumber("VA");
        facility.setHomeCommunityId(TEST_RECEIVING_HCID);
        facility.setFullHomeCommunityId("urn:oid:" + TEST_RECEIVING_HCID);

        final Map patient = new HashMap() {{
            put("demographics", demographics);
            put("demographicsExt", demographicsExt);
            put("patientPreferredFacilityNumber", "TEST");
            put("patientPreferredFacilityName", "Test Facility");
        }};

        final List patients = new ArrayList() {{
            add(patient);
        }};
        
        final Audit audit = new Audit();
        audit.setAction("AddPatientCorrelation");
        audit.setDetails(
            "ICN=" + demographics.get("MRN")
            + ", correlatedPatientId=" + demographics.get("MRN")
            + ", correlatedAssigningAuthority=" + TEST_SENDING_AA
            + ", correlatedAssigningFacility=" + TEST_SENDING_HCID
            + ", familyName=" + demographics.get("nameFamily")
            + ", firstName=" + ((List<String>)demographics.get("nameGiven")).get(0)
            + ", middleName=" + ((List<String>)demographics.get("nameGiven")).get(1)
            + ", gender=" + demographics.get("genderCode")
            + ", dob=" + demographics.get("birthDate")
            + ", homeAddressCity=" + demographicsExt.get("homeAddressCity")
            + ", homeAddressState=" + demographicsExt.get("homeAddressState")
            + ", homeAddressStreet=" + ((List<String>)demographicsExt.get("homeAddressStreet")).get(0)
            + ", homeAddressStreet=" + ((List<String>)demographicsExt.get("homeAddressStreet")).get(1)
            + ", homeAddressPostal=" + demographicsExt.get("homeAddressPostal")
            + ", homePhone=" + ((String)demographicsExt.get("phoneHome")).substring(5)
            + ", ssn=" + demographics.get("SSN")
        );
        audit.setOrganizationId(assertion.getHomeCommunity().getHomeCommunityId());
        audit.setPatientFacilityName((String)patient.get("patientPreferredFacilityName"));
        audit.setPatientFacilityNumber((String)patient.get("patientPreferredFacilityNumber"));
        audit.setPatientGivenName(((List<String>)demographics.get("nameGiven")).get(0));
        audit.setPatientId((String)demographics.get("MRN"));
        audit.setPatientLastName((String)demographics.get("nameFamily"));
        audit.setPatientSSN((String)demographics.get("SSN"));
        audit.setPurposeForUse(assertion.getPurposeOfDisclosureCoded().getCode());
        audit.setRemoteOrganizationId("urn:oid:" + TEST_RECEIVING_HCID);
        audit.setUserFacilityName(assertion.getUserInfo().getOrg().getName());
        audit.setUserFacilityNumber(assertion.getUserInfo().getOrg().getHomeCommunityId());
        audit.setUserId(assertion.getUserInfo().getUserName());
        audit.setUserName(assertion.getUserInfo().getPersonName().getGivenName() + " " + assertion.getUserInfo().getPersonName().getFamilyName());
        audit.setUserRole(assertion.getUserInfo().getRoleCoded().getCode());
        
        AdapterPatientCorrelation instance = new AdapterPatientCorrelation();
        
        final PropertyLookup propertyLookup = context.mock(PropertyLookup.class);
        final DataManager dataManager = context.mock(DataManager.class);
        final DataQuery dataQuery = context.mock(DataQuery.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final AuditManager auditManager = context.mock(AuditManager.class);
        
        instance.setPropertyLookup(propertyLookup);
        instance.setDataManager(dataManager);
        instance.setFacilityManager(facilityManager);
        instance.setAuditManager(auditManager);
        
        context.checking(new Expectations() {{
            allowing(propertyLookup).getProperty("AssigningAuthority");
            will(returnValue(TEST_RECEIVING_AA));
            
            oneOf(dataManager).getQuery("MPI.linkPatient");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("patientId", (String)demographics.get("MRN"));
            oneOf(dataQuery).setParameter("correlatedPatientId", (String)demographics.get("MRN"));
            oneOf(dataQuery).setParameter("correlatedAssigningAuthority", TEST_SENDING_AA);
            oneOf(dataQuery).setParameter("correlatedAssigningFacility", TEST_SENDING_HCID);
            oneOf(dataQuery).setParameter("familyName", (String)demographics.get("nameFamily"));
            oneOf(dataQuery).getParameter("firstName");
            will(returnValue(null));
            oneOf(dataQuery).setParameter("firstName", ((List<String>)demographics.get("nameGiven")).get(0));
            oneOf(dataQuery).getParameter("firstName");
            will(returnValue(((List<String>)demographics.get("nameGiven")).get(0)));
            oneOf(dataQuery).getParameter("middleName");
            will(returnValue(null));
            oneOf(dataQuery).setParameter("middleName", ((List<String>)demographics.get("nameGiven")).get(1));
            oneOf(dataQuery).setParameter("gender", demographics.get("genderCode"));
            oneOf(dataQuery).setParameter("dob", demographics.get("birthDate"));
            oneOf(dataQuery).setParameter("homeAddressStreet1", ((List<String>)demographicsExt.get("homeAddressStreet")).get(0));
            oneOf(dataQuery).setParameter("homeAddressStreet2", ((List<String>)demographicsExt.get("homeAddressStreet")).get(1));
            oneOf(dataQuery).setParameter("homeAddressCity", demographicsExt.get("homeAddressCity"));
            oneOf(dataQuery).setParameter("homeAddressState", demographicsExt.get("homeAddressState"));
            oneOf(dataQuery).setParameter("homeAddressPostal", demographicsExt.get("homeAddressPostal"));
            oneOf(dataQuery).setParameter("homePhone", ((String)demographicsExt.get("phoneHome")).substring(5));
            oneOf(dataQuery).setParameter("ssn", demographics.get("SSN"));
            oneOf(dataQuery).getResults();
            
            oneOf(facilityManager).addAssigningAuthorityToFacility(TEST_SENDING_HCID, TEST_SENDING_AA, TEST_AA_NAME);
            
            oneOf(dataManager).getQuery("Composite.findDemographics");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("icn", "1234567890V123456");
            oneOf(dataQuery).getResults();
            will(returnValue(patients));
            
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
            
            oneOf(auditManager).storeAudit(audit);
        }});
        
        AddPatientCorrelationResponseType result = instance.addPatientCorrelation(request);
        assert(result != null);
    }
    
    @Test
    public void testAddPatientCorrelationNoMiddleName()
    {
        System.out.println("addPatientCorrelationNoMiddleName");
        AddPatientCorrelationRequestType request = new AddPatientCorrelationRequestType();
        
        final Map demographics = new HashMap() {{
            put("nameGiven", new ArrayList() {{
                add("Test");
            }});
            put("namePrefix", null);
            put("nameSuffix", null);
            put("nameFamily", "Patient");
            put("genderCode", "M");
            put("birthDate", "20120724");
            put("SSN", "666003333");
            put("MRN", "1234567890V123456");
        }};

        final Map demographicsExt = new HashMap() {{
            put("homeAddressStreet", new ArrayList() {{
                add("1234 Test Lane");
            }});
            put("homeAddressCity", "Test City");
            put("homeAddressState", "LA");
            put("homeAddressPostal", "70124");
            put("phoneHome", "tel:+1-333-777-8888");
            put("maritalStatusCod", "S");
            put("multipleBirthCode", "N");
        }};
        
        PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305(
                (String)demographics.get("nameFamily"),
                (List<String>)demographics.get("nameGiven"),
                (String)demographics.get("namePrefix"),
                (String)demographics.get("nameSuffix"),
                (String)demographics.get("birthDate"),
                (String)demographicsExt.get("homeAddressCity"),
                (String)demographicsExt.get("homeAddressState"),
                (List<String>)demographicsExt.get("homeAddressStreet"),
                (String)demographicsExt.get("homeAddressPostal"),
                (String)demographicsExt.get("phoneHome"),
                (String)demographics.get("genderCode"),
                (String)demographicsExt.get("multipleBirthCode"),
                (String)demographicsExt.get("maritalStatusCode"),
                (String)demographics.get("MRN"),
                TEST_SENDING_HCID,
                TEST_SENDING_AA,
                (String)demographics.get("SSN"));
        PRPAIN201301UV02 prpain201301UV02 = HL7PRPA201301Transforms.createPRPA201301(prpain201305UV02, TEST_RECEIVING_HCID);
        II localPatientId = new II();
        localPatientId.setAssigningAuthorityName(TEST_AA_NAME);
        localPatientId.setRoot(TEST_RECEIVING_AA);
        localPatientId.setExtension("1234567890V123456");
        prpain201301UV02.getControlActProcess().getSubject().get(0).getRegistrationEvent().getSubject1().getPatient().getId().add(localPatientId);
        request.setPRPAIN201301UV02(prpain201301UV02);

        AssertionType assertion = new AssertionType();
        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId("urn:oid:" + TEST_SENDING_HCID);
        assertion.setHomeCommunity(homeCommunity);
        UserType user = new UserType();
        user.setUserName("remoteUser");
        PersonNameType personName = new PersonNameType();
        personName.setFamilyName("User");
        personName.setGivenName("Test");
        user.setPersonName(personName);
        user.setOrg(homeCommunity);
        assertion.setUserInfo(user);
        CeType role = new CeType();
        role.setCode("12345");
        user.setRoleCoded(role);
        CeType pou = new CeType();
        pou.setCode("TREATMENT");
        assertion.setPurposeOfDisclosureCoded(pou);
        request.setAssertion(assertion);
        
        final Facility facility = new Facility();
        facility.setFacilityNumber("VA");
        facility.setHomeCommunityId(TEST_RECEIVING_HCID);
        facility.setFullHomeCommunityId("urn:oid:" + TEST_RECEIVING_HCID);

        final Map patient = new HashMap() {{
            put("demographics", demographics);
            put("demographicsExt", demographicsExt);
            put("patientPreferredFacilityNumber", "TEST");
            put("patientPreferredFacilityName", "Test Facility");
        }};

        final List patients = new ArrayList() {{
            add(patient);
        }};
        
        final Audit audit = new Audit();
        audit.setAction("AddPatientCorrelation");
        audit.setDetails(
            "ICN=" + demographics.get("MRN")
            + ", correlatedPatientId=" + demographics.get("MRN")
            + ", correlatedAssigningAuthority=" + TEST_SENDING_AA
            + ", correlatedAssigningFacility=" + TEST_SENDING_HCID
            + ", familyName=" + demographics.get("nameFamily")
            + ", firstName=" + ((List<String>)demographics.get("nameGiven")).get(0)
            + ", gender=" + demographics.get("genderCode")
            + ", dob=" + demographics.get("birthDate")
            + ", homeAddressCity=" + demographicsExt.get("homeAddressCity")
            + ", homeAddressState=" + demographicsExt.get("homeAddressState")
            + ", homeAddressStreet=" + ((List<String>)demographicsExt.get("homeAddressStreet")).get(0)
            + ", homeAddressPostal=" + demographicsExt.get("homeAddressPostal")
            + ", homePhone=" + ((String)demographicsExt.get("phoneHome")).substring(5)
            + ", ssn=" + demographics.get("SSN")
        );
        audit.setOrganizationId(assertion.getHomeCommunity().getHomeCommunityId());
        audit.setPatientFacilityName((String)patient.get("patientPreferredFacilityName"));
        audit.setPatientFacilityNumber((String)patient.get("patientPreferredFacilityNumber"));
        audit.setPatientGivenName(((List<String>)demographics.get("nameGiven")).get(0));
        audit.setPatientId((String)demographics.get("MRN"));
        audit.setPatientLastName((String)demographics.get("nameFamily"));
        audit.setPatientSSN((String)demographics.get("SSN"));
        audit.setPurposeForUse(assertion.getPurposeOfDisclosureCoded().getCode());
        audit.setRemoteOrganizationId("urn:oid:" + TEST_RECEIVING_HCID);
        audit.setUserFacilityName(assertion.getUserInfo().getOrg().getName());
        audit.setUserFacilityNumber(assertion.getUserInfo().getOrg().getHomeCommunityId());
        audit.setUserId(assertion.getUserInfo().getUserName());
        audit.setUserName(assertion.getUserInfo().getPersonName().getGivenName() + " " + assertion.getUserInfo().getPersonName().getFamilyName());
        audit.setUserRole(assertion.getUserInfo().getRoleCoded().getCode());
        
        AdapterPatientCorrelation instance = new AdapterPatientCorrelation();
        
        final PropertyLookup propertyLookup = context.mock(PropertyLookup.class);
        final DataManager dataManager = context.mock(DataManager.class);
        final DataQuery dataQuery = context.mock(DataQuery.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final AuditManager auditManager = context.mock(AuditManager.class);
        
        instance.setPropertyLookup(propertyLookup);
        instance.setDataManager(dataManager);
        instance.setFacilityManager(facilityManager);
        instance.setAuditManager(auditManager);
        
        context.checking(new Expectations() {{
            allowing(propertyLookup).getProperty("AssigningAuthority");
            will(returnValue(TEST_RECEIVING_AA));
            
            oneOf(dataManager).getQuery("MPI.linkPatient");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("patientId", (String)demographics.get("MRN"));
            oneOf(dataQuery).setParameter("correlatedPatientId", (String)demographics.get("MRN"));
            oneOf(dataQuery).setParameter("correlatedAssigningAuthority", TEST_SENDING_AA);
            oneOf(dataQuery).setParameter("correlatedAssigningFacility", TEST_SENDING_HCID);
            oneOf(dataQuery).setParameter("familyName", (String)demographics.get("nameFamily"));
            oneOf(dataQuery).getParameter("firstName");
            will(returnValue(null));
            oneOf(dataQuery).setParameter("firstName", ((List<String>)demographics.get("nameGiven")).get(0));
            oneOf(dataQuery).setParameter("gender", demographics.get("genderCode"));
            oneOf(dataQuery).setParameter("dob", demographics.get("birthDate"));
            oneOf(dataQuery).setParameter("homeAddressStreet1", ((List<String>)demographicsExt.get("homeAddressStreet")).get(0));
            oneOf(dataQuery).setParameter("homeAddressCity", demographicsExt.get("homeAddressCity"));
            oneOf(dataQuery).setParameter("homeAddressState", demographicsExt.get("homeAddressState"));
            oneOf(dataQuery).setParameter("homeAddressPostal", demographicsExt.get("homeAddressPostal"));
            oneOf(dataQuery).setParameter("homePhone", ((String)demographicsExt.get("phoneHome")).substring(5));
            oneOf(dataQuery).setParameter("ssn", demographics.get("SSN"));
            oneOf(dataQuery).getResults();
            
            oneOf(facilityManager).addAssigningAuthorityToFacility(TEST_SENDING_HCID, TEST_SENDING_AA, TEST_AA_NAME);
            
            oneOf(dataManager).getQuery("Composite.findDemographics");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("icn", "1234567890V123456");
            oneOf(dataQuery).getResults();
            will(returnValue(patients));
            
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
            
            oneOf(auditManager).storeAudit(audit);
        }});
        
        AddPatientCorrelationResponseType result = instance.addPatientCorrelation(request);
        assert(result != null);
    }
    
    private PRPAIN201305UV02 createPRPAIN201305(String lastName,
                                                List<String> givenName,
                                                String prefix,
                                                String suffix,
                                                String dob,
                                                String city,
                                                String state,
                                                List<String> address,
                                                String zip,
                                                String phone,
                                                String gender,
                                                String multiBirth,
                                                String maritalStatus,
                                                String patientId,
                                                String homeCommunityId,
                                                String assigningAuthority,
                                                String ssn)
    {
        JAXBElement<PRPAMT201301UV02Person> patientPerson =
                buildPRPAIN201301PatientPerson(lastName,
                                               givenName,
                                               prefix,
                                               suffix,
                                               dob,
                                               city,
                                               state,
                                               address,
                                               zip,
                                               phone,
                                               gender,
                                               multiBirth,
                                               maritalStatus);

        II ii = new II();
        ii.setRoot(assigningAuthority);
        ii.setExtension(patientId);
        String assigningAuthorityName = TEST_AA_NAME;
        if (!NullChecker.isNullOrEmpty(assigningAuthorityName)) {
            ii.setAssigningAuthorityName(assigningAuthorityName);
        }

        PRPAMT201301UV02Patient patient =
                HL7PatientTransforms.create201301Patient(patientPerson, ii);

        PRPAIN201305UV02 ret =
                HL7PRPA201305Transforms.createPRPA201305(patient, homeCommunityId, "1.1", assigningAuthority);

        // add ssn.
        PRPAMT201306UV02ParameterList paramList = ret.getControlActProcess().getQueryByParameter().getValue().getParameterList();
        PRPAMT201306UV02LivingSubjectId ssnId = new PRPAMT201306UV02LivingSubjectId();
        ii = new II();
        ii.setRoot("2.16.840.1.113883.4.1");
        ii.setExtension(ssn);
        ssnId.getValue().add(ii);
        ST text = new ST();
        ssnId.setSemanticsText(text);
        paramList.getLivingSubjectId().add(ssnId);

        // fix the interaction id.
        ret.setInteractionId(HL7DataTransformHelper.IIFactory(HL7Constants.INTERACTION_ID_ROOT, "PRPA_IN201305UV02"));

        // fix the controlActProccess/code.
        ret.getControlActProcess().setCode(HL7DataTransformHelper.CDFactory("PRPA_TE201305UV02", HL7Constants.INTERACTION_ID_ROOT));

        // fix the acceptAckCode.
        ret.setAcceptAckCode(HL7DataTransformHelper.CSFactory("NE"));
        
        // fix the processingModeCode.
        ret.setProcessingModeCode(HL7DataTransformHelper.CSFactory("T"));
        
        ret.getControlActProcess().setClassCode(ActClassControlAct.CACT);
        ret.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().setClassCode("ASSIGNED");
        
        // fix the creation time of the message.
        TSExplicit te = new TSExplicit();
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        te.setValue(formatter.format(now));
        ret.setCreationTime(te);

        CS responseModalityCode = new CS();
        responseModalityCode.setCode("R");
        ret.getControlActProcess().getQueryByParameter().getValue().setResponseModalityCode(responseModalityCode);
        
        CS responsePriorityCode = new CS();
        responsePriorityCode.setCode("I");
        ret.getControlActProcess().getQueryByParameter().getValue().setResponsePriorityCode(responsePriorityCode);
                
        return ret;
    }

    private JAXBElement<PRPAMT201301UV02Person> buildPRPAIN201301PatientPerson(String lastName,
                                                                               List<String> givenName,
                                                                               String prefix,
                                                                               String suffix,
                                                                               String dob,
                                                                               String city,
                                                                               String state,
                                                                               List<String> address,
                                                                               String zip,
                                                                               String phone,
                                                                               String gender,
                                                                               String multiBirth,
                                                                               String maritalStatus)
    {
        PRPAMT201301UV02Person patientPerson = new PRPAMT201301UV02Person();

        //--------------------------------------------------------------
        //build name
        org.hl7.v3.ObjectFactory factory = new org.hl7.v3.ObjectFactory();
        PNExplicit name = (PNExplicit) (factory.createPNExplicit());
        List namelist = name.getContent();

        //Last name
        EnExplicitFamily familyName = new EnExplicitFamily();
        familyName.setPartType("FAM");
        familyName.setContent(lastName);
        namelist.add(factory.createPNExplicitFamily(familyName));

        //First name
        if (NullChecker.isNotNullOrEmpty(givenName)) {
            for (String n : givenName) {
                if (!NullChecker.isNullOrEmpty(n)) {
                    EnExplicitGiven gn = new EnExplicitGiven();
                    gn.setPartType("GIV");
                    gn.setContent(n);
                    namelist.add(factory.createPNExplicitGiven(gn));

                }
            }
        }

        EnExplicitPrefix pfx = new EnExplicitPrefix();
        pfx.setContent(prefix);
        pfx.setPartType("PFX");
        namelist.add(factory.createENExplicitPrefix(pfx));

        EnExplicitSuffix sfx = new EnExplicitSuffix();
        sfx.setContent(suffix);
        sfx.setPartType("SFX");
        namelist.add(factory.createENExplicitSuffix(sfx));

        patientPerson.getName().add(name);
        //------------------------------------------------------------


        //Date of Birth
        TSExplicit valueTSExplicit = new TSExplicit();
        valueTSExplicit.setValue(dob);
        patientPerson.setBirthTime(valueTSExplicit);


        //Gender
        CE valueCE = new CE();
        valueCE.setCode(gender);
        patientPerson.setAdministrativeGenderCode(valueCE);

        //-------------------------------------------------------------
        //  build address
        ADExplicit addr = (ADExplicit) (factory.createADExplicit());
        List addrlist = addr.getContent();

        //address
        AdxpExplicitCity valueCity = new AdxpExplicitCity();
        valueCity.setContent(city);
        addrlist.add(factory.createADExplicitCity(valueCity));

        AdxpExplicitState valueState = new AdxpExplicitState();
        valueState.setContent(state);
        addrlist.add(factory.createADExplicitState(valueState));

        if (NullChecker.isNotNullOrEmpty(address)) {
            for (String a : address) {
                if (!NullChecker.isNullOrEmpty(a)) {
                    AdxpExplicitStreetAddressLine line = new AdxpExplicitStreetAddressLine();
                    line.setContent(a);
                    addrlist.add(factory.createADExplicitStreetAddressLine(line));
                }
            }
        }
        
        AdxpExplicitPostalCode valueZip = new AdxpExplicitPostalCode();
        valueZip.setContent(zip);
        addrlist.add(factory.createADExplicitPostalCode(valueZip));


        patientPerson.getAddr().add(addr);
        //--------------------------------------------------------------


        //telephone
        TELExplicit valueTELE = new TELExplicit();
        valueTELE.setValue(phone);
        patientPerson.getTelecom().add(valueTELE);

        //multi birth
        BL valueBL = new BL();
        if (multiBirth == null || multiBirth.length() == 0 || multiBirth.startsWith("NO") || multiBirth.startsWith("no")) {
            valueBL.setValue(false);
        }
        else {
            valueBL.setValue(true);
        }
        patientPerson.setMultipleBirthInd(valueBL);  //BL value

        // marital status
        CE maritalStatusCode = new CE();
        maritalStatusCode.setCode(maritalStatus);
        patientPerson.setMaritalStatusCode(maritalStatusCode);

        return factory.createPRPAMT201301UV02PatientPatientPerson(patientPerson);
    }
}
