/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.adaptergateway.patientdiscovery;

import java.text.*;
import java.util.*;
import java.util.concurrent.*;

import javax.xml.bind.*;

import org.junit.*;
import org.junit.runner.*;
import static org.junit.Assert.*;

import gov.hhs.fha.nhinc.adapterpolicyengine.*;
import gov.hhs.fha.nhinc.common.connectionmanagerinfo.*;
import gov.hhs.fha.nhinc.common.nhinccommon.*;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.*;
import gov.hhs.fha.nhinc.mpi.adapter.component.hl7parsers.HL7DbParser201305;
import gov.hhs.fha.nhinc.nhinccomponentconnectionmanager.*;
import gov.hhs.fha.nhinc.nhinccomponentpatientcorrelation.*;
import gov.hhs.fha.nhinc.patientdb.model.*;
import gov.hhs.fha.nhinc.transform.subdisc.*;
import org.hl7.v3.*;
import oasis.names.tc.xacml._2_0.context.schema.os.DecisionType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResponseType;
import oasis.names.tc.xacml._2_0.context.schema.os.ResultType;
import org.jmock.*;
import org.jmock.integration.junit4.*;

import gov.va.med.nhin.adapter.adaptermpi.*;
import gov.va.med.nhin.adapter.facilitymanager.*;
import gov.va.med.nhin.adapter.mock.actions.*;
import gov.va.med.nhin.adapter.mpi.hl7parsers.HL7DbParser201306;
import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author       VAZQUD
 */
@RunWith(JMock.class)
public class AdapterGatewayPatientDiscoveryTest
{
    static final private String TEST_RECEIVING_HCID = "1.1";
    static final private String TEST_SENDING_HCID = "2.2";
    static final private String TEST_RECEIVING_AA = "1.1";
    static final private String TEST_SENDING_AA = "2.2";
    static final private String TEST_AA_NAME = "Test AA Name";
            
    private Mockery context = new JUnit4Mockery();
    
    public AdapterGatewayPatientDiscoveryTest()
    {
    }

    /**
     * Test of respondingGatewayPRPAIN201305UV02 method, of class AdapterGatewayPatientDiscovery.
     */
    @Test
    public void testRespondingGatewayPRPAIN201305UV02NullRequest()
    {
        System.out.println("respondingGatewayPRPAIN201305UV02NullRequest");
        
        RespondingGatewayPRPAIN201305UV02RequestType request = null;
        AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();
        RespondingGatewayPRPAIN201306UV02ResponseType expResult = null;
        try {
            RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
            fail("This shouldn't happen!");
        }
        catch (Throwable t) {
            assertTrue(true);
        }
    }
    
    @Test
    public void testRespondingGatewayPRPAIN201305UV02()
    {
        System.out.println("respondingGatewayPRPAIN201305UV02");
        
        RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
        PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_SENDING_HCID,
                TEST_SENDING_AA,
                "666003333");
        request.setPRPAIN201305UV02(prpain201305UV02);
        
        Patient patient = HL7DbParser201305.ExtractMpiPatientFromMessage(prpain201305UV02);
        List<Patient> patients = new ArrayList<Patient>();
        patients.add(patient);
        final PRPAIN201306UV02 responseFromPartner = HL7DbParser201306.BuildMessageFromMpiPatients(patients, prpain201305UV02, TEST_RECEIVING_HCID, TEST_RECEIVING_AA);
        
        PRPAIN201305UV02 prpain201305UV02FromExternal = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_RECEIVING_HCID,
                TEST_RECEIVING_AA,
                "666003333");
         
        final PRPAIN201306UV02 responseFromMPI = HL7DbParser201306.BuildMessageFromMpiPatients(patients, prpain201305UV02FromExternal, TEST_SENDING_HCID, TEST_SENDING_AA);
        
        AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();
        
        final ExecutorService executorService = context.mock(ExecutorService.class);
        final AdapterMpiPortType adapterMpi = context.mock(AdapterMpiPortType.class);
        final PatientCorrelationPortType adapterPatientCorrelation = context.mock(PatientCorrelationPortType.class);
        final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
        final NhincComponentConnectionManagerPortType connectionManager = context.mock(NhincComponentConnectionManagerPortType.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);
        
        instance.setAdapterMpi(adapterMpi);
        instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
        instance.setAdapterPolicyEngine(adapterPolicyEngine);
        instance.setConnectionManager(connectionManager);
        instance.setExecutorService(executorService);
        instance.setFacilityManager(facilityManager);
        instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

        context.checking(new Expectations() {
        {
            ConnectionInfosType connectionInfos = new ConnectionInfosType();
            ConnectionInfoType connectionInfo = new ConnectionInfoType();
            connectionInfos.getConnectionInfo().add(connectionInfo);
            HomeCommunityType homeCommunity = new HomeCommunityType();
            connectionInfo.setHomeCommunity(homeCommunity);
            homeCommunity.setHomeCommunityId(TEST_RECEIVING_HCID);
            
            Facility facility = new Facility();
            facility.setFacilityNumber("VA");
            facility.setHomeCommunityId(TEST_SENDING_HCID);
            
            CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
            ResponseType response = new ResponseType();
            checkPolicyResponse.setResponse(response);
            ResultType result = new ResultType();
            response.getResult().add(result);
            result.setDecision(DecisionType.PERMIT);
            
            oneOf(connectionManager).getAllConnectionInfoSetByServiceName(with(any(GetAllConnectionInfoSetByServiceNameRequestType.class)));
            will(returnValue(connectionInfos));
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
            oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
            will(returnValue(checkPolicyResponse));
            oneOf(executorService).execute(with(any(Runnable.class)));
            will(RunTaskAction.runTask());
            oneOf(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)), with(any(AssertionType.class)), with(any(String.class)));
            will(returnValue(responseFromPartner));
            oneOf(adapterMpi).findCandidates(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
            will(returnValue(responseFromMPI));
            oneOf(adapterPatientCorrelation).addPatientCorrelation(with(any(AddPatientCorrelationRequestType.class)));
        }});
        
        RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
        assertEquals(1, result.getCommunityResponse().size());
        assertTrue(result.getCommunityResponse().get(0) != null
                   && result.getCommunityResponse().get(0).getPRPAIN201306UV02() != null
                   && result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess() != null
                   && NullChecker.isNotNullOrEmpty(result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess().getSubject()));
    }
    
    @Test
    public void testRespondingGatewayPRPAIN201305UV02Targeted()
    {
        System.out.println("respondingGatewayPRPAIN201305UV02Targeted");
        
        RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
        PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_SENDING_HCID,
                TEST_SENDING_AA,
                "666003333");
        request.setPRPAIN201305UV02(prpain201305UV02);
        
        NhinTargetCommunitiesType nhinTargetCommunities = new NhinTargetCommunitiesType();
        request.setNhinTargetCommunities(nhinTargetCommunities);
        NhinTargetCommunityType nhinTargetCommunity = new NhinTargetCommunityType();
        nhinTargetCommunities.getNhinTargetCommunity().add(nhinTargetCommunity);
        HomeCommunityType homeCommunity = new HomeCommunityType();
        nhinTargetCommunity.setHomeCommunity(homeCommunity);
        homeCommunity.setHomeCommunityId(TEST_RECEIVING_HCID);
        
        Patient patient = HL7DbParser201305.ExtractMpiPatientFromMessage(prpain201305UV02);
        List<Patient> patients = new ArrayList<Patient>();
        patients.add(patient);
        final PRPAIN201306UV02 responseFromPartner = HL7DbParser201306.BuildMessageFromMpiPatients(patients, prpain201305UV02, TEST_RECEIVING_HCID, TEST_RECEIVING_AA);
        
        PRPAIN201305UV02 prpain201305UV02FromExternal = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_RECEIVING_HCID,
                TEST_RECEIVING_AA,
                "666003333");
         
        final PRPAIN201306UV02 responseFromMPI = HL7DbParser201306.BuildMessageFromMpiPatients(patients, prpain201305UV02FromExternal, TEST_SENDING_HCID, TEST_SENDING_AA);
        
        AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();
        
        final ExecutorService executorService = context.mock(ExecutorService.class);
        final AdapterMpiPortType adapterMpi = context.mock(AdapterMpiPortType.class);
        final PatientCorrelationPortType adapterPatientCorrelation = context.mock(PatientCorrelationPortType.class);
        final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
        final NhincComponentConnectionManagerPortType connectionManager = context.mock(NhincComponentConnectionManagerPortType.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);
        
        instance.setAdapterMpi(adapterMpi);
        instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
        instance.setAdapterPolicyEngine(adapterPolicyEngine);
        instance.setConnectionManager(connectionManager);
        instance.setExecutorService(executorService);
        instance.setFacilityManager(facilityManager);
        instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

        context.checking(new Expectations() {
        {
            ConnectionInfosType connectionInfos = new ConnectionInfosType();
            ConnectionInfoType connectionInfo = new ConnectionInfoType();
            connectionInfos.getConnectionInfo().add(connectionInfo);
            HomeCommunityType homeCommunity = new HomeCommunityType();
            connectionInfo.setHomeCommunity(homeCommunity);
            homeCommunity.setHomeCommunityId(TEST_RECEIVING_HCID);
            
            Facility facility = new Facility();
            facility.setFacilityNumber("VA");
            facility.setHomeCommunityId(TEST_SENDING_HCID);
            
            CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
            ResponseType response = new ResponseType();
            checkPolicyResponse.setResponse(response);
            ResultType result = new ResultType();
            response.getResult().add(result);
            result.setDecision(DecisionType.PERMIT);
            
            never(connectionManager).getAllConnectionInfoSetByServiceName(with(any(GetAllConnectionInfoSetByServiceNameRequestType.class)));
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
            oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
            will(returnValue(checkPolicyResponse));
            oneOf(executorService).execute(with(any(Runnable.class)));
            will(RunTaskAction.runTask());
            oneOf(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)), with(any(AssertionType.class)), with(any(String.class)));
            will(returnValue(responseFromPartner));
            oneOf(adapterMpi).findCandidates(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
            will(returnValue(responseFromMPI));
            oneOf(adapterPatientCorrelation).addPatientCorrelation(with(any(AddPatientCorrelationRequestType.class)));
        }});
        
        RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
        assertEquals(1, result.getCommunityResponse().size());
        assertTrue(result.getCommunityResponse().get(0) != null
                   && result.getCommunityResponse().get(0).getPRPAIN201306UV02() != null
                   && result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess() != null
                   && NullChecker.isNotNullOrEmpty(result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess().getSubject()));
    }
    
    @Test
    public void testRespondingGatewayPRPAIN201305UV02NoMatchFromPartner()
    {
        System.out.println("respondingGatewayPRPAIN201305UV02NoMatchFromPartner");
        
        RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
        PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_SENDING_HCID,
                TEST_SENDING_AA,
                "666003333");
        request.setPRPAIN201305UV02(prpain201305UV02);
        
        final PRPAIN201306UV02 responseFromPartner = HL7DbParser201306.BuildMessageFromMpiPatients(null, prpain201305UV02, TEST_RECEIVING_HCID, TEST_RECEIVING_AA);
        
        AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();
        
        final ExecutorService executorService = context.mock(ExecutorService.class);
        final AdapterMpiPortType adapterMpi = context.mock(AdapterMpiPortType.class);
        final PatientCorrelationPortType adapterPatientCorrelation = context.mock(PatientCorrelationPortType.class);
        final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
        final NhincComponentConnectionManagerPortType connectionManager = context.mock(NhincComponentConnectionManagerPortType.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);
        
        instance.setAdapterMpi(adapterMpi);
        instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
        instance.setAdapterPolicyEngine(adapterPolicyEngine);
        instance.setConnectionManager(connectionManager);
        instance.setExecutorService(executorService);
        instance.setFacilityManager(facilityManager);
        instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

        context.checking(new Expectations() {
        {
            ConnectionInfosType connectionInfos = new ConnectionInfosType();
            ConnectionInfoType connectionInfo = new ConnectionInfoType();
            connectionInfos.getConnectionInfo().add(connectionInfo);
            HomeCommunityType homeCommunity = new HomeCommunityType();
            connectionInfo.setHomeCommunity(homeCommunity);
            homeCommunity.setHomeCommunityId(TEST_RECEIVING_HCID);
            
            Facility facility = new Facility();
            facility.setFacilityNumber("VA");
            facility.setHomeCommunityId(TEST_SENDING_HCID);
            
            CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
            ResponseType response = new ResponseType();
            checkPolicyResponse.setResponse(response);
            ResultType result = new ResultType();
            response.getResult().add(result);
            result.setDecision(DecisionType.PERMIT);
            
            oneOf(connectionManager).getAllConnectionInfoSetByServiceName(with(any(GetAllConnectionInfoSetByServiceNameRequestType.class)));
            will(returnValue(connectionInfos));
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
            oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
            will(returnValue(checkPolicyResponse));
            oneOf(executorService).execute(with(any(Runnable.class)));
            will(RunTaskAction.runTask());
            oneOf(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)), with(any(AssertionType.class)), with(any(String.class)));
            will(returnValue(responseFromPartner));
            never(adapterMpi).findCandidates(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
            never(adapterPatientCorrelation).addPatientCorrelation(with(any(AddPatientCorrelationRequestType.class)));
        }});
        
        RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
        assertEquals(1, result.getCommunityResponse().size());
        assertTrue(result.getCommunityResponse().get(0) != null
                   && result.getCommunityResponse().get(0).getPRPAIN201306UV02() != null
                   && result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess() != null
                   && NullChecker.isNullOrEmpty(result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess().getSubject()));
    }
    
    @Test
    public void testRespondingGatewayPRPAIN201305UV02MatchFromPartnerNoMatchFromVerify()
    {
        System.out.println("respondingGatewayPRPAIN201305UV02MatchFromPatnerNoMatchFromVerify");
        
        RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
        PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_SENDING_HCID,
                TEST_SENDING_AA,
                "666003333");
        request.setPRPAIN201305UV02(prpain201305UV02);
        
        Patient patient = HL7DbParser201305.ExtractMpiPatientFromMessage(prpain201305UV02);
        List<Patient> patients = new ArrayList<Patient>();
        patients.add(patient);
        final PRPAIN201306UV02 responseFromPartner = HL7DbParser201306.BuildMessageFromMpiPatients(patients, prpain201305UV02, TEST_RECEIVING_HCID, TEST_RECEIVING_AA);
        
        PRPAIN201305UV02 prpain201305UV02FromExternal = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_RECEIVING_HCID,
                TEST_RECEIVING_AA,
                "666003333");
         
        final PRPAIN201306UV02 responseFromMPI = HL7DbParser201306.BuildMessageFromMpiPatients(null, prpain201305UV02FromExternal, TEST_SENDING_HCID, TEST_SENDING_AA);
        
        AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();
        
        final ExecutorService executorService = context.mock(ExecutorService.class);
        final AdapterMpiPortType adapterMpi = context.mock(AdapterMpiPortType.class);
        final PatientCorrelationPortType adapterPatientCorrelation = context.mock(PatientCorrelationPortType.class);
        final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
        final NhincComponentConnectionManagerPortType connectionManager = context.mock(NhincComponentConnectionManagerPortType.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);
        
        instance.setAdapterMpi(adapterMpi);
        instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
        instance.setAdapterPolicyEngine(adapterPolicyEngine);
        instance.setConnectionManager(connectionManager);
        instance.setExecutorService(executorService);
        instance.setFacilityManager(facilityManager);
        instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

        context.checking(new Expectations() {
        {
            ConnectionInfosType connectionInfos = new ConnectionInfosType();
            ConnectionInfoType connectionInfo = new ConnectionInfoType();
            connectionInfos.getConnectionInfo().add(connectionInfo);
            HomeCommunityType homeCommunity = new HomeCommunityType();
            connectionInfo.setHomeCommunity(homeCommunity);
            homeCommunity.setHomeCommunityId(TEST_RECEIVING_HCID);
            
            Facility facility = new Facility();
            facility.setFacilityNumber("VA");
            facility.setHomeCommunityId(TEST_SENDING_HCID);
            
            CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
            ResponseType response = new ResponseType();
            checkPolicyResponse.setResponse(response);
            ResultType result = new ResultType();
            response.getResult().add(result);
            result.setDecision(DecisionType.PERMIT);
            
            oneOf(connectionManager).getAllConnectionInfoSetByServiceName(with(any(GetAllConnectionInfoSetByServiceNameRequestType.class)));
            will(returnValue(connectionInfos));
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
            oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
            will(returnValue(checkPolicyResponse));
            oneOf(executorService).execute(with(any(Runnable.class)));
            will(RunTaskAction.runTask());
            oneOf(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)), with(any(AssertionType.class)), with(any(String.class)));
            will(returnValue(responseFromPartner));
            oneOf(adapterMpi).findCandidates(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
            will(returnValue(responseFromMPI));
            never(adapterPatientCorrelation).addPatientCorrelation(with(any(AddPatientCorrelationRequestType.class)));
        }});
        
        RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
        assertEquals(1, result.getCommunityResponse().size());
        assertTrue(result.getCommunityResponse().get(0) != null
                   && result.getCommunityResponse().get(0).getPRPAIN201306UV02() != null
                   && result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess() != null
                   && NullChecker.isNullOrEmpty(result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess().getSubject()));
    }

    @Test
    public void testRespondingGatewayPRPAIN201305UV02CheckPolicyDeny()
    {
        System.out.println("respondingGatewayPRPAIN201305UV02CheckPolicyDeny");
        
        RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
        PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_SENDING_HCID,
                TEST_SENDING_AA,
                "666003333");
        request.setPRPAIN201305UV02(prpain201305UV02);
        
        AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();
        
        final ExecutorService executorService = context.mock(ExecutorService.class);
        final AdapterMpiPortType adapterMpi = context.mock(AdapterMpiPortType.class);
        final PatientCorrelationPortType adapterPatientCorrelation = context.mock(PatientCorrelationPortType.class);
        final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
        final NhincComponentConnectionManagerPortType connectionManager = context.mock(NhincComponentConnectionManagerPortType.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);
        
        instance.setAdapterMpi(adapterMpi);
        instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
        instance.setAdapterPolicyEngine(adapterPolicyEngine);
        instance.setConnectionManager(connectionManager);
        instance.setExecutorService(executorService);
        instance.setFacilityManager(facilityManager);
        instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

        context.checking(new Expectations() {
        {
            ConnectionInfosType connectionInfos = new ConnectionInfosType();
            ConnectionInfoType connectionInfo = new ConnectionInfoType();
            connectionInfos.getConnectionInfo().add(connectionInfo);
            HomeCommunityType homeCommunity = new HomeCommunityType();
            connectionInfo.setHomeCommunity(homeCommunity);
            homeCommunity.setHomeCommunityId(TEST_RECEIVING_HCID);
            
            Facility facility = new Facility();
            facility.setFacilityNumber("VA");
            facility.setHomeCommunityId(TEST_SENDING_HCID);
            
            CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
            ResponseType response = new ResponseType();
            checkPolicyResponse.setResponse(response);
            ResultType result = new ResultType();
            response.getResult().add(result);
            result.setDecision(DecisionType.DENY);
            
            oneOf(connectionManager).getAllConnectionInfoSetByServiceName(with(any(GetAllConnectionInfoSetByServiceNameRequestType.class)));
            will(returnValue(connectionInfos));
            oneOf(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
            oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
            will(returnValue(checkPolicyResponse));
            never(executorService).execute(with(any(Runnable.class)));
            never(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)), with(any(AssertionType.class)), with(any(String.class)));
        }});
        
        RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
        assertEquals(1, result.getCommunityResponse().size());
        assertTrue(result.getCommunityResponse().get(0) != null
                   && result.getCommunityResponse().get(0).getPRPAIN201306UV02() != null
                   && result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess() != null
                   && NullChecker.isNullOrEmpty(result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess().getSubject()));
    }
    
    @Test
    public void testRespondingGatewayPRPAIN201305UV02NHINSenderError()
    {
        System.out.println("respondingGatewayPRPAIN201305UV02NHINSenderError");
        
        RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
        PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_SENDING_HCID,
                TEST_SENDING_AA,
                "666003333");
        request.setPRPAIN201305UV02(prpain201305UV02);
        
        AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();
        
        final ExecutorService executorService = context.mock(ExecutorService.class);
        final AdapterMpiPortType adapterMpi = context.mock(AdapterMpiPortType.class);
        final PatientCorrelationPortType adapterPatientCorrelation = context.mock(PatientCorrelationPortType.class);
        final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
        final NhincComponentConnectionManagerPortType connectionManager = context.mock(NhincComponentConnectionManagerPortType.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);
        
        instance.setAdapterMpi(adapterMpi);
        instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
        instance.setAdapterPolicyEngine(adapterPolicyEngine);
        instance.setConnectionManager(connectionManager);
        instance.setExecutorService(executorService);
        instance.setFacilityManager(facilityManager);
        instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

        context.checking(new Expectations() {
        {
            ConnectionInfosType connectionInfos = new ConnectionInfosType();
            ConnectionInfoType connectionInfo = new ConnectionInfoType();
            connectionInfos.getConnectionInfo().add(connectionInfo);
            HomeCommunityType homeCommunity = new HomeCommunityType();
            connectionInfo.setHomeCommunity(homeCommunity);
            homeCommunity.setHomeCommunityId(TEST_RECEIVING_HCID);
            
            Facility facility = new Facility();
            facility.setFacilityNumber("VA");
            facility.setHomeCommunityId(TEST_SENDING_HCID);
            
            CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
            ResponseType response = new ResponseType();
            checkPolicyResponse.setResponse(response);
            ResultType result = new ResultType();
            response.getResult().add(result);
            result.setDecision(DecisionType.PERMIT);
            
            oneOf(connectionManager).getAllConnectionInfoSetByServiceName(with(any(GetAllConnectionInfoSetByServiceNameRequestType.class)));
            will(returnValue(connectionInfos));
            oneOf(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
            oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
            will(returnValue(checkPolicyResponse));
            oneOf(executorService).execute(with(any(Runnable.class)));
            will(RunTaskAction.runTask());
            oneOf(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)), with(any(AssertionType.class)), with(any(String.class)));
            will(throwException(new RuntimeException()));
        }});
        
        RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
        assertEquals(1, result.getCommunityResponse().size());
        assertTrue(result.getCommunityResponse().get(0) != null
                   && result.getCommunityResponse().get(0).getPRPAIN201306UV02() != null
                   && result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess() != null
                   && NullChecker.isNullOrEmpty(result.getCommunityResponse().get(0).getPRPAIN201306UV02().getControlActProcess().getSubject()));
    }
    
    @Test
    public void testRespondingGatewayPRPAIN201305UV02CheckPolicyException()
    {
        System.out.println("respondingGatewayPRPAIN201305UV02CheckPolicyException");
        
        RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
        PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_SENDING_HCID,
                TEST_SENDING_AA,
                "666003333");
        request.setPRPAIN201305UV02(prpain201305UV02);
        
        AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();
        
        final ExecutorService executorService = context.mock(ExecutorService.class);
        final AdapterMpiPortType adapterMpi = context.mock(AdapterMpiPortType.class);
        final PatientCorrelationPortType adapterPatientCorrelation = context.mock(PatientCorrelationPortType.class);
        final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
        final NhincComponentConnectionManagerPortType connectionManager = context.mock(NhincComponentConnectionManagerPortType.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);
        
        instance.setAdapterMpi(adapterMpi);
        instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
        instance.setAdapterPolicyEngine(adapterPolicyEngine);
        instance.setConnectionManager(connectionManager);
        instance.setExecutorService(executorService);
        instance.setFacilityManager(facilityManager);
        instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

        context.checking(new Expectations() {
        {
            ConnectionInfosType connectionInfos = new ConnectionInfosType();
            ConnectionInfoType connectionInfo = new ConnectionInfoType();
            connectionInfos.getConnectionInfo().add(connectionInfo);
            HomeCommunityType homeCommunity = new HomeCommunityType();
            connectionInfo.setHomeCommunity(homeCommunity);
            homeCommunity.setHomeCommunityId(TEST_RECEIVING_HCID);
            
            Facility facility = new Facility();
            facility.setFacilityNumber("VA");
            facility.setHomeCommunityId(TEST_SENDING_HCID);
            
            CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
            ResponseType response = new ResponseType();
            checkPolicyResponse.setResponse(response);
            ResultType result = new ResultType();
            response.getResult().add(result);
            result.setDecision(DecisionType.PERMIT);
            
            oneOf(connectionManager).getAllConnectionInfoSetByServiceName(with(any(GetAllConnectionInfoSetByServiceNameRequestType.class)));
            will(returnValue(connectionInfos));
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
            oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
            will(throwException(new RuntimeException()));
            never(executorService).execute(with(any(Runnable.class)));
            never(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)), with(any(AssertionType.class)), with(any(String.class)));
            never(adapterMpi).findCandidates(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
            never(adapterPatientCorrelation).addPatientCorrelation(with(any(AddPatientCorrelationRequestType.class)));
        }});
        
        try {
            RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
            fail("This shouldn't happen!");
        }
        catch (Throwable t) {
            assertTrue(true);
        }
    }
    
    @Test
    public void testRespondingGatewayPRPAIN201305UV02AdapterMpiException()
    {
        System.out.println("respondingGatewayPRPAIN201305UV02AdapterMpiException");
        
        RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
        PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_SENDING_HCID,
                TEST_SENDING_AA,
                "666003333");
        request.setPRPAIN201305UV02(prpain201305UV02);
        
        Patient patient = HL7DbParser201305.ExtractMpiPatientFromMessage(prpain201305UV02);
        List<Patient> patients = new ArrayList<Patient>();
        patients.add(patient);
        final PRPAIN201306UV02 responseFromPartner = HL7DbParser201306.BuildMessageFromMpiPatients(patients, prpain201305UV02, TEST_RECEIVING_HCID, TEST_RECEIVING_AA);
        
        AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();
        
        final ExecutorService executorService = context.mock(ExecutorService.class);
        final AdapterMpiPortType adapterMpi = context.mock(AdapterMpiPortType.class);
        final PatientCorrelationPortType adapterPatientCorrelation = context.mock(PatientCorrelationPortType.class);
        final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
        final NhincComponentConnectionManagerPortType connectionManager = context.mock(NhincComponentConnectionManagerPortType.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);
        
        instance.setAdapterMpi(adapterMpi);
        instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
        instance.setAdapterPolicyEngine(adapterPolicyEngine);
        instance.setConnectionManager(connectionManager);
        instance.setExecutorService(executorService);
        instance.setFacilityManager(facilityManager);
        instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

        context.checking(new Expectations() {
        {
            ConnectionInfosType connectionInfos = new ConnectionInfosType();
            ConnectionInfoType connectionInfo = new ConnectionInfoType();
            connectionInfos.getConnectionInfo().add(connectionInfo);
            HomeCommunityType homeCommunity = new HomeCommunityType();
            connectionInfo.setHomeCommunity(homeCommunity);
            homeCommunity.setHomeCommunityId(TEST_RECEIVING_HCID);
            
            Facility facility = new Facility();
            facility.setFacilityNumber("VA");
            facility.setHomeCommunityId(TEST_SENDING_HCID);
            
            CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
            ResponseType response = new ResponseType();
            checkPolicyResponse.setResponse(response);
            ResultType result = new ResultType();
            response.getResult().add(result);
            result.setDecision(DecisionType.PERMIT);
            
            oneOf(connectionManager).getAllConnectionInfoSetByServiceName(with(any(GetAllConnectionInfoSetByServiceNameRequestType.class)));
            will(returnValue(connectionInfos));
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
            oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
            will(returnValue(checkPolicyResponse));
            oneOf(executorService).execute(with(any(Runnable.class)));
            will(RunTaskAction.runTask());
            oneOf(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)), with(any(AssertionType.class)), with(any(String.class)));
            will(returnValue(responseFromPartner));
            oneOf(adapterMpi).findCandidates(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
            will(throwException(new RuntimeException()));
            never(adapterPatientCorrelation).addPatientCorrelation(with(any(AddPatientCorrelationRequestType.class)));
        }});
        
        try {
            RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
            fail("This shouldn't happen!");
        }
        catch (Throwable t) {
            assertTrue(true);
        }
    }

    @Test
    public void testRespondingGatewayPRPAIN201305UV02PatientCorrelationException()
    {
        System.out.println("respondingGatewayPRPAIN201305UV02PatientCorrelationException");
        
        RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
        PRPAIN201305UV02 prpain201305UV02 = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_SENDING_HCID,
                TEST_SENDING_AA,
                "666003333");
        request.setPRPAIN201305UV02(prpain201305UV02);
        
        Patient patient = HL7DbParser201305.ExtractMpiPatientFromMessage(prpain201305UV02);
        List<Patient> patients = new ArrayList<Patient>();
        patients.add(patient);
        final PRPAIN201306UV02 responseFromPartner = HL7DbParser201306.BuildMessageFromMpiPatients(patients, prpain201305UV02, TEST_RECEIVING_HCID, TEST_RECEIVING_AA);
        
        PRPAIN201305UV02 prpain201305UV02FromExternal = createPRPAIN201305(
                "Patient",
                Arrays.asList(new String[]{"Test"}),
                null,
                null,
                "20120724",
                "New Orleans",
                "LA",
                Arrays.asList(new String[]{"1234 Test Lane"}),
                "70143",
                "tel:+1-504-529-6111",
                "M",
                "no",
                "M",
                "1234567890V123456",
                TEST_RECEIVING_HCID,
                TEST_RECEIVING_AA,
                "666003333");
         
        final PRPAIN201306UV02 responseFromMPI = HL7DbParser201306.BuildMessageFromMpiPatients(patients, prpain201305UV02FromExternal, TEST_SENDING_HCID, TEST_SENDING_AA);
        
        AdapterGatewayPatientDiscovery instance = new AdapterGatewayPatientDiscovery();
        
        final ExecutorService executorService = context.mock(ExecutorService.class);
        final AdapterMpiPortType adapterMpi = context.mock(AdapterMpiPortType.class);
        final PatientCorrelationPortType adapterPatientCorrelation = context.mock(PatientCorrelationPortType.class);
        final AdapterPolicyEnginePortType adapterPolicyEngine = context.mock(AdapterPolicyEnginePortType.class);
        final NhincComponentConnectionManagerPortType connectionManager = context.mock(NhincComponentConnectionManagerPortType.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final NHINPatientDiscoverySender nhinPatientDiscoverySender = context.mock(NHINPatientDiscoverySender.class);
        
        instance.setAdapterMpi(adapterMpi);
        instance.setAdapterPatientCorrelation(adapterPatientCorrelation);
        instance.setAdapterPolicyEngine(adapterPolicyEngine);
        instance.setConnectionManager(connectionManager);
        instance.setExecutorService(executorService);
        instance.setFacilityManager(facilityManager);
        instance.setNhinPatientDiscoverySender(nhinPatientDiscoverySender);

        context.checking(new Expectations() {
        {
            ConnectionInfosType connectionInfos = new ConnectionInfosType();
            ConnectionInfoType connectionInfo = new ConnectionInfoType();
            connectionInfos.getConnectionInfo().add(connectionInfo);
            HomeCommunityType homeCommunity = new HomeCommunityType();
            connectionInfo.setHomeCommunity(homeCommunity);
            homeCommunity.setHomeCommunityId(TEST_RECEIVING_HCID);
            
            Facility facility = new Facility();
            facility.setFacilityNumber("VA");
            facility.setHomeCommunityId(TEST_SENDING_HCID);
            
            CheckPolicyResponseType checkPolicyResponse = new CheckPolicyResponseType();
            ResponseType response = new ResponseType();
            checkPolicyResponse.setResponse(response);
            ResultType result = new ResultType();
            response.getResult().add(result);
            result.setDecision(DecisionType.PERMIT);
            
            oneOf(connectionManager).getAllConnectionInfoSetByServiceName(with(any(GetAllConnectionInfoSetByServiceNameRequestType.class)));
            will(returnValue(connectionInfos));
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
            oneOf(adapterPolicyEngine).checkPolicy(with(any(CheckPolicyRequestType.class)));
            will(returnValue(checkPolicyResponse));
            oneOf(executorService).execute(with(any(Runnable.class)));
            will(RunTaskAction.runTask());
            oneOf(nhinPatientDiscoverySender).sendRequest(with(any(PRPAIN201305UV02.class)), with(any(AssertionType.class)), with(any(String.class)));
            will(returnValue(responseFromPartner));
            oneOf(adapterMpi).findCandidates(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
            will(returnValue(responseFromMPI));
            oneOf(adapterPatientCorrelation).addPatientCorrelation(with(any(AddPatientCorrelationRequestType.class)));
            will(throwException(new RuntimeException()));
        }});
        
        try {
            RespondingGatewayPRPAIN201306UV02ResponseType result = instance.respondingGatewayPRPAIN201305UV02(request);
            fail("This shouldn't happen!");
        }
        catch (Throwable t) {
            assertTrue(true);
        }
    }
    
    private PRPAIN201305UV02 createPRPAIN201305(String lastName,
                                                List<String> givenName,
                                                String prefix,
                                                String suffix,
                                                String dob,
                                                String city,
                                                String state,
                                                List<String> address,
                                                String zip,
                                                String phone,
                                                String gender,
                                                String multiBirth,
                                                String maritalStatus,
                                                String patientId,
                                                String homeCommunityId,
                                                String assigningAuthority,
                                                String ssn)
    {
        JAXBElement<PRPAMT201301UV02Person> patientPerson =
                buildPRPAIN201301PatientPerson(lastName,
                                               givenName,
                                               prefix,
                                               suffix,
                                               dob,
                                               city,
                                               state,
                                               address,
                                               zip,
                                               phone,
                                               gender,
                                               multiBirth,
                                               maritalStatus);

        II ii = new II();
        ii.setRoot(assigningAuthority);
        ii.setExtension(patientId);
        String assigningAuthorityName = TEST_AA_NAME;
        if (!NullChecker.isNullOrEmpty(assigningAuthorityName)) {
            ii.setAssigningAuthorityName(assigningAuthorityName);
        }

        PRPAMT201301UV02Patient patient =
                HL7PatientTransforms.create201301Patient(patientPerson, ii);

        PRPAIN201305UV02 ret =
                HL7PRPA201305Transforms.createPRPA201305(patient, homeCommunityId, "1.1", assigningAuthority);

        // add ssn.
        PRPAMT201306UV02ParameterList paramList = ret.getControlActProcess().getQueryByParameter().getValue().getParameterList();
        PRPAMT201306UV02LivingSubjectId ssnId = new PRPAMT201306UV02LivingSubjectId();
        ii = new II();
        ii.setRoot("2.16.840.1.113883.4.1");
        ii.setExtension(ssn);
        ssnId.getValue().add(ii);
        ST text = new ST();
        ssnId.setSemanticsText(text);
        paramList.getLivingSubjectId().add(ssnId);

        // fix the interaction id.
        ret.setInteractionId(HL7DataTransformHelper.IIFactory(HL7Constants.INTERACTION_ID_ROOT, "PRPA_IN201305UV02"));

        // fix the controlActProccess/code.
        ret.getControlActProcess().setCode(HL7DataTransformHelper.CDFactory("PRPA_TE201305UV02", HL7Constants.INTERACTION_ID_ROOT));

        // fix the acceptAckCode.
        ret.setAcceptAckCode(HL7DataTransformHelper.CSFactory("NE"));
        
        // fix the processingModeCode.
        ret.setProcessingModeCode(HL7DataTransformHelper.CSFactory("T"));
        
        ret.getControlActProcess().setClassCode(ActClassControlAct.CACT);
        ret.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().setClassCode("ASSIGNED");
        
        // fix the creation time of the message.
        TSExplicit te = new TSExplicit();
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        te.setValue(formatter.format(now));
        ret.setCreationTime(te);

        CS responseModalityCode = new CS();
        responseModalityCode.setCode("R");
        ret.getControlActProcess().getQueryByParameter().getValue().setResponseModalityCode(responseModalityCode);
        
        CS responsePriorityCode = new CS();
        responsePriorityCode.setCode("I");
        ret.getControlActProcess().getQueryByParameter().getValue().setResponsePriorityCode(responsePriorityCode);
                
        return ret;
    }

    private JAXBElement<PRPAMT201301UV02Person> buildPRPAIN201301PatientPerson(String lastName,
                                                                               List<String> givenName,
                                                                               String prefix,
                                                                               String suffix,
                                                                               String dob,
                                                                               String city,
                                                                               String state,
                                                                               List<String> address,
                                                                               String zip,
                                                                               String phone,
                                                                               String gender,
                                                                               String multiBirth,
                                                                               String maritalStatus)
    {
        PRPAMT201301UV02Person patientPerson = new PRPAMT201301UV02Person();

        //--------------------------------------------------------------
        //build name
        org.hl7.v3.ObjectFactory factory = new org.hl7.v3.ObjectFactory();
        PNExplicit name = (PNExplicit) (factory.createPNExplicit());
        List namelist = name.getContent();

        //Last name
        EnExplicitFamily familyName = new EnExplicitFamily();
        familyName.setPartType("FAM");
        familyName.setContent(lastName);
        namelist.add(factory.createPNExplicitFamily(familyName));

        //First name
        if (NullChecker.isNotNullOrEmpty(givenName)) {
            for (String n : givenName) {
                if (!NullChecker.isNullOrEmpty(n)) {
                    EnExplicitGiven gn = new EnExplicitGiven();
                    gn.setPartType("GIV");
                    gn.setContent(n);
                    namelist.add(factory.createPNExplicitGiven(gn));

                }
            }
        }

        EnExplicitPrefix pfx = new EnExplicitPrefix();
        pfx.setContent(prefix);
        pfx.setPartType("PFX");
        namelist.add(factory.createENExplicitPrefix(pfx));

        EnExplicitSuffix sfx = new EnExplicitSuffix();
        sfx.setContent(suffix);
        sfx.setPartType("SFX");
        namelist.add(factory.createENExplicitSuffix(sfx));

        patientPerson.getName().add(name);
        //------------------------------------------------------------


        //Date of Birth
        TSExplicit valueTSExplicit = new TSExplicit();
        valueTSExplicit.setValue(dob);
        patientPerson.setBirthTime(valueTSExplicit);


        //Gender
        CE valueCE = new CE();
        valueCE.setCode(gender);
        patientPerson.setAdministrativeGenderCode(valueCE);

        //-------------------------------------------------------------
        //  build address
        ADExplicit addr = (ADExplicit) (factory.createADExplicit());
        List addrlist = addr.getContent();

        //address
        AdxpExplicitCity valueCity = new AdxpExplicitCity();
        valueCity.setContent(city);
        addrlist.add(factory.createADExplicitCity(valueCity));

        AdxpExplicitState valueState = new AdxpExplicitState();
        valueState.setContent(state);
        addrlist.add(factory.createADExplicitState(valueState));

        if (NullChecker.isNotNullOrEmpty(address)) {
            for (String a : address) {
                if (!NullChecker.isNullOrEmpty(a)) {
                    AdxpExplicitStreetAddressLine line = new AdxpExplicitStreetAddressLine();
                    line.setContent(a);
                    addrlist.add(factory.createADExplicitStreetAddressLine(line));
                }
            }
        }
        
        AdxpExplicitPostalCode valueZip = new AdxpExplicitPostalCode();
        valueZip.setContent(zip);
        addrlist.add(factory.createADExplicitPostalCode(valueZip));


        patientPerson.getAddr().add(addr);
        //--------------------------------------------------------------


        //telephone
        TELExplicit valueTELE = new TELExplicit();
        valueTELE.setValue(phone);
        patientPerson.getTelecom().add(valueTELE);

        //multi birth
        BL valueBL = new BL();
        if (multiBirth == null || multiBirth.length() == 0 || multiBirth.startsWith("NO") || multiBirth.startsWith("no")) {
            valueBL.setValue(false);
        }
        else {
            valueBL.setValue(true);
        }
        patientPerson.setMultipleBirthInd(valueBL);  //BL value

        // marital status
        CE maritalStatusCode = new CE();
        maritalStatusCode.setCode(maritalStatus);
        patientPerson.setMaritalStatusCode(maritalStatusCode);

        return factory.createPRPAMT201301UV02PatientPatientPerson(patientPerson);
    }
}
