/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.adaptergateway.patientannounce;

import java.util.*;

import org.junit.*;
import org.junit.runner.*;
import static org.junit.Assert.*;

import gov.hhs.fha.nhinc.entitypatientdiscovery.*;
import org.jmock.*;
import org.jmock.integration.junit4.*;
import org.hl7.v3.*;

import gov.va.med.nhin.adapter.announcepatient.*;
import gov.va.med.nhin.adapter.audit.*;
import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.facilitymanager.*;
import gov.va.med.nhin.adapter.permission.*;
import gov.va.med.nhin.adapter.propertylookup.*;


/**
 *
 * @author       VAZQUD
 */
@RunWith(JMock.class)
public class AnnouncePatientTest
{
    private Mockery context = new JUnit4Mockery();
    
    public AnnouncePatientTest()
    {
    }

    /**
     * Test of announcePatient method, of class AnnouncePatient.
     */
    @Test
    public void testAnnouncePatientNullRequest()
    {
        System.out.println("announcePatientNullRequest");
        AnnouncePatientType body = null;
        AnnouncePatient instance = new AnnouncePatient();
        AnnouncePatientResponseType expResult = new AnnouncePatientResponseType();
        expResult.setReturn(-1);
        AnnouncePatientResponseType result = instance.announcePatient(body);
        assertEquals(expResult.getReturn(), result.getReturn());
    }
    
    @Test
    public void testAnnouncePatientNoPatientId()
    {
        System.out.println("announcePatientNoPatientId");
        AnnouncePatientType body = new AnnouncePatientType();
        AnnouncePatient instance = new AnnouncePatient();
        AnnouncePatientResponseType expResult = new AnnouncePatientResponseType();
        expResult.setReturn(-1);
        AnnouncePatientResponseType result = instance.announcePatient(body);
        assertEquals(expResult.getReturn(), result.getReturn());
    }
    
    @Test
    public void testAnnouncePatientInvalidPatientId()
    {
        System.out.println("announcePatientInvalidPatientId");
        
        final String patientId = "1234";
        AnnouncePatientType body = new AnnouncePatientType();
        body.setPatientId(patientId);
        
        AnnouncePatient instance = new AnnouncePatient();
        final DataManager dataManager = context.mock(DataManager.class);
        final DataQuery dataQuery = context.mock(DataQuery.class);

        instance.setDataManager(dataManager);
        
        context.checking(new Expectations() {
        {
            oneOf(dataManager).getQuery("Composite.findDemographics");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("icn", patientId);
            oneOf(dataQuery).getResults();
            will(returnValue(new ArrayList()));
        }});
        
        AnnouncePatientResponseType expResult = new AnnouncePatientResponseType();
        expResult.setReturn(0);
        
        AnnouncePatientResponseType result = instance.announcePatient(body);
        assertEquals(expResult.getReturn(), result.getReturn());
    }
    
    @Test
    public void testAnnouncePatientPatientNotFound()
    {
        System.out.println("testAnnouncePatientPatientNotFound");
        
        final String patientId = "123456789V123456";
        AnnouncePatientType body = new AnnouncePatientType();
        body.setPatientId(patientId);
        
        AnnouncePatient instance = new AnnouncePatient();
        final DataManager dataManager = context.mock(DataManager.class);
        final DataQuery dataQuery = context.mock(DataQuery.class);

        instance.setDataManager(dataManager);

        context.checking(new Expectations() {
        {
            List patients = new ArrayList();
            
            oneOf(dataManager).getQuery("Composite.findDemographics");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("icn", patientId);
            oneOf(dataQuery).getResults();
            will(returnValue(patients));
        }});
        
        AnnouncePatientResponseType expResult = new AnnouncePatientResponseType();
        expResult.setReturn(0);
        
        AnnouncePatientResponseType result = instance.announcePatient(body);
        assertEquals(expResult.getReturn(), result.getReturn());
    }
    
    @Test
    public void testAnnouncePatientNotEnoughInfo()
    {
        System.out.println("testAnnouncePatientNotEnoughInfo");
        
        final String patientId = "123456789V123456";
        AnnouncePatientType body = new AnnouncePatientType();
        body.setPatientId(patientId);
        
        AnnouncePatient instance = new AnnouncePatient();
        final DataManager dataManager = context.mock(DataManager.class);
        final DataQuery dataQuery = context.mock(DataQuery.class);
        
        instance.setDataManager(dataManager);
        
        context.checking(new Expectations() {
        {
            Map patient = new HashMap();
            List patients = new ArrayList<Map>();
            patients.add(patient);
            
            oneOf(dataManager).getQuery("Composite.findDemographics");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("icn", patientId);
            oneOf(dataQuery).getResults();
            will(returnValue(patients));
        }});
        
        
        AnnouncePatientResponseType expResult = new AnnouncePatientResponseType();
        expResult.setReturn(0);
        
        AnnouncePatientResponseType result = instance.announcePatient(body);
        assertEquals(expResult.getReturn(), result.getReturn());
    }
    
    @Test
    public void testAnnouncePatient()
    {
        System.out.println("testAnnouncePatient");
        
        final String patientId = "1234567890V123456";
        
        final Map demographics = new HashMap() {{
            put("nameGiven", new ArrayList() {{
                add("First");
                add("Middle");
            }});
            put("namePrefix", "Prefix");
            put("nameSuffix", "Suffix");
            put("nameFamily", "Family");
            put("genderCode", "gender");
            put("birthDate", "20121022");
            put("SSN", "666668888");
            put("MRN", "1234567890V123456");
        }};

        final Map demographicsExt = new HashMap() {{
            put("homeAddressStreet", new ArrayList() {{
                add("1234 Test Lane");
                add("Apt 37");
            }});
            put("homeAddressCity", "Test City");
            put("homeAddressState", "LA");
            put("homeAddressPostal", "70124");
            put("phoneHome", "tel:+1-333-777-8888");
            put("maritalStatusCod", "S");
            put("multipleBirthCode", "N");
        }};

        final Map patient = new HashMap() {{
            put("demographics", demographics);
            put("demographicsExt", demographicsExt);
            put("patientPreferredFacilityNumber", "TEST");
            put("patientPreferredFacilityName", "Test Facility");
        }};

        final List patients = new ArrayList() {{
            add(patient);
        }};

        final AnnouncePatientType body = new AnnouncePatientType();
        body.setPatientId(patientId);
        UserInfoType userInfo = new UserInfoType();
        userInfo.setFullName("Test User");
        userInfo.setUserId("      test");
        userInfo.setAuthenticationMethod("password");
        userInfo.setRole("testRole");
        body.setUserInfo(userInfo);

        final Facility facility = new Facility();
        facility.setFacilityNumber("TEST");
        facility.setFacilityName("Test Facility");
        facility.setHomeCommunityId("1.2.3.4.5");
        facility.setFullHomeCommunityId("urn:oid:1.2.3.4.5");
        
        final Audit expAudit = new Audit();
        expAudit.setAction("Announce");
        expAudit.setDetails(
            "ssn=" + demographics.get("SSN")
            + ", lastName=" + demographics.get("nameFamily")
            + ", middleName=" + ((List)demographics.get("nameGiven")).get(1)
            + ", givenName=" + ((List)demographics.get("nameGiven")).get(0)
            + ", prefix=" + demographics.get("namePrefix")
            + ", suffix=" + demographics.get("nameSuffix")
            + ", dob=" + demographics.get("birthDate")
            + ", address[0]=" + ((List)demographicsExt.get("homeAddressStreet")).get(0)
            + ", address[1]=" + ((List)demographicsExt.get("homeAddressStreet")).get(1)
            + ", city=" + demographicsExt.get("homeAddressCity")
            + ", state=" + demographicsExt.get("homeAddressState")
            + ", zip=" + demographicsExt.get("homeAddressPostal")
            + ", phone=" + demographicsExt.get("phoneHome")
            + ", gender=" + demographics.get("genderCode")
            + ", multiBirth=" + demographicsExt.get("multipleBirthCode")
            + ", maritalStatus=" + demographicsExt.get("maritalStatusCode")
            + ", patientId=" + demographics.get("MRN")
            + ", homeCommunityId=1.2.3.4.5"
        );
        expAudit.setOrganizationId("urn:oid:1.2.3.4.5");
        expAudit.setPatientFacilityName("Test Facility");
        expAudit.setPatientFacilityNumber("TEST");
        expAudit.setPatientGivenName(((List<String>)demographics.get("nameGiven")).get(0));
        expAudit.setPatientId((String)demographics.get("MRN"));
        expAudit.setPatientLastName((String)demographics.get("nameFamily"));
        expAudit.setPatientSSN((String)demographics.get("SSN"));
        expAudit.setPurposeForUse("TREATMENT");
        expAudit.setUserFacilityName(facility.getFacilityName());
        expAudit.setUserFacilityNumber(facility.getFullHomeCommunityId());
        expAudit.setUserId(body.getUserInfo().getUserId() + ", CN=" + body.getUserInfo().getFullName() + ", O=" + facility.getFacilityName());
        expAudit.setUserName(body.getUserInfo().getFullName());
        expAudit.setUserRole("224608005");

        final List<Map> roles = new ArrayList<Map>();
        Map role = new HashMap();
        role.put("name", "ROLE");
        roles.add(role);

        final RespondingGatewayPRPAIN201306UV02ResponseType response = new RespondingGatewayPRPAIN201306UV02ResponseType();
        response.getCommunityResponse().add(new CommunityPRPAIN201306UV02ResponseType());
        
        AnnouncePatient instance = new AnnouncePatient();
        
        final DataManager dataManager = context.mock(DataManager.class);
        final DataQuery dataQuery = context.mock(DataQuery.class);
        final PropertyLookup propertyLookup = context.mock(PropertyLookup.class);
        final AuditManager auditManager = context.mock(AuditManager.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final EntityPatientDiscoveryPortType entityPatientDiscovery = context.mock(EntityPatientDiscoveryPortType.class);
        
        instance.setDataManager(dataManager);
        instance.setPropertyLookup(propertyLookup);
        instance.setAuditManager(auditManager);
        instance.setFacilityManager(facilityManager);
        instance.setEntityPatientDiscovery(entityPatientDiscovery);
        
        context.checking(new Expectations() {
        {
            oneOf(dataManager).getQuery("Composite.findDemographics");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("icn", patientId);
            oneOf(dataQuery).getResults();
            will(returnValue(patients));
            
            oneOf(dataManager).getQuery("STS.lookupSNOMED");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("code", "224608005");
            oneOf(dataQuery).getResults();
            will(returnValue(roles));
            
            oneOf(auditManager).storeAudit(with(equal(expAudit)));
            
            oneOf(entityPatientDiscovery).respondingGatewayPRPAIN201305UV02(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
            will(returnValue(response));

            allowing(propertyLookup).getProperty(with(any(String.class)));
            will(returnValue("property"));
            
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
        }});
        
        AnnouncePatientResponseType expResult = new AnnouncePatientResponseType();
        expResult.setReturn(1);
        
        AnnouncePatientResponseType result = instance.announcePatient(body);
        assertEquals(expResult.getReturn(), result.getReturn());
    }
    
    @Test
    public void testAnnouncePatientNoMiddleName()
    {
        System.out.println("testAnnouncePatientNoMiddleName");
        
        final String patientId = "1234567890V123456";
        
        final Map demographics = new HashMap() {{
            put("nameGiven", new ArrayList() {{
                add("First");
            }});
            put("namePrefix", "Prefix");
            put("nameSuffix", "Suffix");
            put("nameFamily", "Family");
            put("genderCode", "gender");
            put("birthDate", "20121022");
            put("SSN", "666668888");
            put("MRN", "1234567890V123456");
        }};

        final Map demographicsExt = new HashMap() {{
            put("homeAddressStreet", new ArrayList() {{
                add("1234 Test Lane");
                add("Apt 37");
            }});
            put("homeAddressCity", "Test City");
            put("homeAddressState", "LA");
            put("homeAddressPostal", "70124");
            put("phoneHome", "tel:+1-333-777-8888");
            put("maritalStatusCod", "S");
            put("multipleBirthCode", "N");
        }};

        final Map patient = new HashMap() {{
            put("demographics", demographics);
            put("demographicsExt", demographicsExt);
            put("patientPreferredFacilityNumber", "TEST");
            put("patientPreferredFacilityName", "Test Facility");
        }};

        final List patients = new ArrayList() {{
            add(patient);
        }};

        final AnnouncePatientType body = new AnnouncePatientType();
        body.setPatientId(patientId);
        UserInfoType userInfo = new UserInfoType();
        userInfo.setFullName("Test User");
        userInfo.setUserId("      test");
        userInfo.setAuthenticationMethod("password");
        userInfo.setRole("testRole");
        body.setUserInfo(userInfo);

        final Facility facility = new Facility();
        facility.setFacilityNumber("TEST");
        facility.setFacilityName("Test Facility");
        facility.setHomeCommunityId("1.2.3.4.5");
        facility.setFullHomeCommunityId("urn:oid:1.2.3.4.5");
        
        final Audit expAudit = new Audit();
        expAudit.setAction("Announce");
        expAudit.setDetails(
            "ssn=" + demographics.get("SSN")
            + ", lastName=" + demographics.get("nameFamily")
            + ", middleName="
            + ", givenName=" + ((List)demographics.get("nameGiven")).get(0)
            + ", prefix=" + demographics.get("namePrefix")
            + ", suffix=" + demographics.get("nameSuffix")
            + ", dob=" + demographics.get("birthDate")
            + ", address[0]=" + ((List)demographicsExt.get("homeAddressStreet")).get(0)
            + ", address[1]=" + ((List)demographicsExt.get("homeAddressStreet")).get(1)
            + ", city=" + demographicsExt.get("homeAddressCity")
            + ", state=" + demographicsExt.get("homeAddressState")
            + ", zip=" + demographicsExt.get("homeAddressPostal")
            + ", phone=" + demographicsExt.get("phoneHome")
            + ", gender=" + demographics.get("genderCode")
            + ", multiBirth=" + demographicsExt.get("multipleBirthCode")
            + ", maritalStatus=" + demographicsExt.get("maritalStatusCode")
            + ", patientId=" + demographics.get("MRN")
            + ", homeCommunityId=1.2.3.4.5"
        );
        expAudit.setOrganizationId("urn:oid:1.2.3.4.5");
        expAudit.setPatientFacilityName("Test Facility");
        expAudit.setPatientFacilityNumber("TEST");
        expAudit.setPatientGivenName(((List<String>)demographics.get("nameGiven")).get(0));
        expAudit.setPatientId((String)demographics.get("MRN"));
        expAudit.setPatientLastName((String)demographics.get("nameFamily"));
        expAudit.setPatientSSN((String)demographics.get("SSN"));
        expAudit.setPurposeForUse("TREATMENT");
        expAudit.setUserFacilityName(facility.getFacilityName());
        expAudit.setUserFacilityNumber(facility.getFullHomeCommunityId());
        expAudit.setUserId(body.getUserInfo().getUserId() + ", CN=" + body.getUserInfo().getFullName() + ", O=" + facility.getFacilityName());
        expAudit.setUserName(body.getUserInfo().getFullName());
        expAudit.setUserRole("224608005");

        final List<Map> roles = new ArrayList<Map>();
        Map role = new HashMap();
        role.put("name", "ROLE");
        roles.add(role);

        final RespondingGatewayPRPAIN201306UV02ResponseType response = new RespondingGatewayPRPAIN201306UV02ResponseType();
        response.getCommunityResponse().add(new CommunityPRPAIN201306UV02ResponseType());
        
        AnnouncePatient instance = new AnnouncePatient();
        
        final DataManager dataManager = context.mock(DataManager.class);
        final DataQuery dataQuery = context.mock(DataQuery.class);
        final PropertyLookup propertyLookup = context.mock(PropertyLookup.class);
        final AuditManager auditManager = context.mock(AuditManager.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final EntityPatientDiscoveryPortType entityPatientDiscovery = context.mock(EntityPatientDiscoveryPortType.class);
        
        instance.setDataManager(dataManager);
        instance.setPropertyLookup(propertyLookup);
        instance.setAuditManager(auditManager);
        instance.setFacilityManager(facilityManager);
        instance.setEntityPatientDiscovery(entityPatientDiscovery);
        
        context.checking(new Expectations() {
        {
            oneOf(dataManager).getQuery("Composite.findDemographics");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("icn", patientId);
            oneOf(dataQuery).getResults();
            will(returnValue(patients));
            
            oneOf(dataManager).getQuery("STS.lookupSNOMED");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("code", "224608005");
            oneOf(dataQuery).getResults();
            will(returnValue(roles));
            
            oneOf(auditManager).storeAudit(with(equal(expAudit)));
            
            oneOf(entityPatientDiscovery).respondingGatewayPRPAIN201305UV02(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
            will(returnValue(response));

            allowing(propertyLookup).getProperty(with(any(String.class)));
            will(returnValue("property"));
            
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
        }});
        
        AnnouncePatientResponseType expResult = new AnnouncePatientResponseType();
        expResult.setReturn(1);
        
        AnnouncePatientResponseType result = instance.announcePatient(body);
        assertEquals(expResult.getReturn(), result.getReturn());
    }
    
    @Test
    public void testAnnouncePatientTargeted()
    {
        System.out.println("testAnnouncePatientTargeted");
        
        final String patientId = "1234567890V123456";
        
        final Map demographics = new HashMap() {{
            put("nameGiven", new ArrayList() {{
                add("First");
                add("Middle");
            }});
            put("namePrefix", "Prefix");
            put("nameSuffix", "Suffix");
            put("nameFamily", "Family");
            put("genderCode", "gender");
            put("birthDate", "20121022");
            put("SSN", "666668888");
            put("MRN", "1234567890V123456");
        }};

        final Map demographicsExt = new HashMap() {{
            put("homeAddressStreet", new ArrayList() {{
                add("1234 Test Lane");
                add("Apt 37");
            }});
            put("homeAddressCity", "Test City");
            put("homeAddressState", "LA");
            put("homeAddressPostal", "70124");
            put("phoneHome", "tel:+1-333-777-8888");
            put("maritalStatusCod", "S");
            put("multipleBirthCode", "N");
        }};

        final Map patient = new HashMap() {{
            put("demographics", demographics);
            put("demographicsExt", demographicsExt);
            put("patientPreferredFacilityNumber", "TEST");
            put("patientPreferredFacilityName", "Test Facility");
        }};

        final List patients = new ArrayList() {{
            add(patient);
        }};

        final AnnouncePatientType body = new AnnouncePatientType();
        body.setPatientId(patientId);
        UserInfoType userInfo = new UserInfoType();
        userInfo.setFullName("Test User");
        userInfo.setUserId("      test");
        userInfo.setAuthenticationMethod("password");
        userInfo.setRole("testRole");
        body.setUserInfo(userInfo);
        AnnouncePatientType.Facilities facilities = new AnnouncePatientType.Facilities();
        body.setFacilities(facilities);
        final String testFacility = "200TEST";
        facilities.getFacility().add(testFacility);
        
        final Facility facility = new Facility();
        facility.setFacilityNumber("TEST");
        facility.setFacilityName("Test Facility");
        facility.setHomeCommunityId("1.2.3.4.5");
        facility.setFullHomeCommunityId("urn:oid:1.2.3.4.5");
        
        final Audit expAudit = new Audit();
        expAudit.setAction("Announce");
        expAudit.setDetails(
            "ssn=" + demographics.get("SSN")
            + ", lastName=" + demographics.get("nameFamily")
            + ", middleName=" + ((List)demographics.get("nameGiven")).get(1)
            + ", givenName=" + ((List)demographics.get("nameGiven")).get(0)
            + ", prefix=" + demographics.get("namePrefix")
            + ", suffix=" + demographics.get("nameSuffix")
            + ", dob=" + demographics.get("birthDate")
            + ", address[0]=" + ((List)demographicsExt.get("homeAddressStreet")).get(0)
            + ", address[1]=" + ((List)demographicsExt.get("homeAddressStreet")).get(1)
            + ", city=" + demographicsExt.get("homeAddressCity")
            + ", state=" + demographicsExt.get("homeAddressState")
            + ", zip=" + demographicsExt.get("homeAddressPostal")
            + ", phone=" + demographicsExt.get("phoneHome")
            + ", gender=" + demographics.get("genderCode")
            + ", multiBirth=" + demographicsExt.get("multipleBirthCode")
            + ", maritalStatus=" + demographicsExt.get("maritalStatusCode")
            + ", patientId=" + demographics.get("MRN")
            + ", homeCommunityId=1.2.3.4.5"
        );
        expAudit.setOrganizationId("urn:oid:1.2.3.4.5");
        expAudit.setPatientFacilityName("Test Facility");
        expAudit.setPatientFacilityNumber("TEST");
        expAudit.setPatientGivenName(((List<String>)demographics.get("nameGiven")).get(0));
        expAudit.setPatientId((String)demographics.get("MRN"));
        expAudit.setPatientLastName((String)demographics.get("nameFamily"));
        expAudit.setPatientSSN((String)demographics.get("SSN"));
        expAudit.setPurposeForUse("TREATMENT");
        expAudit.setUserFacilityName(facility.getFacilityName());
        expAudit.setUserFacilityNumber(facility.getFullHomeCommunityId());
        expAudit.setUserId(body.getUserInfo().getUserId() + ", CN=" + body.getUserInfo().getFullName() + ", O=" + facility.getFacilityName());
        expAudit.setUserName(body.getUserInfo().getFullName());
        expAudit.setUserRole("224608005");

        final List<Map> roles = new ArrayList<Map>();
        Map role = new HashMap();
        role.put("name", "ROLE");
        roles.add(role);

        final RespondingGatewayPRPAIN201306UV02ResponseType response = new RespondingGatewayPRPAIN201306UV02ResponseType();
        response.getCommunityResponse().add(new CommunityPRPAIN201306UV02ResponseType());
        
        AnnouncePatient instance = new AnnouncePatient();
        
        final DataManager dataManager = context.mock(DataManager.class);
        final DataQuery dataQuery = context.mock(DataQuery.class);
        final PropertyLookup propertyLookup = context.mock(PropertyLookup.class);
        final AuditManager auditManager = context.mock(AuditManager.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final EntityPatientDiscoveryPortType entityPatientDiscovery = context.mock(EntityPatientDiscoveryPortType.class);
        
        instance.setDataManager(dataManager);
        instance.setPropertyLookup(propertyLookup);
        instance.setAuditManager(auditManager);
        instance.setFacilityManager(facilityManager);
        instance.setEntityPatientDiscovery(entityPatientDiscovery);
        
        context.checking(new Expectations() {
        {
            oneOf(dataManager).getQuery("Composite.findDemographics");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("icn", patientId);
            oneOf(dataQuery).getResults();
            will(returnValue(patients));
            
            oneOf(dataManager).getQuery("STS.lookupSNOMED");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("code", "224608005");
            oneOf(dataQuery).getResults();
            will(returnValue(roles));
            
            oneOf(auditManager).storeAudit(with(equal(expAudit)));
            
            oneOf(entityPatientDiscovery).respondingGatewayPRPAIN201305UV02(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
            will(returnValue(response));

            allowing(propertyLookup).getProperty(with(any(String.class)));
            will(returnValue("property"));
            
            oneOf(facilityManager).getFacilityByFacilityNumber(testFacility);
            will(returnValue(facility));
            
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
        }});
        
        AnnouncePatientResponseType expResult = new AnnouncePatientResponseType();
        expResult.setReturn(1);
        
        AnnouncePatientResponseType result = instance.announcePatient(body);
        assertEquals(expResult.getReturn(), result.getReturn());
    }
    
    @Test
    public void testAnnouncePatientTargetedInvalidFacilityNumber()
    {
        System.out.println("testAnnouncePatientTargetedInvalidFacilityNumber");
        
        final String patientId = "1234567890V123456";
        
        final Map demographics = new HashMap() {{
            put("nameGiven", new ArrayList() {{
                add("First");
                add("Middle");
            }});
            put("namePrefix", "Prefix");
            put("nameSuffix", "Suffix");
            put("nameFamily", "Family");
            put("genderCode", "gender");
            put("birthDate", "20121022");
            put("SSN", "666668888");
            put("MRN", "1234567890V123456");
        }};

        final Map demographicsExt = new HashMap() {{
            put("homeAddressStreet", new ArrayList() {{
                add("1234 Test Lane");
                add("Apt 37");
            }});
            put("homeAddressCity", "Test City");
            put("homeAddressState", "LA");
            put("homeAddressPostal", "70124");
            put("phoneHome", "tel:+1-333-777-8888");
            put("maritalStatusCod", "S");
            put("multipleBirthCode", "N");
        }};

        final Map patient = new HashMap() {{
            put("demographics", demographics);
            put("demographicsExt", demographicsExt);
            put("patientPreferredFacilityNumber", "TEST");
            put("patientPreferredFacilityName", "Test Facility");
        }};

        final List patients = new ArrayList() {{
            add(patient);
        }};

        final AnnouncePatientType body = new AnnouncePatientType();
        body.setPatientId(patientId);
        UserInfoType userInfo = new UserInfoType();
        userInfo.setFullName("Test User");
        userInfo.setUserId("      test");
        userInfo.setAuthenticationMethod("password");
        userInfo.setRole("testRole");
        body.setUserInfo(userInfo);
        AnnouncePatientType.Facilities facilities = new AnnouncePatientType.Facilities();
        body.setFacilities(facilities);
        final String testFacility = "200TEST";
        facilities.getFacility().add(testFacility);
        
        final Facility facility = new Facility();
        facility.setFacilityNumber("TEST");
        facility.setFacilityName("Test Facility");
        facility.setHomeCommunityId("1.2.3.4.5");
        facility.setFullHomeCommunityId("urn:oid:1.2.3.4.5");
        
        final Audit expAudit = new Audit();
        expAudit.setAction("Announce");
        expAudit.setDetails(
            "ssn=" + demographics.get("SSN")
            + ", lastName=" + demographics.get("nameFamily")
            + ", middleName=" + ((List)demographics.get("nameGiven")).get(1)
            + ", givenName=" + ((List)demographics.get("nameGiven")).get(0)
            + ", prefix=" + demographics.get("namePrefix")
            + ", suffix=" + demographics.get("nameSuffix")
            + ", dob=" + demographics.get("birthDate")
            + ", address[0]=" + ((List)demographicsExt.get("homeAddressStreet")).get(0)
            + ", address[1]=" + ((List)demographicsExt.get("homeAddressStreet")).get(1)
            + ", city=" + demographicsExt.get("homeAddressCity")
            + ", state=" + demographicsExt.get("homeAddressState")
            + ", zip=" + demographicsExt.get("homeAddressPostal")
            + ", phone=" + demographicsExt.get("phoneHome")
            + ", gender=" + demographics.get("genderCode")
            + ", multiBirth=" + demographicsExt.get("multipleBirthCode")
            + ", maritalStatus=" + demographicsExt.get("maritalStatusCode")
            + ", patientId=" + demographics.get("MRN")
            + ", homeCommunityId=1.2.3.4.5"
        );
        expAudit.setOrganizationId("urn:oid:1.2.3.4.5");
        expAudit.setPatientFacilityName("Test Facility");
        expAudit.setPatientFacilityNumber("TEST");
        expAudit.setPatientGivenName(((List<String>)demographics.get("nameGiven")).get(0));
        expAudit.setPatientId((String)demographics.get("MRN"));
        expAudit.setPatientLastName((String)demographics.get("nameFamily"));
        expAudit.setPatientSSN((String)demographics.get("SSN"));
        expAudit.setPurposeForUse("TREATMENT");
        expAudit.setUserFacilityName(facility.getFacilityName());
        expAudit.setUserFacilityNumber(facility.getFullHomeCommunityId());
        expAudit.setUserId(body.getUserInfo().getUserId() + ", CN=" + body.getUserInfo().getFullName() + ", O=" + facility.getFacilityName());
        expAudit.setUserName(body.getUserInfo().getFullName());
        expAudit.setUserRole("224608005");

        final List<Map> roles = new ArrayList<Map>();
        Map role = new HashMap();
        role.put("name", "ROLE");
        roles.add(role);

        final RespondingGatewayPRPAIN201306UV02ResponseType response = new RespondingGatewayPRPAIN201306UV02ResponseType();
        response.getCommunityResponse().add(new CommunityPRPAIN201306UV02ResponseType());
        
        AnnouncePatient instance = new AnnouncePatient();
        
        final DataManager dataManager = context.mock(DataManager.class);
        final DataQuery dataQuery = context.mock(DataQuery.class);
        final PropertyLookup propertyLookup = context.mock(PropertyLookup.class);
        final AuditManager auditManager = context.mock(AuditManager.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final EntityPatientDiscoveryPortType entityPatientDiscovery = context.mock(EntityPatientDiscoveryPortType.class);
        
        instance.setDataManager(dataManager);
        instance.setPropertyLookup(propertyLookup);
        instance.setAuditManager(auditManager);
        instance.setFacilityManager(facilityManager);
        instance.setEntityPatientDiscovery(entityPatientDiscovery);
        
        context.checking(new Expectations() {
        {
            oneOf(dataManager).getQuery("Composite.findDemographics");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("icn", patientId);
            oneOf(dataQuery).getResults();
            will(returnValue(patients));
            
            oneOf(dataManager).getQuery("STS.lookupSNOMED");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("code", "224608005");
            oneOf(dataQuery).getResults();
            will(returnValue(roles));
            
            oneOf(auditManager).storeAudit(with(equal(expAudit)));
            
            never(entityPatientDiscovery).respondingGatewayPRPAIN201305UV02(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));

            allowing(propertyLookup).getProperty(with(any(String.class)));
            will(returnValue("property"));
            
            oneOf(facilityManager).getFacilityByFacilityNumber(testFacility);
            will(returnValue(null));
            
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
        }});
        
        AnnouncePatientResponseType expResult = new AnnouncePatientResponseType();
        expResult.setReturn(0);
        
        AnnouncePatientResponseType result = instance.announcePatient(body);
        assertEquals(expResult.getReturn(), result.getReturn());
    }
    
    @Test
    public void testAnnouncePatientTargetedEntityPDThrowsException()
    {
        System.out.println("testAnnouncePatientTargetedEntityPDThrowsException");
        
        final String patientId = "1234567890V123456";
        
        final Map demographics = new HashMap() {{
            put("nameGiven", new ArrayList() {{
                add("First");
                add("Middle");
            }});
            put("namePrefix", "Prefix");
            put("nameSuffix", "Suffix");
            put("nameFamily", "Family");
            put("genderCode", "gender");
            put("birthDate", "20121022");
            put("SSN", "666668888");
            put("MRN", "1234567890V123456");
        }};

        final Map demographicsExt = new HashMap() {{
            put("homeAddressStreet", new ArrayList() {{
                add("1234 Test Lane");
                add("Apt 37");
            }});
            put("homeAddressCity", "Test City");
            put("homeAddressState", "LA");
            put("homeAddressPostal", "70124");
            put("phoneHome", "tel:+1-333-777-8888");
            put("maritalStatusCod", "S");
            put("multipleBirthCode", "N");
        }};

        final Map patient = new HashMap() {{
            put("demographics", demographics);
            put("demographicsExt", demographicsExt);
            put("patientPreferredFacilityNumber", "TEST");
            put("patientPreferredFacilityName", "Test Facility");
        }};

        final List patients = new ArrayList() {{
            add(patient);
        }};

        final AnnouncePatientType body = new AnnouncePatientType();
        body.setPatientId(patientId);
        UserInfoType userInfo = new UserInfoType();
        userInfo.setFullName("Test User");
        userInfo.setUserId("      test");
        userInfo.setAuthenticationMethod("password");
        userInfo.setRole("testRole");
        body.setUserInfo(userInfo);
        AnnouncePatientType.Facilities facilities = new AnnouncePatientType.Facilities();
        body.setFacilities(facilities);
        final String testFacility = "200TEST";
        facilities.getFacility().add(testFacility);
        
        final Facility facility = new Facility();
        facility.setFacilityNumber("TEST");
        facility.setFacilityName("Test Facility");
        facility.setHomeCommunityId("1.2.3.4.5");
        facility.setFullHomeCommunityId("urn:oid:1.2.3.4.5");
        
        final Audit expAudit = new Audit();
        expAudit.setAction("Announce");
        expAudit.setDetails(
            "ssn=" + demographics.get("SSN")
            + ", lastName=" + demographics.get("nameFamily")
            + ", middleName=" + ((List)demographics.get("nameGiven")).get(1)
            + ", givenName=" + ((List)demographics.get("nameGiven")).get(0)
            + ", prefix=" + demographics.get("namePrefix")
            + ", suffix=" + demographics.get("nameSuffix")
            + ", dob=" + demographics.get("birthDate")
            + ", address[0]=" + ((List)demographicsExt.get("homeAddressStreet")).get(0)
            + ", address[1]=" + ((List)demographicsExt.get("homeAddressStreet")).get(1)
            + ", city=" + demographicsExt.get("homeAddressCity")
            + ", state=" + demographicsExt.get("homeAddressState")
            + ", zip=" + demographicsExt.get("homeAddressPostal")
            + ", phone=" + demographicsExt.get("phoneHome")
            + ", gender=" + demographics.get("genderCode")
            + ", multiBirth=" + demographicsExt.get("multipleBirthCode")
            + ", maritalStatus=" + demographicsExt.get("maritalStatusCode")
            + ", patientId=" + demographics.get("MRN")
            + ", homeCommunityId=1.2.3.4.5"
        );
        expAudit.setOrganizationId("urn:oid:1.2.3.4.5");
        expAudit.setPatientFacilityName("Test Facility");
        expAudit.setPatientFacilityNumber("TEST");
        expAudit.setPatientGivenName(((List<String>)demographics.get("nameGiven")).get(0));
        expAudit.setPatientId((String)demographics.get("MRN"));
        expAudit.setPatientLastName((String)demographics.get("nameFamily"));
        expAudit.setPatientSSN((String)demographics.get("SSN"));
        expAudit.setPurposeForUse("TREATMENT");
        expAudit.setUserFacilityName(facility.getFacilityName());
        expAudit.setUserFacilityNumber(facility.getFullHomeCommunityId());
        expAudit.setUserId(body.getUserInfo().getUserId() + ", CN=" + body.getUserInfo().getFullName() + ", O=" + facility.getFacilityName());
        expAudit.setUserName(body.getUserInfo().getFullName());
        expAudit.setUserRole("224608005");

        final List<Map> roles = new ArrayList<Map>();
        Map role = new HashMap();
        role.put("name", "ROLE");
        roles.add(role);

        final RespondingGatewayPRPAIN201306UV02ResponseType response = new RespondingGatewayPRPAIN201306UV02ResponseType();
        response.getCommunityResponse().add(new CommunityPRPAIN201306UV02ResponseType());
        
        AnnouncePatient instance = new AnnouncePatient();
        
        final DataManager dataManager = context.mock(DataManager.class);
        final DataQuery dataQuery = context.mock(DataQuery.class);
        final PropertyLookup propertyLookup = context.mock(PropertyLookup.class);
        final AuditManager auditManager = context.mock(AuditManager.class);
        final FacilityManager facilityManager = context.mock(FacilityManager.class);
        final EntityPatientDiscoveryPortType entityPatientDiscovery = context.mock(EntityPatientDiscoveryPortType.class);
        
        instance.setDataManager(dataManager);
        instance.setPropertyLookup(propertyLookup);
        instance.setAuditManager(auditManager);
        instance.setFacilityManager(facilityManager);
        instance.setEntityPatientDiscovery(entityPatientDiscovery);
        
        context.checking(new Expectations() {
        {
            oneOf(dataManager).getQuery("Composite.findDemographics");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("icn", patientId);
            oneOf(dataQuery).getResults();
            will(returnValue(patients));
            
            oneOf(dataManager).getQuery("STS.lookupSNOMED");
            will(returnValue(dataQuery));
            oneOf(dataQuery).setParameter("code", "224608005");
            oneOf(dataQuery).getResults();
            will(returnValue(roles));
            
            oneOf(auditManager).storeAudit(with(equal(expAudit)));
            
            oneOf(entityPatientDiscovery).respondingGatewayPRPAIN201305UV02(with(any(RespondingGatewayPRPAIN201305UV02RequestType.class)));
            will(throwException(new RuntimeException()));
            
            allowing(propertyLookup).getProperty(with(any(String.class)));
            will(returnValue("property"));
            
            oneOf(facilityManager).getFacilityByFacilityNumber(testFacility);
            will(returnValue(facility));
            
            allowing(facilityManager).getFacilityByFacilityNumber("VA");
            will(returnValue(facility));
        }});
        
        AnnouncePatientResponseType expResult = new AnnouncePatientResponseType();
        expResult.setReturn(-1);
        
        AnnouncePatientResponseType result = instance.announcePatient(body);
        assertEquals(expResult.getReturn(), result.getReturn());
    }
}
