/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.policyengine.pdpproxy;

import java.net.*;

import javax.ejb.*;
import javax.xml.namespace.QName;

import oasis.names.tc.xacml._2_0.context.schema.os.*;

import gov.va.med.nhin.adapter.permission.pdp.*;
import gov.va.med.nhin.adapter.propertylookup.*;

/**
 *
 * @author       VAZQUD
 */
@Stateless(name = "PDPProxyCPP")
public class PDPProxyCPP implements PDPProxyLocal
{
    private PermissionPDPService permissionPDPService;
    private PropertyLookup propertyLookup;
    
    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }
           
    public ResponseType checkPolicy(RequestType request)
    {
        return getPermissionPDPPort().checkPolicy(request);
    }
    
    private PermissionPDPPortType getPermissionPDPPort()
    {
        if (permissionPDPService == null) {
            try {
                permissionPDPService = new PermissionPDPService(new URL(propertyLookup.getProperty("PermissionPDPServiceWSDL")),
                												new QName("urn:gov:va:med:nhin:adapter:permission:pdp", "PermissionPDPService"));
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to get PermissionPDPPort.");
            }
        }

        return permissionPDPService.getPermissionPDPPort();
    }
}
