/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.policyengine;

import oasis.names.tc.xacml._2_0.context.schema.os.*;

/**
 *
 * @author David Vazquez
 */
public class CheckPolicyRequestBuilder
{
    static private final String ACTION_ATTRIBUTE_ID = "urn:oasis:names:tc:xacml:1.0:action:action-id";
    static private final String SUBJECT_HOME_COMMUNITY_ATTRIBUTE_ID = "http://www.hhs.gov/healthit/nhin#HomeCommunityId";
    static private final String RESOURCE_HOME_COMMUNITY_ATTRIBUTE_ID = "urn:gov:hhs:fha:nhinc:home-community-id";
    static private final String SUBJECT_PURPOSE_FOR_USE_ATTRIBUTE_ID = "urn:oasis:names:tc:xspa:1.0:subject:purposeofuse";
    static private final String SUBJECT_SUBJECT_ID_ATTRIBUTE_ID = "urn:oasis:names:tc:xacml:1.0:subject:subject-id";
    static private final String RESOURCE_ATTRIBUTE_ID = "urn:oasis:names:tc:xacml:1.0:resource:resource-id";

    static public RequestType buildNHINOutCheckPolicyRequest(String userId, String subjectHomeCommunityId)
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType ret = objFactory.createRequestType();

        AttributeValueType actionAttributeValue = new AttributeValueType();
        actionAttributeValue.getContent().add("NHINOut");

        AttributeType actionAttribute = new AttributeType();
        actionAttribute.setAttributeId(ACTION_ATTRIBUTE_ID);
        actionAttribute.getAttributeValue().add(actionAttributeValue);

        ActionType action = new ActionType();
        action.getAttribute().add(actionAttribute);

        AttributeValueType subjectUserIdAttributeValue = new AttributeValueType();
        subjectUserIdAttributeValue.getContent().add(userId);

        AttributeType subjectUserIdAttribute = new AttributeType();
        subjectUserIdAttribute.setAttributeId(SUBJECT_SUBJECT_ID_ATTRIBUTE_ID);
        subjectUserIdAttribute.getAttributeValue().add(subjectUserIdAttributeValue);

        AttributeValueType subjectHomeCommunityIdAttributeValue = new AttributeValueType();
        if (!subjectHomeCommunityId.startsWith("urn:oid:")) {
            subjectHomeCommunityId = "urn:oid:" + subjectHomeCommunityId;
        }
        subjectHomeCommunityIdAttributeValue.getContent().add(subjectHomeCommunityId);

        AttributeType subjectHomeCommunityIdAttribute = new AttributeType();
        subjectHomeCommunityIdAttribute.setAttributeId(SUBJECT_HOME_COMMUNITY_ATTRIBUTE_ID);
        subjectHomeCommunityIdAttribute.getAttributeValue().add(subjectHomeCommunityIdAttributeValue);
        
        SubjectType subject = new SubjectType();
        subject.getAttribute().add(subjectUserIdAttribute);
        subject.getAttribute().add(subjectHomeCommunityIdAttribute);

        ret.setAction(action);
        ret.getSubject().add(subject);

        return ret;
    }

    static public RequestType buildPatientDiscoveryOutCheckPolicyRequest(String userId, String patientId, String purposeForUse, String homeCommunityId, String subjectHomeCommunityId)
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType ret = objFactory.createRequestType();

        AttributeValueType actionAttributeValue = new AttributeValueType();
        actionAttributeValue.getContent().add("PatientDiscoveryOut");

        AttributeType actionAttribute = new AttributeType();
        actionAttribute.setAttributeId(ACTION_ATTRIBUTE_ID);
        actionAttribute.getAttributeValue().add(actionAttributeValue);

        ActionType action = new ActionType();
        action.getAttribute().add(actionAttribute);

        AttributeValueType subjectUserIdAttributeValue = new AttributeValueType();
        subjectUserIdAttributeValue.getContent().add(userId);

        AttributeType subjectUserIdAttribute = new AttributeType();
        subjectUserIdAttribute.setAttributeId(SUBJECT_SUBJECT_ID_ATTRIBUTE_ID);
        subjectUserIdAttribute.getAttributeValue().add(subjectUserIdAttributeValue);

        AttributeValueType subjectPurposeForUseAttributeValue = new AttributeValueType();
        subjectPurposeForUseAttributeValue.getContent().add(purposeForUse);

        AttributeType subjectPurposeForUseAttribute = new AttributeType();
        subjectPurposeForUseAttribute.setAttributeId(SUBJECT_PURPOSE_FOR_USE_ATTRIBUTE_ID);
        subjectPurposeForUseAttribute.getAttributeValue().add(subjectPurposeForUseAttributeValue);

        AttributeValueType subjectHomeCommunityIdAttributeValue = new AttributeValueType();
        if (!subjectHomeCommunityId.startsWith("urn:oid:")) {
            subjectHomeCommunityId = "urn:oid:" + subjectHomeCommunityId;
        }
        subjectHomeCommunityIdAttributeValue.getContent().add(subjectHomeCommunityId);

        AttributeType subjectHomeCommunityIdAttribute = new AttributeType();
        subjectHomeCommunityIdAttribute.setAttributeId(SUBJECT_HOME_COMMUNITY_ATTRIBUTE_ID);
        subjectHomeCommunityIdAttribute.getAttributeValue().add(subjectHomeCommunityIdAttributeValue);
        
        SubjectType subject = new SubjectType();
        subject.getAttribute().add(subjectUserIdAttribute);
        subject.getAttribute().add(subjectPurposeForUseAttribute);
        subject.getAttribute().add(subjectHomeCommunityIdAttribute);
        
        AttributeValueType resourcePatientIdAttributeValue = new AttributeValueType();
        resourcePatientIdAttributeValue.getContent().add(patientId);

        AttributeType resourcePatientIdAttribute = new AttributeType();
        resourcePatientIdAttribute.setAttributeId(RESOURCE_ATTRIBUTE_ID);
        resourcePatientIdAttribute.getAttributeValue().add(resourcePatientIdAttributeValue);

        AttributeValueType resourceHomeCommunityIdAttributeValue = new AttributeValueType();
        resourceHomeCommunityIdAttributeValue.getContent().add(homeCommunityId);

        AttributeType resourceHomeCommunityIdAttribute = new AttributeType();
        resourceHomeCommunityIdAttribute.setAttributeId(RESOURCE_HOME_COMMUNITY_ATTRIBUTE_ID);
        resourceHomeCommunityIdAttribute.getAttributeValue().add(resourceHomeCommunityIdAttributeValue);

        ResourceType resource = new ResourceType();
        resource.getAttribute().add(resourcePatientIdAttribute);
        resource.getAttribute().add(resourceHomeCommunityIdAttribute);
        
        ret.setAction(action);
        ret.getSubject().add(subject);
        ret.getResource().add(resource);

        return ret;
    }

    static public RequestType buildDocumentQueryOutCheckPolicyRequest(String userId, String patientId, String purposeForUse, String homeCommunityId, String subjectHomeCommunityId)
    {
        oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory objFactory = new oasis.names.tc.xacml._2_0.context.schema.os.ObjectFactory();
        RequestType ret = objFactory.createRequestType();

        AttributeValueType actionAttributeValue = new AttributeValueType();
        actionAttributeValue.getContent().add("DocumentQueryOut");

        AttributeType actionAttribute = new AttributeType();
        actionAttribute.setAttributeId(ACTION_ATTRIBUTE_ID);
        actionAttribute.getAttributeValue().add(actionAttributeValue);

        ActionType action = new ActionType();
        action.getAttribute().add(actionAttribute);

        AttributeValueType subjectUserIdAttributeValue = new AttributeValueType();
        subjectUserIdAttributeValue.getContent().add(userId);

        AttributeType subjectUserIdAttribute = new AttributeType();
        subjectUserIdAttribute.setAttributeId(SUBJECT_SUBJECT_ID_ATTRIBUTE_ID);
        subjectUserIdAttribute.getAttributeValue().add(subjectUserIdAttributeValue);

        AttributeValueType subjectPurposeForUseAttributeValue = new AttributeValueType();
        subjectPurposeForUseAttributeValue.getContent().add(purposeForUse);

        AttributeType subjectPurposeForUseAttribute = new AttributeType();
        subjectPurposeForUseAttribute.setAttributeId(SUBJECT_PURPOSE_FOR_USE_ATTRIBUTE_ID);
        subjectPurposeForUseAttribute.getAttributeValue().add(subjectPurposeForUseAttributeValue);

        AttributeValueType subjectHomeCommunityIdAttributeValue = new AttributeValueType();
        if (!subjectHomeCommunityId.startsWith("urn:oid:")) {
            subjectHomeCommunityId = "urn:oid:" + subjectHomeCommunityId;
        }
        subjectHomeCommunityIdAttributeValue.getContent().add(subjectHomeCommunityId);

        AttributeType subjectHomeCommunityIdAttribute = new AttributeType();
        subjectHomeCommunityIdAttribute.setAttributeId(SUBJECT_HOME_COMMUNITY_ATTRIBUTE_ID);
        subjectHomeCommunityIdAttribute.getAttributeValue().add(subjectHomeCommunityIdAttributeValue);
        
        SubjectType subject = new SubjectType();
        subject.getAttribute().add(subjectUserIdAttribute);
        subject.getAttribute().add(subjectPurposeForUseAttribute);
        subject.getAttribute().add(subjectHomeCommunityIdAttribute);
        
        AttributeValueType resourcePatientIdAttributeValue = new AttributeValueType();
        resourcePatientIdAttributeValue.getContent().add(patientId);

        AttributeType resourcePatientIdAttribute = new AttributeType();
        resourcePatientIdAttribute.setAttributeId(RESOURCE_ATTRIBUTE_ID);
        resourcePatientIdAttribute.getAttributeValue().add(resourcePatientIdAttributeValue);

        AttributeValueType resourceHomeCommunityIdAttributeValue = new AttributeValueType();
        resourceHomeCommunityIdAttributeValue.getContent().add(homeCommunityId);

        AttributeType resourceHomeCommunityIdAttribute = new AttributeType();
        resourceHomeCommunityIdAttribute.setAttributeId(RESOURCE_HOME_COMMUNITY_ATTRIBUTE_ID);
        resourceHomeCommunityIdAttribute.getAttributeValue().add(resourceHomeCommunityIdAttributeValue);

        ResourceType resource = new ResourceType();
        resource.getAttribute().add(resourcePatientIdAttribute);
        resource.getAttribute().add(resourceHomeCommunityIdAttribute);

        ret.setAction(action);
        ret.getSubject().add(subject);
        ret.getResource().add(resource);

        return ret;
    }
}
