/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.patientcorrelation;

import java.io.*;
import java.util.*;
import java.util.logging.*;

import javax.ejb.*;
import javax.jws.*;
import javax.naming.*;
import javax.xml.bind.*;

import gov.hhs.fha.nhinc.nhinccomponentpatientcorrelation.*;
import gov.hhs.fha.nhinc.common.nhinccommon.*;
import org.hl7.v3.*;

import gov.va.med.nhin.adapter.audit.*;
import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.datamanager.ejb.*;
import gov.va.med.nhin.adapter.facilitymanager.*;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.patientcorrelation.model.*;
import gov.va.med.nhin.adapter.patientcorrelation.ack.AckBuilder;
import gov.va.med.nhin.adapter.patientcorrelation.parsers.PRPAIN201301UV.PRPAIN201301UVParser;
import gov.va.med.nhin.adapter.patientcorrelation.parsers.PRPAIN201309UV.PRPAIN201309UVParser;
import gov.va.med.nhin.adapter.patientcorrelation.parsers.PRPAIN201309UV.PixRetrieveResponseBuilder;
import gov.va.med.nhin.adapter.propertylookup.*;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author David Vazquez
 */
@WebService(serviceName = "PatientCorrelationService",
            portName = "PatientCorrelationPort",
            endpointInterface = "gov.hhs.fha.nhinc.nhinccomponentpatientcorrelation.PatientCorrelationPortType",
            targetNamespace = "urn:gov:hhs:fha:nhinc:nhinccomponentpatientcorrelation",
            wsdlLocation = "META-INF/wsdl/NhincComponentPatientCorrelation.wsdl")
@Stateless(name = "AdapterPatientCorrelation")
public class AdapterPatientCorrelation implements PatientCorrelationPortTypeLocal
{
    static private final Logger logger = Logger.getLogger(AdapterPatientCorrelation.class.getName());
    private PropertyLookup propertyLookup;
    private FacilityManager facilityManager;
    private AuditManager auditManager;
    private DataManager dataManager;
    
    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    @EJB(beanInterface = AuditManagerLocal.class, beanName = "AuditManager")
    public void setAuditManager(AuditManager auditManager)
    {
        this.auditManager = auditManager;
    }

    @EJB(beanInterface = DataManagerLocal.class, beanName = "DataManager")
    public void setDataManager(DataManager dataManager)
    {
        this.dataManager = dataManager;
    }

    public RetrievePatientCorrelationsResponseType retrievePatientCorrelations(RetrievePatientCorrelationsRequestType retrievePatientCorrelationsRequest)
    {
        logger.entering(getClass().getName(), "retrievePatientCorrelations");

        RetrievePatientCorrelationsResponseType result = new RetrievePatientCorrelationsResponseType();

        PRPAIN201309UV02 IN201309 = retrievePatientCorrelationsRequest.getPRPAIN201309UV02();

        PRPAMT201307UV02PatientIdentifier patIdentifier = PRPAIN201309UVParser.parseHL7PatientPersonFrom201309Message(IN201309);

        if (patIdentifier == null) {
            return null;
        }
        List<II> listII = patIdentifier.getValue();
        if (listII == null) {
            return null;
        }
        if (listII.get(0) == null) {
            return null;
        }

        II inputPatientId = listII.get(0);
        List<String> dataSourceList = PRPAIN201309UVParser.extractDataSourceList(IN201309);

        QualifiedPatientIdentifier inputQualifiedPatientIdentifier = QualifiedPatientIdentifierFactory(inputPatientId);
        List<QualifiedPatientIdentifier> qualifiedPatientIdentifiers = findCorrelations(inputQualifiedPatientIdentifier, dataSourceList);
        List<II> iiList = buildList(qualifiedPatientIdentifiers);
        PRPAIN201310UV02 IN201310 = PixRetrieveResponseBuilder.createPixRetrieveResponse(IN201309, iiList);

        result.setPRPAIN201310UV02(IN201310);

        logger.exiting(getClass().getName(), "retrievePatientCorrelations");

        return result;
    }

    public AddPatientCorrelationResponseType addPatientCorrelation(AddPatientCorrelationRequestType addPatientCorrelationRequest)
    {
        logger.entering(getClass().getName(), "addPatientCorrelation");

        AddPatientCorrelationResponseType result = new AddPatientCorrelationResponseType();

        PRPAIN201301UV02 IN201301 = addPatientCorrelationRequest.getPRPAIN201301UV02();

        PRPAMT201301UV02Patient patient = PRPAIN201301UVParser.ParseHL7PatientPersonFrom201301Message(IN201301);

        II senderId = getSenderId(IN201301);
        II localId = getLocalId(patient);
        II remoteId = getRemoteId(patient);

        if (senderId != null && localId != null && remoteId != null) {
            String auditDetails = null;

            DataQuery dataQuery = dataManager.getQuery("MPI.linkPatient");
            dataQuery.setParameter("patientId", localId.getExtension());
            auditDetails = "ICN=" + localId.getExtension();
            dataQuery.setParameter("correlatedPatientId", remoteId.getExtension());
            auditDetails += ", correlatedPatientId=" + remoteId.getExtension();
            dataQuery.setParameter("correlatedAssigningAuthority", remoteId.getRoot());
            auditDetails += ", correlatedAssigningAuthority=" + remoteId.getRoot();
            dataQuery.setParameter("correlatedAssigningFacility", senderId.getRoot());
            auditDetails += ", correlatedAssigningFacility=" + senderId.getRoot();

            PRPAMT201301UV02Person person = PRPAIN201301UVParser.ParseHL7PatientPersonFromHL7Patient(patient);
            if (person != null) {
                if (!NullChecker.isNullOrEmpty(person.getName())) {
                    PNExplicit personName = person.getName().get(0);

                    for (Serializable nameElement : personName.getContent()) {
                        if (nameElement instanceof JAXBElement) {
                            Object value = ((JAXBElement)nameElement).getValue();

                            if (value instanceof EnExplicitFamily) {
                                dataQuery.setParameter("familyName", ((EnExplicitFamily)value).getContent());
                                auditDetails += ", familyName=" + ((EnExplicitFamily)value).getContent();

                            }
                            else if (value instanceof EnExplicitGiven) {
                                if (NullChecker.isNullOrEmpty(dataQuery.getParameter("firstName"))) {
                                    dataQuery.setParameter("firstName", ((EnExplicitGiven)value).getContent());
                                    auditDetails += ", firstName=" + ((EnExplicitGiven)value).getContent();
                                }
                                else {
                                    String middleName = (String)dataQuery.getParameter("middleName");
                                    if (!NullChecker.isNullOrEmpty(middleName)) {
                                        middleName += " " + ((EnExplicitGiven)value).getContent();
                                    }
                                    else {
                                        middleName = ((EnExplicitGiven)value).getContent();
                                    }
                                    dataQuery.setParameter("middleName", middleName);
                                    auditDetails += ", middleName=" + middleName;
                                }
                            }
                        }
                    }
                }

                CE administrativeGenderCode = person.getAdministrativeGenderCode();
                if (administrativeGenderCode != null) {
                    dataQuery.setParameter("gender", administrativeGenderCode.getCode());
                    auditDetails += ", gender=" + administrativeGenderCode.getCode();
                }

                TSExplicit birthTime = person.getBirthTime();
                if (birthTime != null) {
                    dataQuery.setParameter("dob", birthTime.getValue());
                    auditDetails += ", dob=" + birthTime.getValue();
                }

                if (!NullChecker.isNullOrEmpty(person.getAddr())) {
                    ADExplicit addr = person.getAddr().get(0);
                    int addressLine = 1;

                    for (Serializable addrElement : addr.getContent()) {
                        if (addrElement instanceof JAXBElement) {
                            Object value = ((JAXBElement)addrElement).getValue();

                            if (value instanceof AdxpExplicitStreetAddressLine) {
                                if (addressLine <= 3) {
                                    dataQuery.setParameter("homeAddressStreet" + addressLine++,
                                                           ((AdxpExplicitStreetAddressLine)value).getContent());
                                    auditDetails += ", homeAddressStreet=" + ((AdxpExplicitStreetAddressLine)value).getContent();
                                }
                            }
                            else if (value instanceof AdxpExplicitCity) {
                                dataQuery.setParameter("homeAddressCity", ((AdxpExplicitCity)value).getContent());
                                auditDetails += ", homeAddressCity=" + ((AdxpExplicitCity)value).getContent();
                            }
                            else if (value instanceof AdxpExplicitState) {
                                dataQuery.setParameter("homeAddressState", ((AdxpExplicitState)value).getContent());
                                auditDetails += ", homeAddressState=" + ((AdxpExplicitState)value).getContent();
                            }
                            else if (value instanceof AdxpExplicitPostalCode) {
                                dataQuery.setParameter("homeAddressPostal", ((AdxpExplicitPostalCode)value).getContent());
                                auditDetails += ", homeAddressPostal=" + ((AdxpExplicitPostalCode)value).getContent();
                            }
                        }
                    }
                }

                if (!NullChecker.isNullOrEmpty(person.getTelecom())) {
                    TELExplicit telecom = person.getTelecom().get(0);
                    String str = telecom.getValue();
                    if (!NullChecker.isNullOrEmpty(str) && str.startsWith("tel:+")) {
                        str = str.substring(5);
                    }
                    dataQuery.setParameter("homePhone", str);
                    auditDetails += ", homePhone=" + str;
                }

                if (!NullChecker.isNullOrEmpty(person.getAsOtherIDs())) {
                    for (PRPAMT201301UV02OtherIDs asOtherID : person.getAsOtherIDs()) {
                        for (II id : asOtherID.getId()) {
                            if (id.getRoot().equals("2.16.840.1.113883.4.1")) {
                                dataQuery.setParameter("ssn", id.getExtension());
                                auditDetails += ", ssn=" + id.getExtension();
                            }
                        }
                    }
                }
            }

            dataQuery.getResults();

            facilityManager.addAssigningAuthorityToFacility(senderId.getRoot(), remoteId.getRoot(), remoteId.getAssigningAuthorityName());

            // PD Audit Report - Begin
            String organization = null;

            DataQuery query = dataManager.getQuery("Composite.findDemographics");
            query.setParameter("icn", localId.getExtension());
            List<Map> results = query.getResults();
            Map pat = results.get(0);
            Map demographics = (Map)pat.get("demographics");


            Audit audit = new Audit();
            audit.setAction("AddPatientCorrelation");
            audit.setPatientId(localId.getExtension());
            audit.setPatientGivenName((String)((List)demographics.get("nameGiven")).get(0));
            audit.setPatientLastName((String)demographics.get("nameFamily"));
            audit.setPatientSSN((String)demographics.get("SSN"));
            audit.setPatientFacilityNumber((String)pat.get("patientPreferredFacilityNumber"));
            audit.setPatientFacilityName((String)pat.get("patientPreferredFacilityName"));

            AssertionType assertion = addPatientCorrelationRequest.getAssertion();
            if (assertion != null) {
                audit.setUserId(assertion.getUserInfo().getUserName());
                audit.setPurposeForUse(assertion.getPurposeOfDisclosureCoded().getCode());
                audit.setUserRole(assertion.getUserInfo().getRoleCoded().getCode());
                audit.setUserFacilityNumber(assertion.getUserInfo().getOrg().getHomeCommunityId());
                audit.setUserFacilityName(assertion.getUserInfo().getOrg().getName());
                if (assertion.getHomeCommunity() != null
                    && !NullChecker.isNullOrEmpty(assertion.getHomeCommunity().getHomeCommunityId())) {
                    organization = assertion.getHomeCommunity().getHomeCommunityId();
                }
                if (assertion.getUserInfo().getPersonName() != null) {
                    PersonNameType personName = assertion.getUserInfo().getPersonName();
                    if (!NullChecker.isNullOrEmpty(personName.getFullName())) {
                        audit.setUserName(personName.getFullName());
                    }
                    else {
                        StringBuilder userName = new StringBuilder();

                        if (NullChecker.isNotNullOrEmpty(personName.getGivenName())) {
                            userName.append(personName.getGivenName());
                        }

                        if (NullChecker.isNotNullOrEmpty(personName.getFamilyName())) {
                            if (userName.length() > 0) {
                                userName.append(' ');
                            }

                            userName.append(personName.getFamilyName());
                        }

                        audit.setUserName(userName.toString());
                    }
                }
            }

            Facility homeFacility = facilityManager.getFacilityByFacilityNumber("VA");
            if (NullChecker.isNullOrEmpty(organization) || organization.equals(homeFacility.getFullHomeCommunityId())) {
                organization = homeFacility.getFullHomeCommunityId();
                audit.setRemoteOrganizationId("urn:oid:" + senderId.getRoot());
            }
            else {
                audit.setRemoteOrganizationId(facilityManager.getFacilityByFacilityNumber("VA").getFullHomeCommunityId());
            }
            audit.setOrganizationId(organization);
            audit.setDetails(auditDetails);

            auditManager.storeAudit(audit);
            // PD Audit Report - End
        }

        result.setMCCIIN000002UV01(AckBuilder.BuildAck(IN201301));
        
        logger.exiting(getClass().getName(), "addPatientCorrelation");
        
        return result;
    }

    private II getSenderId(PRPAIN201301UV02 message)
    {
        II ret = null;

        if (message.getSender() != null
            && message.getSender().getDevice() != null
            && message.getSender().getDevice().getAsAgent() != null
            && message.getSender().getDevice().getAsAgent().getValue() != null
            && message.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization() != null
            && message.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue() != null
            && !NullChecker.isNullOrEmpty(message.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId())) {
            ret = message.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId().get(0);
        }
        else if (message.getSender() != null
                 && message.getSender().getDevice() != null
                 && !NullChecker.isNullOrEmpty(message.getSender().getDevice().getId())) {
            ret = message.getSender().getDevice().getId().get(0);
        }

        return ret;
    }

    private II getLocalId(PRPAMT201301UV02Patient patient)
    {
        II ret = null;
        String assigningAuthority = propertyLookup.getProperty("AssigningAuthority"); // TODO: get this from AuthorOrPerformer.
                
        for (II id : patient.getId()) {
            if (id.getRoot().equals(assigningAuthority)) {
                ret = id;
                break;
            }
        }

        return ret;
    }

    private II getRemoteId(PRPAMT201301UV02Patient patient)
    {
        II ret = null;
        String assigningAuthority = propertyLookup.getProperty("AssigningAuthority"); // TODO: get this from AuthorOrPerformer.

        for (II id : patient.getId()) {
            if (!id.getRoot().equals(assigningAuthority)) {
                ret = id;
                break;
            }
        }

        return ret;
    }

    private List<QualifiedPatientIdentifier> findCorrelations(QualifiedPatientIdentifier patientIdentifier, List<String> dataSourceList)
    {
        List<QualifiedPatientIdentifier> resultQualifiedPatientIdentifiers = new ArrayList<QualifiedPatientIdentifier>();

        DataQuery dp = dataManager.getQuery("MPI.findNHINCorrelations");
        dp.setParameter("icn", patientIdentifier.getPatientId());

        List<Map> dpResults = dp.getResults();
        for (Map dpResult : dpResults) {
            String correlatedPatientId = (String)dpResult.get("correlatedPatientId");
            String correlatedAssigningAuthority = (String)dpResult.get("correlatedAssigningAuthority");
            String correlatedAssigningFacility = (String)dpResult.get("correlatedAssigningFacility");

            if (NullChecker.isNullOrEmpty(dataSourceList)
                || dataSourceList.contains(correlatedAssigningFacility)) {
                QualifiedPatientIdentifier qpi = new QualifiedPatientIdentifier();
                qpi.setAssigningAuthority(correlatedAssigningAuthority);
                qpi.setPatientId(correlatedPatientId);
                resultQualifiedPatientIdentifiers.add(qpi);
            }
        }

        return resultQualifiedPatientIdentifiers;
    }

    private static List<II> buildList(List<QualifiedPatientIdentifier> qualifiedPatientIdentifiers)
    {
        if (qualifiedPatientIdentifiers == null) {
            return null;
        }
        List<II> iiList = new ArrayList<II>();

        for (QualifiedPatientIdentifier qualifiedPatientIdentifier : qualifiedPatientIdentifiers) {
            iiList.add(IIFactory(qualifiedPatientIdentifier));
        }
        return iiList;
    }

    private static II IIFactory(QualifiedPatientIdentifier qualifiedPatientIdentifier)
    {
        II ii = new II();
        ii.setRoot(qualifiedPatientIdentifier.getAssigningAuthorityId());
        ii.setExtension(qualifiedPatientIdentifier.getPatientId());
        return ii;
    }

    private static QualifiedPatientIdentifier QualifiedPatientIdentifierFactory(II ii)
    {
        QualifiedPatientIdentifier qualifiedPatientIdentifier = new QualifiedPatientIdentifier();
        qualifiedPatientIdentifier.setAssigningAuthority(ii.getRoot());
        qualifiedPatientIdentifier.setPatientId(ii.getExtension());
        return qualifiedPatientIdentifier;
    }
}
