/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.mpi;

import java.util.*;
import java.util.logging.*;

import javax.ejb.*;
import javax.jws.*;

import gov.hhs.fha.nhinc.mpi.adapter.component.hl7parsers.HL7DbParser201305;
import gov.hhs.fha.nhinc.common.nhinccommon.*;
import gov.hhs.fha.nhinc.patientdb.model.*;
import org.hl7.v3.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.datamanager.ejb.*;
import gov.va.med.nhin.adapter.facilitymanager.*;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.mpi.hl7parsers.*;
//import gov.va.med.nhin.adapter.mpi.mpilib.*;
import gov.va.med.nhin.adapter.propertylookup.*;
import gov.va.med.nhin.adapter.utils.*;
import gov.va.med.nhin.adapter.audit.*;

/**
 *
 * @author David Vazquez
 */
@WebService(serviceName = "AdapterMpiService",
            portName = "AdapterMpiPort",
            endpointInterface = "gov.va.med.nhin.adapter.adaptermpi.AdapterMpiPortType",
            targetNamespace = "urn:gov:va:med:nhin:adapter:adaptermpi",
            wsdlLocation = "META-INF/wsdl/AdapterMpi.wsdl")
@Stateless(name = "AdapterMPI")
public class AdapterMPI implements AdapterMpiPortTypeLocal
{
    static private final Logger logger = Logger.getLogger(AdapterMPI.class.getName());
    
    private PropertyLookup propertyLookup;
    private FacilityManager facilityManager;
    private AuditManager auditManager;
    private DataManager dataManager;
    
    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }

    @EJB(beanInterface = AuditManagerLocal.class, beanName = "AuditManager")
    public void setAuditManager(AuditManager auditManager)
    {
        this.auditManager = auditManager;
    }

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    @EJB(beanInterface = DataManagerLocal.class, beanName = "DataManager")
    public void setDataManager(DataManager dataManager)
    {
        this.dataManager = dataManager;
    }

    public PRPAIN201306UV02 findCandidates(RespondingGatewayPRPAIN201305UV02RequestType findCandidatesRequest)
    {
        logger.entering(getClass().getName(), "findCandidates");
        String details = null;
        String auditIcn = null;

        PRPAIN201306UV02 result = null;
        PRPAIN201305UV02 query = findCandidatesRequest.getPRPAIN201305UV02();
        String sourcePatientAssigningFacility = getSenderOID(query);
        String sendingFacility = getSendingFacility(sourcePatientAssigningFacility);

        Patient sourcePatient = HL7DbParser201305.ExtractMpiPatientFromMessage(query);
        Patient searchResultPatient = null;

        List<Patient> searchResults = mpiPatientSearch(sendingFacility, sourcePatientAssigningFacility, sourcePatient);
        result = HL7DbParser201306.BuildMessageFromMpiPatients(searchResults, query, getHomeFacility().getHomeCommunityId(), propertyLookup.getProperty("AssigningAuthority"));
        
        if (NullChecker.isNullOrEmpty(searchResults)) {
            details = "MATCH FAILED Remote Facility=" + sourcePatientAssigningFacility + " ";
        }
        else if (searchResults.size() > 1) {
            details = "AMBIGUOUS FAILED Remote Facility=" + sourcePatientAssigningFacility + " ";
        }
        else {
            searchResultPatient = searchResults.get(0);
            auditIcn = getICNFromPatient(searchResultPatient);
            details = "MATCH FOUND ICN= " + auditIcn + " Remote Facility=" + sourcePatientAssigningFacility + " ";
        }
        // PD Audit Report - Begin
        Audit audit = new Audit();
        audit.setAction("MPI findMatch");
        if (searchResultPatient != null) {
            audit.setPatientId(auditIcn);
            audit.setPatientSSN(searchResultPatient.getSsn());
            audit.setPatientLastName(searchResultPatient.getPersonnames().get(0).getLastName());
            audit.setPatientGivenName(searchResultPatient.getPersonnames().get(0).getFirstName());
            Identifier patientFacilityId = getAndRemovePatientFacilityIdFromPatient(searchResultPatient);
            if (patientFacilityId != null) {
                String[] parts = patientFacilityId.getId().split("~", 2);
                audit.setPatientFacilityNumber(parts[0]);
                audit.setPatientFacilityName(parts[1]);
            }
        }

        AssertionType assertion = findCandidatesRequest.getAssertion();
        String organization = null;
        if (assertion != null) {
            if (assertion.getHomeCommunity() != null
                && NullChecker.isNotNullOrEmpty(assertion.getHomeCommunity().getHomeCommunityId())) {
                organization = assertion.getHomeCommunity().getHomeCommunityId();
            }
            audit.setUserId(assertion.getUserInfo().getUserName());
            audit.setUserRole(assertion.getUserInfo().getRoleCoded().getCode());
            audit.setUserFacilityNumber(assertion.getUserInfo().getOrg().getHomeCommunityId());
            audit.setUserFacilityName(assertion.getUserInfo().getOrg().getName());
            audit.setPurposeForUse(assertion.getPurposeOfDisclosureCoded().getCode());
            if (assertion.getUserInfo().getPersonName() != null) {
                PersonNameType personName = assertion.getUserInfo().getPersonName();
                if (NullChecker.isNotNullOrEmpty(personName.getFullName())) {
                    audit.setUserName(personName.getFullName());
                }
                else {
                    StringBuilder userName = new StringBuilder();

                    if (NullChecker.isNotNullOrEmpty(personName.getGivenName())) {
                        userName.append(personName.getGivenName());
                    }

                    if (NullChecker.isNotNullOrEmpty(personName.getFamilyName())) {
                        if (userName.length() > 0) {
                            userName.append(' ');
                        }

                        userName.append(personName.getFamilyName());
                    }

                    audit.setUserName(userName.toString());
                }
            }
        }

        if (NullChecker.isNotNullOrEmpty(sourcePatient.getSsn())) {
            details += "ssn=" + sourcePatient.getSsn();
            details += ", ";
        }
        else {
            details += "ssn=, ";
        }

        if (NullChecker.isNotNullOrEmpty(sourcePatient.getPersonnames())) {
            Personname personname = sourcePatient.getPersonnames().get(0);
            if (NullChecker.isNotNullOrEmpty(personname.getLastName())) {
                details += "lastName=" + personname.getLastName();
                details += ", ";
            }
            else {
                details += "lastName=, ";
            }
            if (NullChecker.isNotNullOrEmpty(personname.getMiddleName())) {
                details += "middleName=" + personname.getMiddleName() + ", ";
            }
            else {
                details += "middleName=, ";
            }
            if (NullChecker.isNotNullOrEmpty(personname.getFirstName())) {
                details += "firstName=" + personname.getFirstName();
                details += ", ";
            }
            else {
                details += "firstName=, ";
            }
        }
        else {
            details += "lastName=, firstName=, ";
        }

        if (NullChecker.isNotNullOrEmpty(sourcePatient.getAddresses())) {
            Address address = sourcePatient.getAddresses().get(0);
            if (NullChecker.isNotNullOrEmpty(address.getStreet1())) {
                details += "address[0]=" + address.getStreet1() + ", ";
                if (NullChecker.isNotNullOrEmpty(address.getStreet2())) {
                    details += "address[1]=" + address.getStreet2() + ", ";
                }
            }
            else {
                details += "address=, ";
            }
            if (NullChecker.isNotNullOrEmpty(address.getCity())) {
                details += "city=" + address.getCity();
                details += ", ";
            }
            else {
                details += "city=, ";
            }
            if (NullChecker.isNotNullOrEmpty(address.getState())) {
                details += "state=" + address.getState();
                details += ", ";
            }
            else {
                details += "state=, ";
            }
            if (NullChecker.isNotNullOrEmpty(address.getPostal())) {
                details += "zip=" + address.getPostal();
                details += ", ";
            }
            else {
                details += "zip=, ";
            }
        }
        else {
            details += "address=, city=, state=, zip=, ";
        }

        if (NullChecker.isNotNullOrEmpty(sourcePatient.getPhonenumbers())) {
            Phonenumber phoneNumber = sourcePatient.getPhonenumbers().get(0);
            details += "phoneNumber=" + phoneNumber.getValue();
            details += ", ";
        }
        else {
            details += "phoneNumber=, ";
        }

        if (NullChecker.isNotNullOrEmpty(sourcePatient.getGender())) {
            details += "gender=" + sourcePatient.getGender();
            details += ", ";
        }
        else {
            details += "gender=, ";
        }

        if (NullChecker.isNotNullOrEmpty(sourcePatient.getDateOfBirth())) {
            details += "dob=" + sourcePatient.getDateOfBirth();
            details += ", ";
        }
        else {
            details += "dob=, ";
        }

        /*
        if (NullChecker.isNotNullOrEmpty(sourcePatient.getMaritalStatus())) {
            details += "maritalStatus=" + sourcePatient.getMaritalStatus();
        }
        else {
            details += "maritalStatus=";
        }
        */

        Facility homeFacility = facilityManager.getFacilityByFacilityNumber("VA");
        if (NullChecker.isNullOrEmpty(organization) || organization.equals(homeFacility.getFullHomeCommunityId())) {
            organization = homeFacility.getFullHomeCommunityId();
            audit.setRemoteOrganizationId("urn:oid:" + sourcePatientAssigningFacility);
        }
        else {
            audit.setRemoteOrganizationId(facilityManager.getFacilityByFacilityNumber("VA").getFullHomeCommunityId());
        }
        audit.setOrganizationId(organization);

        if (NullChecker.isNotNullOrEmpty(details)) {
            audit.setDetails(details);
        }
        else {
            audit.setDetails("No details available");
        }

        auditManager.storeAudit(audit);
        // PD Audit Report - End

        logger.exiting(getClass().getName(), "findCandidates");

        return result;
    }

    private String getSendingFacility(String senderDeviceId)
    {
        String ret;
        Facility facility = facilityManager.getFacilityByHomeCommunityId(senderDeviceId);

        if (facility != null) {
            ret = facility.getFacilityNumber();
        }
        else {
            ret = "200NHI";
        }

        return ret;
    }

    private List<Patient> mpiPatientSearch(String sendingFacility, String sourcePatientAssigningFacility, Patient patient)
    {
        List<Patient> result = new ArrayList<Patient>();
        DataQuery dq = dataManager.getQuery("MPI.findMatch");
        
        dq.setParameter("sendingFacility", sendingFacility);
        if (NullChecker.isNotNullOrEmpty(patient.getPersonnames())) {
            Personname personName = patient.getPersonnames().get(0);
            dq.setParameter("firstName", personName.getFirstName());
            dq.setParameter("middleName", personName.getMiddleName());
            dq.setParameter("lastName", personName.getLastName());
            dq.setParameter("gender", patient.getGender());
            dq.setParameter("dob", new Date(patient.getDateOfBirth().getTime()));
            dq.setParameter("prefix", personName.getPrefix());
            dq.setParameter("suffix", personName.getSuffix());
        }
        dq.setParameter("ssn", patient.getSsn());
        Identifier sourceId = getSourceIdFromPatient(patient);
        if (sourceId != null) {
            dq.setParameter("sourcePatientId", sourceId.getId());
            dq.setParameter("sourcePatientAssigningAuthority", sourceId.getOrganizationId());
            dq.setParameter("sourcePatientAssigningFacility", sourcePatientAssigningFacility);
        }
        if (NullChecker.isNotNullOrEmpty(patient.getAddresses())) {
            Address address = patient.getAddresses().get(0);
            dq.setParameter("homeAddressStreet1", address.getStreet1());
            dq.setParameter("homeAddressStreet2", address.getStreet2());
            dq.setParameter("homeAddressCity", address.getCity());
            dq.setParameter("homeAddressState", address.getState());
            dq.setParameter("homeAddressPostal", address.getPostal());
        }
        if (NullChecker.isNotNullOrEmpty(patient.getPhonenumbers())) {
            Phonenumber phoneNumber = patient.getPhonenumbers().get(0);
            if (NullChecker.isNotNullOrEmpty(phoneNumber.getValue()) && phoneNumber.getValue().startsWith("tel:+")) {
                dq.setParameter("homePhone", phoneNumber.getValue().substring(5));
            }
        }
        dq.setParameter("numRecords", "1");

        List<Map> dpResults = dq.getResults();

        for (Map dpResult : dpResults) {
            String icn = (String) dpResult.get("icn");
            Patient dpPatient = new Patient();
            Personname pName = new Personname();
            List<Identifier> ids = new ArrayList<Identifier>();
            dpPatient.setIdentifiers(ids);

            Identifier id = new Identifier();
            id.setId(icn);
            id.setOrganizationId(propertyLookup.getProperty("AssigningAuthority"));
            ids.add(id);

            dpPatient.setSsn(getFieldAsString(dpResult, "ssn"));

            pName.setFirstName(getFieldAsString(dpResult, "firstName"));
            pName.setMiddleName(getFieldAsString(dpResult, "middleName"));
            pName.setLastName(getFieldAsString(dpResult, "lastName"));
            pName.setPrefix(getFieldAsString(dpResult, "prefix"));
            pName.setSuffix(getFieldAsString(dpResult, "suffix"));
            List<Personname> personNames = new ArrayList<Personname>();
            personNames.add(pName);
            dpPatient.setPersonnames(personNames);
            dpPatient.setGender(getFieldAsString(dpResult, "gender"));
            dpPatient.setDateOfBirth(new java.sql.Timestamp(((Date)dpResult.get("dob")).getTime()));

            DataQuery dqDemographics = dataManager.getQuery("Composite.findDemographics");
            dqDemographics.setParameter("icn", icn);
            List<Map> dqDemographicsResults = dqDemographics.getResults();
            if (NullChecker.isNotNullOrEmpty(dqDemographicsResults)) {
                Map dqDemographicsResult = (Map)dqDemographicsResults.get(0).get("demographicsExt");
                Address address = new Address();
                ArrayList<String> streetAddressLines = (ArrayList<String>)dqDemographicsResult.get("homeAddressStreet");
                if (NullChecker.isNotNullOrEmpty(streetAddressLines)) {
                    address.setStreet1(streetAddressLines.get(0));
                    if (streetAddressLines.size() > 1) {
                        address.setStreet2(streetAddressLines.get(1));
                    }
                }
                address.setCity(getFieldAsString(dqDemographicsResult, "homeAddressCity"));
                address.setState(getFieldAsString(dqDemographicsResult, "homeAddressState"));
                address.setPostal(getFieldAsString(dqDemographicsResult, "homeAddressPostal"));
                List<Address> addresses = new ArrayList<Address>();
                addresses.add(address);
                dpPatient.setAddresses(addresses);
                List<Phonenumber> phoneNumbers = new ArrayList<Phonenumber>();
                Phonenumber phoneNumber = new Phonenumber();
                phoneNumber.setValue(getFieldAsString(dqDemographicsResult, "phoneHome"));;
                phoneNumbers.add(phoneNumber);
                dpPatient.setPhonenumbers(phoneNumbers);
                //dpPatient.setMaritalStatus(getFieldAsString(dqDemographicsResult, "maritalCode"));
                
                Identifier patientFacilityId = new Identifier();
                patientFacilityId.setId((String)dqDemographicsResults.get(0).get("patientPreferredFacilityNumber") + "~" + (String)dqDemographicsResults.get(0).get("patientPreferredFacilityName"));
                patientFacilityId.setOrganizationId("PATIENT_FACILITY");
                ids.add(patientFacilityId);
            }

            result.add(dpPatient);
        }
        
        return result;
    }

    private String getFieldAsString(Map result, String fieldName)
    {
        String ret = null;
        Object value = result.get(fieldName);

        if (value != null) {
            ret = value.toString();
        }

        return ret;
    }

    private String[] padStreetAddress(String[] streetAddressLines)
    {
        final int MAX_LINES = 3;
        String[] ret = streetAddressLines;

        if (streetAddressLines.length > 0 && streetAddressLines.length < MAX_LINES) {
            ret = new String[MAX_LINES];
            System.arraycopy(streetAddressLines, 0, ret, 0, streetAddressLines.length);

            for (int i = streetAddressLines.length; i < MAX_LINES; ++i) {
                ret[i] = "";
            }
        }

        return ret;
    }
    
    private String getSenderOID(PRPAIN201305UV02 request)
    {
        String ret = null;
        
        if (request.getSender() != null
            && request.getSender().getDevice() != null
            && request.getSender().getDevice().getAsAgent() != null
            && request.getSender().getDevice().getAsAgent().getValue() != null
            && request.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization() != null
            && request.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue() != null
            && request.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId() != null
            && NullChecker.isNotNullOrEmpty(request.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId())) {
            ret = request.getSender().getDevice().getAsAgent().getValue().getRepresentedOrganization().getValue().getId().get(0).getRoot();
        }        
        
        return ret;
    }
    
    private String getICNFromPatient(Patient patient)
    {
        String ret = null;
        String assigningAuthority = propertyLookup.getProperty("AssigningAuthority");
        
        for (Identifier id : patient.getIdentifiers()) {
            if (id.getOrganizationId().equals(assigningAuthority)) {
                ret = id.getId();
                break;
            }
        }
        
        return ret;
    }
    
    private Identifier getSourceIdFromPatient(Patient patient)
    {
        Identifier ret = null;
        String assigningAuthority = propertyLookup.getProperty("AssigningAuthority");
        
        for (Identifier id : patient.getIdentifiers()) {
            if (!id.getOrganizationId().equals(assigningAuthority)) {
                ret = id;
                break;
            }
        }
        
        return ret;
    }
    
    private Identifier getAndRemovePatientFacilityIdFromPatient(Patient patient)
    {
        Identifier ret = null;
        String assigningAuthority = "PATIENT_FACILITY";
        int index = 0;
        
        for (Identifier id : patient.getIdentifiers()) {
            if (id.getOrganizationId().equals(assigningAuthority)) {
                ret = id;
                break;
            }
            ++index;
        }
        
        if (ret != null) {
            patient.getIdentifiers().remove(index);
        }
        
        return ret;
    }
    
    private Facility getHomeFacility()
    {
        return facilityManager.getFacilityByFacilityNumber("VA");
    }
}
