/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.docquery;

import java.util.*;

import gov.va.med.nhin.adapter.datamanager.*;

/**
 *
 * @author       VAZQUD
 */
public class ParamStringToQueryParamDataTranslator implements DataTranslator
{
    public Object translate(Object input, Object result, Reference translator, DataQuery dataQuery)
    {
        Object ret = null;

        if (input != null) {
            if (!(input instanceof List || input instanceof String)) {
                throw new RuntimeException("input must be a string or a list of strings.");
            }

            StringBuffer buffer = new StringBuffer();

            if (input instanceof List) {
                List<String> inputAsList = (List)input;

                for (String item : inputAsList) {
                    addToResult(buffer, parseParamFormattedString(item));
                }
            }
            else {
                addToResult(buffer, parseParamFormattedString((String)input));
            }
            
            ret = buffer.toString();
        }
        
        return ret;
    }

    public String parseParamFormattedString(String paramFormattedString)
    {
        StringBuffer ret = new StringBuffer();

        if (paramFormattedString != null) {
            if (paramFormattedString.startsWith("(")) {
                String working = paramFormattedString.substring(1);
                int endIndex = working.indexOf(")");
                if (endIndex != -1) {
                    working = working.substring(0, endIndex);
                }
                String[] multiValueString = working.split(",");
                if (multiValueString != null) {
                    for (int i = 0; i < multiValueString.length; i++) {
                        String singleValue = multiValueString[i];
                        if (singleValue != null) {
                            singleValue = singleValue.trim();
                        }
                        singleValue = processSingleValue(singleValue);
                        addToResult(ret, singleValue);
                    }
                }
            }
            else {
                addToResult(ret, processSingleValue(paramFormattedString));
            }
        }

        return ret.toString();
    }

    private String processSingleValue(String singleValue)
    {
        if (singleValue.startsWith("'")) {
            singleValue = singleValue.substring(1);
            int endTickIndex = singleValue.indexOf("'");
            if (endTickIndex != -1) {
                singleValue = singleValue.substring(0, endTickIndex);
            }
        }

        return singleValue;
    }

    private void addToResult(StringBuffer buffer, String singleValue)
    {
        if (buffer.length() > 0) {
            buffer.append(",");
        }
        buffer.append(singleValue);
    }
}
