/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.docquery;

import java.text.*;
import java.util.*;
import java.util.Formatter;
import java.util.logging.*;
import java.util.regex.*;

import javax.ejb.*;
import javax.jws.*;
import javax.xml.bind.*;

import gov.hhs.fha.nhinc.adapterdocquery.*;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.*;
import oasis.names.tc.ebxml_regrep.xsd.query._3.*;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.*;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.datamanager.ejb.*;
import gov.va.med.nhin.adapter.documentrepository.*;
import gov.va.med.nhin.adapter.facilitymanager.*;
import gov.va.med.nhin.adapter.propertylookup.*;
import gov.va.med.nhin.adapter.utils.*;
import gov.va.med.nhin.adapter.utils.NullChecker;

/**
 *
 * @author David Vazquez
 */
@WebService(serviceName = "AdapterDocQuery",
            wsdlLocation = "META-INF/wsdl/AdapterDocQuery.wsdl",
            portName = "AdapterDocQueryPortSoap11",
            endpointInterface = "gov.hhs.fha.nhinc.adapterdocquery.AdapterDocQueryPortType",
            targetNamespace = "urn:gov:hhs:fha:nhinc:adapterdocquery")
@Stateless(name = "DocQuery")
public class DocQuery implements AdapterDocQueryPortTypeLocal
{
    static private final Logger logger = Logger.getLogger(DocQuery.class.getName());
    
    static private final String EBXML_DOCENTRY_PATIENT_ID = "$XDSDocumentEntryPatientId";
    static private final String EBXML_DOCENTRY_CLASS_CODE = "$XDSDocumentEntryClassCode";
    static private final String EBXML_DOCENTRY_CLASS_CODE_SCHEME = "$XDSDocumentEntryClassCodeScheme";
    static private final String EBXML_DOCENTRY_CREATION_TIME_FROM = "$XDSDocumentEntryCreationTimeFrom";
    static private final String EBXML_DOCENTRY_CREATION_TIME_TO = "$XDSDocumentEntryCreationTimeTo";
    static private final String EBXML_DOCENTRY_SERVICE_START_TIME_FROM = "$XDSDocumentEntryServiceStartTimeFrom";
    static private final String EBXML_DOCENTRY_SERVICE_START_TIME_TO = "$XDSDocumentEntryServiceStartTimeTo";
    static private final String EBXML_DOCENTRY_SERVICE_STOP_TIME_FROM = "$XDSDocumentEntryServiceStopTimeFrom";
    static private final String EBXML_DOCENTRY_SERVICE_STOP_TIME_TO = "$XDSDocumentEntryServiceStopTimeTo";
    static private final String EBXML_DOCENTRY_STATUS = "$XDSDocumentEntryStatus";
    // We need to be able to do a search using AdhocQueryRequest parameters, but
    // XDS.b does not have a search parameter slot name defined for repository ID
    // and document ID.  So we had to create our own custom ones.
    //----------------------------------------------------------------------------
    static private final String NHINC_CUSTOM_REPOSITORY_ID = "$NHINCRepositoryId";
    static private final String NHINC_CUSTOM_DOCUMENT_ID = "$NHINCDocumentId";
    static private final String EBXML_RESPONSE_REPOSITORY_UNIQUE_ID_SLOTNAME = "repositoryUniqueId";
    static private final String EBXML_RESPONSE_DOCID_IDENTIFICATION_SCHEME = "urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab";
    static private final String EBXML_RESPONSE_DOCID_NAME = "XDSDocumentEntry.uniqueId";
    static private final String EBXML_RESPONSE_PATIENTID_IDENTIFICATION_SCHEME = "urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427";
    static private final String EBXML_RESPONSE_PATIENTID_NAME = "XDSDocumentEntry.patientId";
    static private final String EBXML_RESPONSE_AUTHOR_CLASS_SCHEME = "urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d";
    static private final String EBXML_RESPONSE_AUTHOR_PERSON_SLOTNAME = "authorPerson";
    static private final String EBXML_RESPONSE_AUTHOR_INSTITUTION_SLOTNAME = "authorInstitution";
    static private final String EBXML_RESPONSE_AUTHOR_ROLE_SLOTNAME = "authorRole";
    static private final String EBXML_RESPONSE_AUTHOR_SPECIALTY_SLOTNAME = "authorSpecialty";
    static private final String EBXML_RESPONSE_CLASSCODE_CLASS_SCHEME = "urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a";
    static private final String EBXML_RESPONSE_CONFIDENTIALITYCODE_CLASS_SCHEME = "urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f";
    static private final String EBXML_RESPONSE_EVENTCODE_CLASS_SCHEME = "urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4";
    static private final String EBXML_RESPONSE_FORMATCODE_CLASS_SCHEME = "urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d";
    static private final String EBXML_RESPONSE_HEALTHCAREFACILITYTYPE_CLASS_SCHEME = "urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1";
    static private final String EBXML_RESPONSE_PRACTICESETTING_CLASS_SCHEME = "urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead";
    static private final String EBXML_RESPONSE_TYPECODE_CLASS_SCHEME = "urn:uuid:f0306f51-975f-434e-a61c-c59651d33983";
    static private final String EBXML_RESPONSE_CODE_CODESCHEME_SLOTNAME = "codingScheme";
    static private final String EBXML_RESPONSE_CREATIONTIME_SLOTNAME = "creationTime";
    static private final String EBXML_RESPONSE_HASH_SLOTNAME = "hash";
    static private final String EBXML_RESPONSE_INTENDEDRECIPIENTS_SLOTNAME = "intendedRecipient";
    static private final String EBXML_RESPONSE_LANGUAGECODE_SLOTNAME = "languageCode";
    static private final String EBXML_RESPONSE_LEGALAUTHENTICATOR_SLOTNAME = "legalAuthenticator";
    static private final String EBXML_RESPONSE_SERVICESTARTTIME_SLOTNAME = "serviceStartTime";
    static private final String EBXML_RESPONSE_SERVICESTOPTIME_SLOTNAME = "serviceStopTime";
    static private final String EBXML_RESPONSE_SIZE_SLOTNAME = "size";
    static private final String EBXML_RESPONSE_SOURCEPATIENTID_SLOTNAME = "sourcePatientId";
    static private final String EBXML_RESPONSE_SOURCEPATIENTINFO_SLOTNAME = "sourcePatientInfo";
    static private final String EBXML_RESPONSE_URI_SLOTNAME = "URI";
    static private final int EBXML_RESPONSE_URI_LINE_LENGTH = 128;
    static private final String XDS_QUERY_RESPONSE_STATUS_SUCCESS = "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success";
    static private final String XDS_QUERY_RESPONSE_STATUS_FAILURE = "urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure";
    static private final String XDS_QUERY_RESPONSE_OPTION_RETURN_TYPE_OBJECT_REF = "ObjectRef";
    static private final String XDS_QUERY_RESPONSE_OPTION_RETURN_TYPE_LEAF_CLASS = "LeafClass";
    static private final String XDS_QUERY_RESPONSE_EXTRINSIC_OBJCECT_OBJECT_TYPE = "urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1";
    static private final String DATE_FORMAT_FULL = "yyyyMMddHHmmssZ";
    static private final String DATE_FORMAT_CREATION = DATE_FORMAT_FULL;
    static private final String DATE_FORMAT_SERVICE = "yyyyMMddHHmmssZ";
    static private final String REPOSITORY_UNIQUE_ID = "1";
    static private final String STORED_QUERY_ID = "urn:uuid:14d4debf-8f97-4251-9a74-a90016b0af0d";
    
    // Properties file keys
    static private final long TWO_YEARS = 60 * 60 * 24 * 365 * 2 * 1000L;
    static private final String ERROR_XDS_REGISTRY_ERROR = "XDSRegistryError";
    static private final String ERROR_DESC_XDS_REGISTRY_ERROR = "Internal Registry/Repository error.";
    static private final String ERROR_XDS_STORED_QUERY_MISSING_PARAM = "XDSStoredQueryMissingParam";
    static private final String ERROR_DESC_XDS_STORED_QUERY_MISSING_PARAM = "A required parameter is missing.";
    static private final String ERROR_XDS_UNKNOWN_STORED_QUERY = "XDSUnknownStoredQuery";
    static private final String ERROR_DESC_XDS_UNKNOWN_STORED_QUERY = "The Query ID provided in the request is not recognized.";
    static private final String ERROR_XDS_TOO_MANY_RESULTS = "XDSTooManyResults";
    static private final String ERROR_DESC_XDS_TOO_MANY_RESULTS = "VA Results Have Exceeded Maximum Number of %1d. Change Query Criteria To Reduce Result Count.";
    static private final String ERROR_XDS_UNKNOWN_COMMUNITY = "XDSUnknownCommunity";
    static private final String ERROR_DESC_XDS_UNKNOWN_COMMUNITY = "A value for homeCommunityId is not recognized.";
    static private final String ERROR_XDS_MISSING_HOME_COMMUNITY_ID = "XDSMissingHomeCommunityId";
    static private final String ERROR_DESC_XDS_MISSING_HOME_COMMUNITY_ID = "A value for homeCommunityId is required and has not been specified.";
    
    private PropertyLookup propertyLookup;
    private FacilityManager facilityManager;
    private DocumentRepository documentRepository;
    private DataManager dataManager;
    
    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    @EJB(beanInterface = DocumentRepositoryLocal.class, beanName = "DocumentRepository")
    public void setDocumentRepository(DocumentRepository documentRepository)
    {
        this.documentRepository = documentRepository;
    }

    @EJB(beanInterface = DataManagerLocal.class, beanName = "DataManager")
    public void setDataManager(DataManager dataManager)
    {
        this.dataManager = dataManager;
    }

    public AdhocQueryResponse respondingGatewayCrossGatewayQuery(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
    {
        logger.entering(getClass().getName(), "respondingGatewayCrossGatewayQuery");

        AdhocQueryResponse ret;
        AdhocQueryRequest body = respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest();

        try {
            AdhocQueryType adhocQuery = body.getAdhocQuery();
            List<SlotType1> slots = adhocQuery.getSlot();
            Map<String, List<String>> queryParams = getMapFromSlots(slots);
            List<Document> results;

            if (NullChecker.isNullOrEmpty(adhocQuery.getId()) || !adhocQuery.getId().equals(STORED_QUERY_ID)) {
                ret = createAdhocQueryResponseError(body, ERROR_XDS_UNKNOWN_STORED_QUERY, ERROR_DESC_XDS_UNKNOWN_STORED_QUERY);
            }
            else {
                DataQuery dataQuery = dataManager.getQuery("QueryAggregator.findDocuments");
                dataQuery.setParameter("queryNames", queryParams.get(EBXML_DOCENTRY_CLASS_CODE));
                for (Map.Entry<String, List<String>> entry : queryParams.entrySet()) {
                    if (dataQuery.isParameter(entry.getKey())) {
                        dataQuery.setParameter(entry.getKey(), entry.getValue());
                    }
                }
                
                results = dataQuery.getResults();

                if (results.size() <= getMaxResults()) {
                    for (Document document : results) {
                        documentRepository.storeDocument(document);
                    }
                    ret = createAdhocQueryResponse(body, results);
                }
                else {
                    StringBuilder errorString = new StringBuilder();
                    Formatter formatter = new Formatter(errorString);
                    formatter.format(ERROR_DESC_XDS_TOO_MANY_RESULTS, getMaxResults());
                    ret = createAdhocQueryResponseError(body, ERROR_XDS_TOO_MANY_RESULTS, errorString.toString());
                }
            }
        }
        catch (RequiredParameterMissingException rpme) {
            logger.logp(Level.WARNING, getClass().getName(), "respondingGatewayCrossGatewayQuery", "Exception", rpme);
            ret = createAdhocQueryResponseError(body, ERROR_XDS_STORED_QUERY_MISSING_PARAM, ERROR_DESC_XDS_STORED_QUERY_MISSING_PARAM);
        }
        catch (Throwable t) {
            String hcid;
            String hcidName;
            if (respondingGatewayCrossGatewayQueryRequest.getAssertion() != null
                && respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity() != null) {
                hcid = respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity().getHomeCommunityId();
                hcidName = respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity().getName();
            }
            else {
                hcid = "N/A";
                hcidName = "Not Available";
            }
            logger.log(Level.WARNING, "Error processing DocQuery from {0} {1} - {2}", new Object[]{hcid, hcidName, t.getMessage()});
            logger.log(Level.WARNING, "Stack trace", t);
            ret = createAdhocQueryResponseError(body, ERROR_XDS_REGISTRY_ERROR, ERROR_DESC_XDS_REGISTRY_ERROR);
        }
        finally {
            logger.exiting(getClass().getName(), "respondingGatewayCrossGatewayQuery");
        }

        return ret;
    }

    private Map<String, List<String>> getMapFromSlots(List<SlotType1> slots)
    {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();

        for (SlotType1 slot : slots) {
            if (NullChecker.isNotNullOrEmpty(slot.getName())
                && NullChecker.isNotNullOrEmpty(slot.getValueList())
                && NullChecker.isNotNullOrEmpty(slot.getValueList().getValue())) {
                List<String> values = ret.get(slot.getName());
                if (values == null) {
                    values = new ArrayList<String>();
                    ret.put(slot.getName(), values);
                }
                values.addAll(slot.getValueList().getValue());
            }
        }

        return ret;
    }

    private AdhocQueryResponse createAdhocQueryResponse(AdhocQueryRequest adhocQueryRequest, List<Document> docs)
    {
        oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory retObjFactory = new oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory();
        AdhocQueryResponse ret = retObjFactory.createAdhocQueryResponse();

        ret.setStatus(XDS_QUERY_RESPONSE_STATUS_SUCCESS);
        ret.setRequestId(adhocQueryRequest.getId());

        oasis.names.tc.ebxml_regrep.xsd.rim._3.ObjectFactory oRimObjectFactory = new oasis.names.tc.ebxml_regrep.xsd.rim._3.ObjectFactory();
        RegistryObjectListType regObjList = new RegistryObjectListType();
        ret.setRegistryObjectList(regObjList);

        if (NullChecker.isNotNullOrEmpty(docs)) {
            List<JAXBElement<? extends IdentifiableType>> olRegObjs = regObjList.getIdentifiable();

            // Save these so that theyu can be added in later after all of the other items..
            //------------------------------------------------------------------------------
            ArrayList<JAXBElement<? extends IdentifiableType>> olObjRef = new ArrayList<JAXBElement<? extends IdentifiableType>>();
            ArrayList<JAXBElement<? extends IdentifiableType>> olAssoc = new ArrayList<JAXBElement<? extends IdentifiableType>>();

            for (Document doc : docs) {
                ExtrinsicObjectType oExtObj = new ExtrinsicObjectType();
                JAXBElement<? extends IdentifiableType> oJAXBExtObj = oRimObjectFactory.createExtrinsicObject(oExtObj);
                List<SlotType1> olSlot = oExtObj.getSlot();
                List<ClassificationType> olClassifications = oExtObj.getClassification();
                boolean bHaveData = false;

                oExtObj.setIsOpaque(Boolean.FALSE);
                oExtObj.setObjectType(XDS_QUERY_RESPONSE_EXTRINSIC_OBJCECT_OBJECT_TYPE);

                // Generate a UUID for the document
                UUID oDocumentUUID = UUID.randomUUID();
                String sDocumentUUID = "urn:uuid:" + oDocumentUUID.toString();
                oExtObj.setId(sDocumentUUID);

                //Document Unique ID
                //------------------
                String sDocumentId = "";        // need to keep a handle to this to be used later...
                if (NullChecker.isNotNullOrEmpty(doc.getDocumentUniqueId())) {
                    sDocumentId = doc.getDocumentUniqueId();
                    ExternalIdentifierType oExtId = new ExternalIdentifierType();
                    oExtId.setId("urn:uuid:" + UUID.randomUUID().toString());
                    oExtObj.getExternalIdentifier().add(oExtId);
                    oExtId.setRegistryObject(sDocumentUUID);
                    oExtId.setValue(sDocumentId);
                    oExtId.setIdentificationScheme(EBXML_RESPONSE_DOCID_IDENTIFICATION_SCHEME);
                    InternationalStringType oName = CreateSingleValueInternationalStringType(EBXML_RESPONSE_DOCID_NAME);
                    oExtId.setName(oName);
                    bHaveData = true;
                }

                // Author data
                boolean bHasAuthorData = false;
                ClassificationType oClassification = new ClassificationType();
                oClassification.setId("urn:uuid:" + UUID.randomUUID().toString());
                oClassification.setClassificationScheme(EBXML_RESPONSE_AUTHOR_CLASS_SCHEME);
                oClassification.setClassifiedObject(sDocumentUUID);
                oClassification.setNodeRepresentation("");
                List<SlotType1> olClassificationSlot = oClassification.getSlot();

                // Author Person
                if(NullChecker.isNotNullOrEmpty(doc.getAuthorPerson())) {
                    SlotType1 oSlot = CreateSingleValueSlot(EBXML_RESPONSE_AUTHOR_PERSON_SLOTNAME,
                    doc.getAuthorPerson());
                    olClassificationSlot.add(oSlot);
                    bHasAuthorData = true;
                }

                // Author institution
                // ------------------------------------------------------
                Facility facility = getHomeFacility();
                if (facility != null) {
                    SlotType1 oSlot =
                            CreateSingleValueSlot(EBXML_RESPONSE_AUTHOR_INSTITUTION_SLOTNAME,
                                                  facility.getFacilityName());
                    olClassificationSlot.add(oSlot);
                    bHasAuthorData = true;
                }

                // TODO: AuthorRole
                //------------
                /*
                if(NullChecker.isNotNullOrEmpty(doc.getAuthorRole()))
                {
                SlotType1 oSlot = CreateSingleValueSlot(EBXML_RESPONSE_AUTHOR_ROLE_SLOTNAME,
                doc.getAuthorRole());
                olClassificationSlot.add(oSlot);
                bHasAuthorData = true;
                }
                 */

                // TODO: AuthorSpecialty
                //----------------
                /*
                if(NullChecker.isNotNullOrEmpty(doc.getAuthorSpecialty()))
                {
                SlotType1 oSlot = CreateSingleValueSlot(EBXML_RESPONSE_AUTHOR_SPECIALTY_SLOTNAME,
                doc.getAuthorSpecialty());
                olClassificationSlot.add(oSlot);
                bHasAuthorData = true;
                }
                 */

                if (bHasAuthorData) {
                    olClassifications.add(oClassification);
                    bHaveData = true;
                }

                if (NullChecker.isNotNullOrEmpty(doc.getAvailabilityStatus())) {
                    oExtObj.setStatus(doc.getAvailabilityStatus());
                    bHaveData = true;
                }

                // Class Code
                //------------
                ClassificationType classCodeClassification = createClassificationFromCodedData(doc.getClassCode(), doc.getClassCodeScheme(), doc.getClassCodeDisplayName(),
                                                                                               EBXML_RESPONSE_CLASSCODE_CLASS_SCHEME,
                                                                                               sDocumentUUID);
                if (classCodeClassification != null) {
                    olClassifications.add(classCodeClassification);
                    bHaveData = true;
                }

                // TODO: Comments
                //---------
                /*
                if(NullChecker.isNotNullOrEmpty(doc.getComments()))
                {
                InternationalStringType oComments = CreateSingleValueInternationalStringType(doc.getComments());
                oExtObj.setDescription(oComments);
                bHaveData = true;
                }
                 */

                // Confidentiality Code
                //---------------------
                ClassificationType confidentialityCodeClassification = createClassificationFromCodedData(doc.getConfidentialityCode(), doc.getConfidentialityCodeScheme(), doc.getConfidentialityCodeDisplayName(),
                EBXML_RESPONSE_CONFIDENTIALITYCODE_CLASS_SCHEME,
                sDocumentUUID);
                if (confidentialityCodeClassification != null) {
                    olClassifications.add(confidentialityCodeClassification);
                    bHaveData = true;
                }

                // Creation Time
                //--------------
                if (doc.getCreationTime() != null) {
                    SlotType1 oSlot = CreateSingleValueSlot(EBXML_RESPONSE_CREATIONTIME_SLOTNAME,
                                                            doc.getCreationTime().toString());
                    olSlot.add(oSlot);
                    bHaveData = true;
                }

                // TODO: Event Code List
                //----------------
                /*
                if((doc.getEventCodes() != null) && (!doc.getEventCodes().isEmpty()))
                {
                for(EventCode eventCode : doc.getEventCodes())
                {
                ClassificationType eventCodeClassification = createClassificationFromCodedData(eventCode.getEventCode(), eventCode.getEventCodeScheme(), eventCode.getEventCodeDisplayName(),
                EBXML_RESPONSE_EVENTCODE_CLASS_SCHEME,
                sDocumentUUID);
                if (eventCodeClassification != null)
                {
                olClassifications.add(eventCodeClassification);
                bHaveData = true;
                }
                }
                }
                 */

                // Format Code
                ClassificationType formatCodeClassification = createClassificationFromCodedData(doc.getFormatCode(), doc.getFormatCodeScheme(), doc.getFormatCodeDisplayName(),
                                                                                                EBXML_RESPONSE_FORMATCODE_CLASS_SCHEME,
                                                                                                sDocumentUUID);
                if (formatCodeClassification != null) {
                    olClassifications.add(formatCodeClassification);
                    bHaveData = true;
                }

                // Hash Code
                //----------
                if (NullChecker.isNotNullOrEmpty(doc.getHash())) {
                    SlotType1 oSlot = CreateSingleValueSlot(EBXML_RESPONSE_HASH_SLOTNAME,
                                                            doc.getHash());
                    olSlot.add(oSlot);
                    bHaveData = true;
                }

                // Healthcare Facility Type Code
                //------------------------------
                ClassificationType healthcareFacilityTypeCodeClassification = createClassificationFromCodedData(doc.getHealthCareFacilityTypeCode(), doc.getHealthCareFacilityTypeCodeScheme(), doc.getHealthCareFacilityTypeCodeDisplayName(),
                EBXML_RESPONSE_HEALTHCAREFACILITYTYPE_CLASS_SCHEME,
                sDocumentUUID);
                if (healthcareFacilityTypeCodeClassification != null)
                {
                    olClassifications.add(healthcareFacilityTypeCodeClassification);
                    bHaveData = true;
                }

                // TODO: Intended Recipients
                //--------------------
                /*
                List<String> intendedRecipients = new ArrayList<String>();
                if(NullChecker.isNotNullOrEmpty(doc.getIntendedRecipientPerson()))
                {
                intendedRecipients.add(doc.getIntendedRecipientPerson());
                }
                else if(NullChecker.isNotNullOrEmpty(doc.getIntendedRecipientOrganization()))
                {
                intendedRecipients.add(doc.getIntendedRecipientOrganization());
                }
                
                if(!intendedRecipients.isEmpty())
                {
                String[] intendedRecipientArray = intendedRecipients.toArray(new String[intendedRecipients.size()]);
                SlotType1 oSlot = CreateMultiValueSlot(EBXML_RESPONSE_INTENDEDRECIPIENTS_SLOTNAME, intendedRecipientArray);
                olSlot.add(oSlot);
                bHaveData = true;
                }
                 */

                // Language Code
                //---------------
                if(NullChecker.isNotNullOrEmpty(doc.getLanguageCode())) {
                    SlotType1 oSlot = CreateSingleValueSlot(EBXML_RESPONSE_LANGUAGECODE_SLOTNAME,
                    doc.getLanguageCode());
                    olSlot.add(oSlot);
                    bHaveData = true;
                }

                // TODO: LegalAuthenticator Code
                //------------------------
                /*
                if(NullChecker.isNotNullOrEmpty(doc.getLegalAuthenticator()))
                {
                SlotType1 oSlot = CreateSingleValueSlot(EBXML_RESPONSE_LEGALAUTHENTICATOR_SLOTNAME,
                doc.getLegalAuthenticator());
                olSlot.add(oSlot);
                bHaveData = true;
                }
                 */

                // Mime Type
                //----------
                if (NullChecker.isNotNullOrEmpty(doc.getMimeType())) {
                    oExtObj.setMimeType(doc.getMimeType());
                    bHaveData = true;
                }

                // Patient ID
                //-----------
                if (NullChecker.isNotNullOrEmpty(doc.getPatientId())) {
                    String formattedPatientId = doc.getPatientId() + "^^^&" + getAssigningAuthority() + "&ISO";
                    ExternalIdentifierType oExtId = new ExternalIdentifierType();
                    oExtId.setId("urn:uuid:" + UUID.randomUUID().toString());
                    oExtId.setIdentificationScheme(EBXML_RESPONSE_PATIENTID_IDENTIFICATION_SCHEME);
                    InternationalStringType oPatIdName = CreateSingleValueInternationalStringType(EBXML_RESPONSE_PATIENTID_NAME);
                    oExtId.setName(oPatIdName);
                    oExtId.setRegistryObject(sDocumentUUID);
                    oExtId.setValue(formattedPatientId);
                    oExtObj.getExternalIdentifier().add(oExtId);
                    bHaveData = true;
                }

                // Practice Setting Code
                //----------------------
                ClassificationType practiceSettingCodeClassification = createClassificationFromCodedData(doc.getPracticeSettingCode(), doc.getPracticeSettingCodeScheme(), doc.getPracticeSettingCodeDisplayName(),
                EBXML_RESPONSE_PRACTICESETTING_CLASS_SCHEME,
                sDocumentUUID);
                if (practiceSettingCodeClassification != null) {
                    olClassifications.add(practiceSettingCodeClassification);
                    bHaveData = true;
                }

                // Service Start Time
                //-------------------
                if (doc.getBeginDate() != null) {
                    SlotType1 oSlot = CreateSingleValueSlot(EBXML_RESPONSE_SERVICESTARTTIME_SLOTNAME,
                                                            doc.getBeginDate().toString());
                    olSlot.add(oSlot);
                    bHaveData = true;
                }

                // Service Stop Time
                //------------------
                if (doc.getEndDate() != null) {
                    SlotType1 oSlot = CreateSingleValueSlot(EBXML_RESPONSE_SERVICESTOPTIME_SLOTNAME,
                                                            doc.getEndDate().toString());
                    olSlot.add(oSlot);
                    bHaveData = true;
                }

                // Size
                //-----
                if ((doc.getSize() != null) && (doc.getSize().intValue() > 0)) {
                    SlotType1 oSlot = CreateSingleValueSlot(EBXML_RESPONSE_SIZE_SLOTNAME,
                                                            doc.getSize().toString());
                    olSlot.add(oSlot);
                    bHaveData = true;
                }

                if (NullChecker.isNotNullOrEmpty(doc.getSourcePatientId())) {
                    SlotType1 oSlot = CreateSingleValueSlot(EBXML_RESPONSE_SOURCEPATIENTID_SLOTNAME,
                                                            doc.getSourcePatientId());
                    olSlot.add(oSlot);
                    bHaveData = true;
                }

                // TODO: Source Patient Info
                //--------------------
                /*
                List<String> sourcePatientInfoValues = new ArrayList<String>();
                if(NullChecker.isNotNullOrEmpty(doc.getPid3()))
                {
                sourcePatientInfoValues.add("PID-3|" + doc.getPid3());
                }
                if(NullChecker.isNotNullOrEmpty(doc.getPid5()))
                {
                sourcePatientInfoValues.add("PID-5|" + doc.getPid5());
                }
                if(NullChecker.isNotNullOrEmpty(doc.getPid7()))
                {
                sourcePatientInfoValues.add("PID-7|" + doc.getPid7());
                }
                if(NullChecker.isNotNullOrEmpty(doc.getPid8()))
                {
                sourcePatientInfoValues.add("PID-8|" + doc.getPid8());
                }
                if(NullChecker.isNotNullOrEmpty(doc.getPid11()))
                {
                sourcePatientInfoValues.add("PID-11|" + doc.getPid11());
                }
                
                if(!sourcePatientInfoValues.isEmpty())
                {
                String[] sourcePatientInfoValuesArray = sourcePatientInfoValues.toArray(new String[sourcePatientInfoValues.size()]);
                SlotType1 oSlot = CreateMultiValueSlot(EBXML_RESPONSE_SOURCEPATIENTINFO_SLOTNAME,
                sourcePatientInfoValuesArray);
                olSlot.add(oSlot);
                bHaveData = true;
                }
                 */

                // Title
                //-------
                if (NullChecker.isNotNullOrEmpty(doc.getTitle())) {
                    InternationalStringType oTitle = CreateSingleValueInternationalStringType(doc.getTitle());
                    oExtObj.setName(oTitle);
                    bHaveData = true;
                }

                VersionInfoType versionInfo = new VersionInfoType();
                versionInfo.setVersionName("1.1");
                oExtObj.setVersionInfo(versionInfo);
                
                // Type Code
                //----------
                ClassificationType typeCodeClassification = createClassificationFromCodedData(doc.getTypeCode(), doc.getTypeCodeScheme(), doc.getTypeCodeDisplayName(),
                                                                                              EBXML_RESPONSE_TYPECODE_CLASS_SCHEME,
                                                                                              sDocumentUUID);
                if (typeCodeClassification != null) {
                    olClassifications.add(typeCodeClassification);
                    bHaveData = true;
                }

                // TODO: URI
                //----
                /*
                if(NullChecker.isNotNullOrEmpty(doc.getDocumentUri()))
                {
                SlotType1 oSlot = null;
                String documentUri = doc.getDocumentUri();
                if (documentUri.length() <= EBXML_RESPONSE_URI_LINE_LENGTH)
                {
                oSlot = CreateSingleValueSlot(EBXML_RESPONSE_URI_SLOTNAME, documentUri);
                }
                else
                {
                int iStart = 0;
                String sURI = documentUri;
                int iTotalLen = sURI.length();
                int iIndex = 1;
                String saURIPart[] = null;
                
                if ((iTotalLen % EBXML_RESPONSE_URI_LINE_LENGTH) == 0)
                {
                saURIPart = new String[iTotalLen / EBXML_RESPONSE_URI_LINE_LENGTH];
                }
                else
                {
                saURIPart = new String[iTotalLen / EBXML_RESPONSE_URI_LINE_LENGTH + 1];
                }
                while (iStart < iTotalLen)
                {
                if ((iStart + EBXML_RESPONSE_URI_LINE_LENGTH) > iTotalLen)
                {
                saURIPart[iIndex - 1] = iIndex + "|" + sURI.substring(iStart, iTotalLen);
                iStart = iTotalLen;
                }
                else
                {
                saURIPart[iIndex - 1] = iIndex + "|" + sURI.substring(iStart, iStart + EBXML_RESPONSE_URI_LINE_LENGTH);
                iStart += EBXML_RESPONSE_URI_LINE_LENGTH;
                }
                iIndex++;
                }
                
                oSlot = CreateMultiValueSlot(EBXML_RESPONSE_URI_SLOTNAME,
                saURIPart);
                }   // else
                
                if (oSlot != null)
                {
                olSlot.add(oSlot);
                bHaveData = true;
                }
                }
                 */

                if (bHaveData) {
                    // Home community ID
                    //------------------
                    oExtObj.setHome(getHomeFacility().getFullHomeCommunityId());
                    oExtObj.setLid(doc.getDocumentUniqueId());
                    
                    // Repository Unique ID
                    //---------------------
                    SlotType1 oSlot = CreateSingleValueSlot(EBXML_RESPONSE_REPOSITORY_UNIQUE_ID_SLOTNAME,
                                                            getHomeFacility().getHomeCommunityId() + "." + REPOSITORY_UNIQUE_ID);
                    olSlot.add(oSlot);

                    olRegObjs.add(oJAXBExtObj);

                }
            }
            // if we have any Object References, add them in now.
            //---------------------------------------------------
            if (olObjRef.size() > 0) {
                olRegObjs.addAll(olObjRef);
            }

            // if we have any associations, add them in now.
            //---------------------------------------------------
            if (olAssoc.size() > 0) {
                olRegObjs.addAll(olAssoc);
            }

        }

        return ret;
    }

    /**
     * This method creates a classification from a coded item.
     *
     * @param oCoded The coded to be transformed.
     * @param sClassificationScheme The classification scheme value.
     * @param sDocumentId The document ID for the document associated with this classificaation.
     * @return The classification created based on the information in the coded.
     */
    private ClassificationType createClassificationFromCodedData(String code, String codeScheme, String codeDisplayName, String sClassificationScheme, String sDocumentId)
    {
        logger.finest("DocumentRegistryHelper.CreateClassificationFromCodedData() -- Begin");
        ClassificationType oClassification = new ClassificationType();
        oClassification.setId("urn:uuid:" + UUID.randomUUID().toString());
        boolean bHasCode = false;
        oClassification.setClassificationScheme(sClassificationScheme);
        oClassification.setClassifiedObject(sDocumentId);
        oClassification.setNodeRepresentation("");
        List<SlotType1> olClassificationSlot = oClassification.getSlot();

        // Code
        //-----
        if (NullChecker.isNotNullOrEmpty(code)) {
            oClassification.setNodeRepresentation(code);
            bHasCode = true;
        }

        // Code System
        //------------
        if (NullChecker.isNotNullOrEmpty(codeScheme)) {
            SlotType1 oSlot = CreateSingleValueSlot(EBXML_RESPONSE_CODE_CODESCHEME_SLOTNAME,
                                                    codeScheme);
            olClassificationSlot.add(oSlot);
            bHasCode = true;
        }

        // DisplayName
        //------------
        if (NullChecker.isNotNullOrEmpty(codeDisplayName)) {
            InternationalStringType oDisplayName = CreateSingleValueInternationalStringType(codeDisplayName);
            oClassification.setName(oDisplayName);
            bHasCode = true;
        }

        if (bHasCode) {
            return oClassification;
        }
        else {
            logger.finest("DocumentRegistryHelper.CreateClassificationFromCodedData() -- End");
            return null;
        }
    }

    /**
     * This method creates a Slot containing a single value.
     *
     * @param sSlotName The name of the slot.
     * @param sSlotValue The value for the slot.
     * @return The SlotType1 object containing the data passed in.
     */
    private SlotType1 CreateSingleValueSlot(String sSlotName, String sSlotValue)
    {
        logger.finest("DocumentRegistryHelper.CreateSingleValueSlot() -- Begin");
        String saSlotValue[] = new String[1];
        saSlotValue[0] = sSlotValue;
        logger.finest("DocumentRegistryHelper.CreateSingleValueSlot() -- End");
        return CreateMultiValueSlot(sSlotName, saSlotValue);
    }

    /**
     * This method creates a Slot containing a single value.
     *
     * @param sSlotName The name of the slot.
     * @param saSlotValue The array of values for the slot.
     * @return The SlotType1 object containing the data passed in.
     */
    private SlotType1 CreateMultiValueSlot(String sSlotName, String[] saSlotValue)
    {
        logger.finest("DocumentRegistryHelper.CreateMultiValueSlot() -- Begin");
        SlotType1 oSlot = new SlotType1();
        oSlot.setName(sSlotName);
        ValueListType oValueList = new ValueListType();
        oSlot.setValueList(oValueList);
        List<String> olValue = oValueList.getValue();
        for (int i = 0; i < saSlotValue.length; i++) {
            olValue.add(saSlotValue[i]);
        }
        logger.finest("DocumentRegistryHelper.CreateMultiValueSlot() -- End");
        return oSlot;
    }

    private String getAssigningAuthority()
    {
        return propertyLookup.getProperty("AssigningAuthority");
    }
    
    private Facility getHomeFacility()
    {
        return facilityManager.getFacilityByFacilityNumber("VA");
    }
    
    protected String formatCreationDate(Date sourceDate)
    {
        return formatDate(sourceDate, DATE_FORMAT_CREATION);
    }

    protected String formatServiceDate(Date sourceDate)
    {
        return formatDate(sourceDate, DATE_FORMAT_SERVICE);
    }

    private String formatDate(Date sourceDate, String formatString)
    {
        String formatted = "";
        if ((sourceDate != null) && (formatString != null)) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(formatString);
                formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                formatted = formatter.format(sourceDate);
            }
            catch (Throwable t) {
                logger.logp(Level.WARNING, getClass().getName(), "formatDate", "Failed to format a date (" + sourceDate.toString() + ") to a formatted string using the format '" + formatString + "': " + t.getMessage(), t);
            }
        }
        return formatted;
    }

    /**
     * This method creates an InternationalStringType with a single value.
     *
     * @param sLocStrValue The value to be placed in the string.
     * @return The InternationStringType that is being returned.
     */
    private InternationalStringType CreateSingleValueInternationalStringType(String sLocStrValue)
    {
        logger.finest("DocumentTransforms.CreateSingleValueInternationalStringType() -- Begin");
        InternationalStringType oName = new InternationalStringType();
        List<LocalizedStringType> olLocStr = oName.getLocalizedString();
        LocalizedStringType oNameLocStr = new LocalizedStringType();
        olLocStr.add(oNameLocStr);
        oNameLocStr.setValue(sLocStrValue);
        logger.finest("DocumentTransforms.CreateSingleValueInternationalStringType() -- End");
        return oName;
    }

    private AdhocQueryResponse createAdhocQueryResponseError(AdhocQueryRequest adhocQueryRequest,
                                                             String registryError,
                                                             String registryErrorDescription)
    {
        oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory objFactory = new oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory();
        AdhocQueryResponse ret = objFactory.createAdhocQueryResponse();
        ret.setRegistryObjectList(new RegistryObjectListType());
        RegistryErrorList registryErrorList = createRegistryErrorList();
        registryErrorList.getRegistryError().add(createRegistryError(registryError, registryErrorDescription));
        ret.setRegistryErrorList(registryErrorList);
        ret.setStatus(XDS_QUERY_RESPONSE_STATUS_FAILURE);
        ret.setRequestId(adhocQueryRequest.getId());
        return ret;
    }

    private RegistryErrorList createRegistryErrorList()
    {
        RegistryErrorList ret = new RegistryErrorList();
        ret.setHighestSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        return ret;
    }

    private RegistryError createRegistryError(String errorCode, String codeContext)
    {
        RegistryError ret = new RegistryError();
        ret.setErrorCode(errorCode);
        ret.setCodeContext(codeContext);
        ret.setSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        ret.setLocation(getHomeFacility().getFullHomeCommunityId());
        return ret;
    }

    public List<String> parseParamFormattedStrings(List<String> paramFormattedStrings)
    {
        List<String> ret = new ArrayList<String>();

        for (String paramFormattedString : paramFormattedStrings) {
            parseParamFormattedString(paramFormattedString, ret);
        }

        return ret;
    }

    public void parseParamFormattedString(String paramFormattedString, List<String> resultCollection)
    {
        if ((paramFormattedString != null) && (resultCollection != null)) {
            if (paramFormattedString.startsWith("(")) {
                String working = paramFormattedString.substring(1);
                int endIndex = working.indexOf(")");
                if (endIndex != -1) {
                    working = working.substring(0, endIndex);
                }
                String[] multiValueString = working.split(",");
                if (multiValueString != null) {
                    for (int i = 0; i < multiValueString.length; i++) {
                        String singleValue = multiValueString[i];
                        if (singleValue != null) {
                            singleValue = singleValue.trim();
                        }
                        if (singleValue.startsWith("'")) {
                            singleValue = singleValue.substring(1);
                            int endTickIndex = singleValue.indexOf("'");
                            if (endTickIndex != -1) {
                                singleValue = singleValue.substring(0, endTickIndex);
                            }
                        }
                        resultCollection.add(singleValue);
                    }
                }
            }
            else {
                resultCollection.add(paramFormattedString);
            }
        }
    }

    private int getMaxResults()
    {
        int ret;
        String docQueryMaxResults = propertyLookup.getProperty("docQueryMaxResults");

        if (NullChecker.isNotNullOrEmpty(docQueryMaxResults)) {
            ret = Integer.parseInt(docQueryMaxResults);
        }
        else {
            ret = 1500;
        }

        return ret;
    }
}
