/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.docquery;

import java.util.logging.*;

import javax.ejb.*;
import javax.jws.*;
import javax.xml.ws.*;

import gov.hhs.fha.nhinc.adapterdocquery.*;
import gov.hhs.fha.nhinc.adapterpolicyengine.*;
import gov.hhs.fha.nhinc.common.eventcommon.*;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.*;
import gov.hhs.fha.nhinc.nhinclib.*;
import gov.hhs.fha.nhinc.transform.policy.*;
import oasis.names.tc.xacml._2_0.context.schema.os.*;
import oasis.names.tc.ebxml_regrep.xsd.query._3.*;
import oasis.names.tc.ebxml_regrep.xsd.rim._3.*;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.*;

import gov.va.med.nhin.adapter.facilitymanager.*;
import gov.va.med.nhin.adapter.policyengine.*;
/**
 *
 * @author David Vazquez
 */
@WebService(serviceName = "AdapterDocQuerySoap12",
            wsdlLocation = "META-INF/wsdl/AdapterDocQuerySoap12.wsdl",
            portName = "AdapterDocQueryPortSoap",
            endpointInterface = "gov.hhs.fha.nhinc.adapterdocquery.AdapterDocQueryPortType",
            targetNamespace = "urn:gov:hhs:fha:nhinc:adapterdocquery")
@BindingType(value = javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING)
@Stateless(name = "AdapterDocQuery")
public class AdapterDocQuery implements AdapterDocQueryPortTypeLocal
{
    static private final Logger logger = Logger.getLogger(AdapterDocQuery.class.getName());
    
    private AdapterDocQueryPortType docQuery;
    private AdapterPolicyEnginePortType policyEngine;
    private FacilityManager facilityManager;
    
    @EJB(beanInterface = AdapterDocQueryPortTypeLocal.class, beanName = "DocQuery")
    public void setDocQuery(AdapterDocQueryPortType docQuery)
    {
        this.docQuery = docQuery;
    }

    @EJB(beanInterface = AdapterPolicyEnginePortTypeLocal.class, beanName = "AdapterPolicyEngine")
    public void setPolicyEngine(AdapterPolicyEnginePortType policyEngine)
    {
        this.policyEngine = policyEngine;
    }

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }
    
    public AdhocQueryResponse respondingGatewayCrossGatewayQuery(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
    {
        logger.entering(getClass().getName(), "respondingGatewayCrossGatewayQuery");
        
        AdhocQueryResponse ret;
        
        try {
            if (checkPolicy(respondingGatewayCrossGatewayQueryRequest)) {
                ret = docQuery.respondingGatewayCrossGatewayQuery(respondingGatewayCrossGatewayQueryRequest);
            }
            else {
                ret = createAdhocQueryResponseEmpty(respondingGatewayCrossGatewayQueryRequest);
            }
        }
        catch (Throwable t) {
            String hcid;
            String hcidName;
            if (respondingGatewayCrossGatewayQueryRequest.getAssertion() != null
                && respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity() != null) {
                hcid = respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity().getHomeCommunityId();
                hcidName = respondingGatewayCrossGatewayQueryRequest.getAssertion().getHomeCommunity().getName();
            }
            else {
                hcid = "N/A";
                hcidName = "Not Available";
            }
            logger.log(Level.WARNING, "Error processing DocQuery from {0} {1} - {2}", new Object[]{hcid, hcidName, t.getMessage()});
            logger.log(Level.WARNING, "Stack trace", t);
            ret = createAdhocQueryResponseError(respondingGatewayCrossGatewayQueryRequest);
        }
        finally {
            logger.exiting(getClass().getName(), "respondingGatewayCrossGatewayQuery");
        }
        
        return ret;
    }
    
    private boolean checkPolicy(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
    {
        AdhocQueryRequestMessageType adhocQueryRequestMessage = new AdhocQueryRequestMessageType();
        adhocQueryRequestMessage.setAdhocQueryRequest(respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest());
        adhocQueryRequestMessage.setAssertion(respondingGatewayCrossGatewayQueryRequest.getAssertion());
        
        AdhocQueryRequestEventType policyCheckReq = new AdhocQueryRequestEventType();
        policyCheckReq.setDirection(NhincConstants.POLICYENGINE_INBOUND_DIRECTION);
        policyCheckReq.setMessage(adhocQueryRequestMessage);
        
        PolicyEngineTransformer policyEngineTransformer = new PolicyEngineTransformer();
        CheckPolicyRequestType checkPolicyRequest = policyEngineTransformer.transformAdhocQueryToCheckPolicy(policyCheckReq);
        
        CheckPolicyResponseType checkPolicyResponse = policyEngine.checkPolicy(checkPolicyRequest);
        
        return checkPolicyResponse.getResponse().getResult().get(0).getDecision() == DecisionType.PERMIT;
    }

    private AdhocQueryResponse createAdhocQueryResponseEmpty(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
    {
        oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory objFactory = new oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory();
        AdhocQueryResponse ret = objFactory.createAdhocQueryResponse();
        AdhocQueryRequest fromAdhocQueryRequest = respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest();
        ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success");
        ret.setRequestId(fromAdhocQueryRequest.getId());
        ret.setRegistryObjectList(new RegistryObjectListType());
        return ret;
    }
    
    private AdhocQueryResponse createAdhocQueryResponseError(RespondingGatewayCrossGatewayQueryRequestType respondingGatewayCrossGatewayQueryRequest)
    {
        oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory objFactory = new oasis.names.tc.ebxml_regrep.xsd.query._3.ObjectFactory();
        AdhocQueryResponse ret = objFactory.createAdhocQueryResponse();
        AdhocQueryRequest fromAdhocQueryRequest = respondingGatewayCrossGatewayQueryRequest.getAdhocQueryRequest();
        ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure");
        ret.setRegistryErrorList(createDefaultRegistryErrorList());
        ret.setRequestId(fromAdhocQueryRequest.getId());
        ret.setRegistryObjectList(new RegistryObjectListType());
        return ret;
    }

    private RegistryErrorList createDefaultRegistryErrorList()
    {
        RegistryErrorList ret = new RegistryErrorList();
        ret.getRegistryError().add(createDefaultRegistryError());
        ret.setHighestSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        return ret;
    }

    private RegistryError createDefaultRegistryError()
    {
        RegistryError ret = new RegistryError();
        ret.setErrorCode("XDSRegistryError");
        ret.setCodeContext("Internal Registry/Repository Error");
        ret.setSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        ret.setLocation(getHomeFacility().getFullHomeCommunityId());
        return ret;
    }
    
    private Facility getHomeFacility()
    {
        return facilityManager.getFacilityByFacilityNumber("VA");
    }
}