/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.adaptergateway.patientdiscovery;

import java.net.*;
import java.net.URL;

import javax.ejb.*;
import javax.xml.namespace.*;

import gov.hhs.fha.nhinc.common.nhinccommon.*;
import gov.hhs.fha.nhinc.nhincproxypatientdiscovery.*;
import org.hl7.v3.*;

import gov.va.med.nhin.adapter.propertylookup.*;

/**
 *
 * @author       VAZQUD
 */
@Stateless(name = "NhincProxyNHINPatientDiscoverySender")
public class NhincProxyNHINPatientDiscoverySender implements NHINPatientDiscoverySender
{
    private PropertyLookup propertyLookup;
    private NhincProxyPatientDiscovery patientDiscovery;
    
    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }
    
    public PRPAIN201306UV02 sendRequest(PRPAIN201305UV02 prpain201305, AssertionType assertion, String remoteHomeCommunityId)
    {
        try {
            ProxyPRPAIN201305UVProxyRequestType request = new ProxyPRPAIN201305UVProxyRequestType();
            request.setAssertion(assertion);
            request.setPRPAIN201305UV02(prpain201305);
            request.setNhinTargetSystem(createNhinTarget(remoteHomeCommunityId));
            return getPatientDiscoveryPort().proxyPRPAIN201305UV(request);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
    
    private NhinTargetSystemType createNhinTarget(String homeCommunityId)
    {
        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(homeCommunityId);
        NhinTargetSystemType ret = new NhinTargetSystemType();
        ret.setHomeCommunity(homeCommunity);
        return ret;
    }
    
    private NhincProxyPatientDiscoveryPortType getPatientDiscoveryPort()
        throws MalformedURLException
    {
        if (patientDiscovery == null) {
            patientDiscovery = new NhincProxyPatientDiscovery(new URL(propertyLookup.getProperty("PatientDiscoveryProxyWSDL")),
                                                              new QName("urn:gov:hhs:fha:nhinc:nhincproxypatientdiscovery", "NhincProxyPatientDiscovery"));
        }

        return patientDiscovery.getNhincProxyPatientDiscoveryPort();
    }
}
