/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.adaptergateway.patientannounce;

import java.net.URL;
import java.text.*;
import java.util.*;
import java.util.logging.*;

import javax.annotation.*;
import javax.ejb.*;
import javax.jws.*;
import javax.xml.bind.*;

import gov.hhs.fha.nhinc.common.nhinccommon.*;
import gov.hhs.fha.nhinc.entitypatientdiscovery.*;
import gov.hhs.fha.nhinc.transform.subdisc.*;
import org.hl7.v3.*;

import gov.va.med.nhin.adapter.announcepatient.*;
import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.datamanager.ejb.*;
import gov.va.med.nhin.adapter.facilitymanager.*;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.propertylookup.*;
import gov.va.med.nhin.adapter.utils.NullChecker;
import gov.va.med.nhin.adapter.audit.*;
import gov.va.med.nhin.adapter.adaptergateway.patientdiscovery.*;

/**
 *
 * @author David Vazquez
 */
@WebService(serviceName = "AnnouncePatientService",
            portName = "AnnouncePatientPort",
            endpointInterface = "gov.va.med.nhin.adapter.announcepatient.AnnouncePatientPortType",
            targetNamespace = "urn:gov:va:med:nhin:adapter:announcepatient",
            wsdlLocation = "META-INF/wsdl/AnnouncePatient.wsdl")
@Stateless(name = "AnnouncePatient", mappedName = "AnnouncePatient")
public class AnnouncePatient implements AnnouncePatientLocal, AnnouncePatientRemote
{
    static private final Logger logger = Logger.getLogger(AnnouncePatient.class.getName());

    private PropertyLookup propertyLookup;
    private FacilityManager facilityManager;
    private AuditManager auditManager;
    private EntityPatientDiscoveryPortType entityPatientDiscovery;
    private DataManager dataManager;
    
    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }

    @EJB(beanInterface = AuditManagerLocal.class, beanName = "AuditManager")
    public void setAuditManager(AuditManager auditManager) {
        this.auditManager = auditManager;
    }

    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    @EJB(beanInterface = EntityPatientDiscoveryPortTypeLocal.class, beanName = "AdapterGatewayPatientDiscovery")
    public void setEntityPatientDiscovery(EntityPatientDiscoveryPortType entityPatientDiscovery)
    {
        this.entityPatientDiscovery = entityPatientDiscovery;
    }

    @EJB(beanInterface = DataManagerLocal.class, beanName = "DataManager")
    public void setDataManager(DataManager dataManager)
    {
        this.dataManager = dataManager;
    }

    public AnnouncePatientResponseType announcePatient(AnnouncePatientType body)
    {
        logger.entering(getClass().getName(), "announcePatient");

        AnnouncePatientResponseType ret = new AnnouncePatientResponseType();
        
        if (body == null || body.getPatientId() == null) {
            ret.setReturn(-1);
        }
        else {
            Map patient = getPatient(body.getPatientId());

            if (patient != null) {
                Map demographics = (Map) patient.get("demographics");
                Map demographicsExt = (Map) patient.get("demographicsExt");

                if (demographics != null && demographicsExt != null) {
                    List<String> givenName = (List<String>)demographics.get("nameGiven");
                    String prefix = (String)demographics.get("namePrefix");
                    String suffix = (String)demographics.get("nameSuffix");
                    String lastName = (String) demographics.get("nameFamily");
                    String gender = (String) demographics.get("genderCode");
                    String dob = demographics.get("birthDate").toString();
                    String ssn = (String) demographics.get("SSN");
                    String patientId = (String) demographics.get("MRN");
                    String homeCommunityId = getHomeFacility().getHomeCommunityId();
                    List<String> address = (List<String>)demographicsExt.get("homeAddressStreet");
                    String city = (String)demographicsExt.get("homeAddressCity");
                    String state = (String)demographicsExt.get("homeAddressState");
                    String zip = (String)demographicsExt.get("homeAddressPostal");
                    String phone = (String)demographicsExt.get("phoneHome");
                    String maritalStatus = (String)demographics.get("maritalStatusCode");
                    String multiBirth = (String)demographicsExt.get("multipleBirthCode");

                    PRPAIN201305UV02 prpain201305 =
                        createPRPAIN201305(lastName,
                                           givenName,
                                           prefix,
                                           suffix,
                                           dob,
                                           city,
                                           state,
                                           address,
                                           zip,
                                           phone,
                                           gender,
                                           multiBirth,
                                           maritalStatus,
                                           patientId,
                                           homeCommunityId,
                                           ssn);

                    AssertionType assertion = createAssertion(body);

                    RespondingGatewayPRPAIN201305UV02RequestType request = new RespondingGatewayPRPAIN201305UV02RequestType();
                    request.setPRPAIN201305UV02(prpain201305);
                    request.setAssertion(assertion);

                    if (NullChecker.isNotNullOrEmpty(body.getFacilities())) {
                        NhinTargetCommunitiesType targetCommunities = new NhinTargetCommunitiesType();

                        for (String facilityNumber : body.getFacilities().getFacility()) {
                            Facility facility = facilityManager.getFacilityByFacilityNumber(facilityNumber);
                            if (facility != null) {
                                NhinTargetCommunityType targetCommunity = new NhinTargetCommunityType();
                                HomeCommunityType hc = new HomeCommunityType();
                                hc.setHomeCommunityId(facility.getHomeCommunityId());
                                targetCommunity.setHomeCommunity(hc);
                                targetCommunities.getNhinTargetCommunity().add(targetCommunity);
                            }
                            else {
                                logger.log(Level.WARNING, "{0} is not a known facility number.", facilityNumber);
                            }
                        }

                        request.setNhinTargetCommunities(targetCommunities);
                    }

                    // PD Audit Report - Begin
                    Audit audit = new Audit();
                    audit.setAction("Announce");
                    audit.setPatientId(body.getPatientId());
                    audit.setPatientSSN(ssn);
                    audit.setPatientGivenName(givenName.get(0));
                    audit.setPatientLastName(lastName);
                    audit.setPatientFacilityNumber((String)patient.get("patientPreferredFacilityNumber"));
                    audit.setPatientFacilityName((String)patient.get("patientPreferredFacilityName"));

                    String patientDemographics = null;
                    patientDemographics = "ssn=" + ssn + ", lastName=" + lastName + ", ";
                    if (givenName.size() > 1) {
                        patientDemographics += "middleName=" + givenName.get(1) + ", ";
                    }
                    else {
                        patientDemographics += "middleName=, ";
                    }
                    patientDemographics += "givenName=" + givenName.get(0) + ", prefix=" + prefix + ", ";
                    patientDemographics += "suffix=" + suffix + ", dob=" + dob + ", ";
                    if (NullChecker.isNotNullOrEmpty(address)) {
                        for (int i = 0;  i < address.size();  ++i) {
                            if (NullChecker.isNotNullOrEmpty(address.get(i))) {
                                patientDemographics += "address[" + i + "]=" + address.get(i) + ", ";
                            }
                        }
                    }
                    patientDemographics += "city=" + city + ", ";
                    patientDemographics += "state=" + state + ", zip=" + zip + ", ";
                    patientDemographics += "phone=" + phone + ", gender=" + gender + ", ";
                    patientDemographics += "multiBirth=" + multiBirth + ", maritalStatus=" + maritalStatus + ", ";
                    patientDemographics += "patientId=" + patientId + ", homeCommunityId=" + homeCommunityId;
                    if (assertion != null) {
                        audit.setUserId(assertion.getUserInfo().getUserName());
                        audit.setUserRole(assertion.getUserInfo().getRoleCoded().getCode());
                        audit.setUserName(assertion.getUserInfo().getPersonName().getFamilyName());
                        audit.setUserFacilityNumber(assertion.getUserInfo().getOrg().getHomeCommunityId());
                        audit.setUserFacilityName(assertion.getUserInfo().getOrg().getName());
                        audit.setPurposeForUse(assertion.getPurposeOfDisclosureCoded().getCode());
                        audit.setOrganizationId(assertion.getHomeCommunity().getHomeCommunityId());
                        if (assertion.getHomeCommunity() != null
                                && NullChecker.isNotNullOrEmpty(assertion.getHomeCommunity().getHomeCommunityId())) {
                            audit.setOrganizationId(assertion.getHomeCommunity().getHomeCommunityId());
                        }
                    }

                    if (patientDemographics != null) {
                        audit.setDetails(patientDemographics);
                    }

                    auditManager.storeAudit(audit);
                    // PD Audit Report - End

                    if (request.getNhinTargetCommunities() == null ||
                        NullChecker.isNotNullOrEmpty(request.getNhinTargetCommunities().getNhinTargetCommunity())) {
                        try {
                            RespondingGatewayPRPAIN201306UV02ResponseType result = entityPatientDiscovery.respondingGatewayPRPAIN201305UV02(request);
                            ret.setReturn(result.getCommunityResponse().size());
                        }
                        catch (Throwable t) {
                            logger.log(Level.WARNING, "Call to entityPatientDiscovery failed.");
                            logger.log(Level.WARNING, "Stack Trace", t);
                            ret.setReturn(-1);
                        }
                    }
                    else {
                        logger.warning("Announce not initiated because given targets don't correspond to known NwHIN partners.");
                        ret.setReturn(0);
                    }
                }
                else {
                    logger.log(Level.WARNING, "Patient with ICN={0} does not have enough information to be announced to NwHIN.", body.getPatientId());
                }
            }
        }
        
        logger.exiting(getClass().getName(), "announcePatient");

        return ret;
    }

    private Map getPatient(String icn)
    {
        Map ret = null;

        DataQuery query = dataManager.getQuery("Composite.findDemographics");
        query.setParameter("icn", icn);
        List<Map> results = query.getResults();
        if (NullChecker.isNotNullOrEmpty(results)) {
            ret = results.get(0);
        }

        return ret;
    }

    private PRPAIN201305UV02 createPRPAIN201305(String lastName,
                                                List<String> givenName,
                                                String prefix,
                                                String suffix,
                                                String dob,
                                                String city,
                                                String state,
                                                List<String> address,
                                                String zip,
                                                String phone,
                                                String gender,
                                                String multiBirth,
                                                String maritalStatus,
                                                String patientId,
                                                String homeCommunityId,
                                                String ssn)
    {
        JAXBElement<PRPAMT201301UV02Person> patientPerson =
                buildPRPAIN201301PatientPerson(lastName,
                                               givenName,
                                               prefix,
                                               suffix,
                                               dob,
                                               city,
                                               state,
                                               address,
                                               zip,
                                               phone,
                                               gender,
                                               multiBirth,
                                               maritalStatus);

        String assigningAuthority = propertyLookup.getProperty("AssigningAuthority");
        
        II ii = new II();
        ii.setRoot(assigningAuthority);
        ii.setExtension(patientId);
        String assigningAuthorityName = propertyLookup.getProperty("AssigningAuthorityName");
        if (NullChecker.isNotNullOrEmpty(assigningAuthorityName)) {
            ii.setAssigningAuthorityName(assigningAuthorityName);
        }

        PRPAMT201301UV02Patient patient =
                HL7PatientTransforms.create201301Patient(patientPerson, ii);

        PRPAIN201305UV02 ret =
                HL7PRPA201305Transforms.createPRPA201305(patient, homeCommunityId, "1.1", assigningAuthority);

        // add ssn.
        PRPAMT201306UV02ParameterList paramList = ret.getControlActProcess().getQueryByParameter().getValue().getParameterList();
        PRPAMT201306UV02LivingSubjectId ssnId = new PRPAMT201306UV02LivingSubjectId();
        ii = new II();
        ii.setRoot("2.16.840.1.113883.4.1");
        ii.setExtension(ssn);
        ssnId.getValue().add(ii);
        ST text = new ST();
        ssnId.setSemanticsText(text);
        paramList.getLivingSubjectId().add(ssnId);

        // fix the interaction id.
        ret.setInteractionId(HL7DataTransformHelper.IIFactory(HL7Constants.INTERACTION_ID_ROOT, "PRPA_IN201305UV02"));

        // fix the controlActProccess/code.
        ret.getControlActProcess().setCode(HL7DataTransformHelper.CDFactory("PRPA_TE201305UV02", HL7Constants.INTERACTION_ID_ROOT));

        // fix the acceptAckCode.
        ret.setAcceptAckCode(HL7DataTransformHelper.CSFactory("NE"));
        
        // fix the processingModeCode.
        ret.setProcessingModeCode(HL7DataTransformHelper.CSFactory("T"));
        
        ret.getControlActProcess().setClassCode(ActClassControlAct.CACT);
        ret.getControlActProcess().getAuthorOrPerformer().get(0).getAssignedDevice().getValue().setClassCode("ASSIGNED");
        
        // fix the creation time of the message.
        TSExplicit te = new TSExplicit();
        Date now = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        te.setValue(formatter.format(now));
        ret.setCreationTime(te);

        CS responseModalityCode = new CS();
        responseModalityCode.setCode("R");
        ret.getControlActProcess().getQueryByParameter().getValue().setResponseModalityCode(responseModalityCode);
        
        CS responsePriorityCode = new CS();
        responsePriorityCode.setCode("I");
        ret.getControlActProcess().getQueryByParameter().getValue().setResponsePriorityCode(responsePriorityCode);
                
        return ret;
    }

    private JAXBElement<PRPAMT201301UV02Person> buildPRPAIN201301PatientPerson(String lastName,
                                                                               List<String> givenName,
                                                                               String prefix,
                                                                               String suffix,
                                                                               String dob,
                                                                               String city,
                                                                               String state,
                                                                               List<String> address,
                                                                               String zip,
                                                                               String phone,
                                                                               String gender,
                                                                               String multiBirth,
                                                                               String maritalStatus)
    {
        PRPAMT201301UV02Person patientPerson = new PRPAMT201301UV02Person();

        //--------------------------------------------------------------
        //build name
        org.hl7.v3.ObjectFactory factory = new org.hl7.v3.ObjectFactory();
        PNExplicit name = (PNExplicit) (factory.createPNExplicit());
        List namelist = name.getContent();

        //Last name
        EnExplicitFamily familyName = new EnExplicitFamily();
        familyName.setPartType("FAM");
        familyName.setContent(lastName);
        namelist.add(factory.createPNExplicitFamily(familyName));

        //First name
        if (NullChecker.isNotNullOrEmpty(givenName)) {
            for (String n : givenName) {
                if (NullChecker.isNotNullOrEmpty(n)) {
                    EnExplicitGiven gn = new EnExplicitGiven();
                    gn.setPartType("GIV");
                    gn.setContent(n);
                    namelist.add(factory.createPNExplicitGiven(gn));

                }
            }
        }

        EnExplicitPrefix pfx = new EnExplicitPrefix();
        pfx.setContent(prefix);
        pfx.setPartType("PFX");
        namelist.add(factory.createENExplicitPrefix(pfx));

        EnExplicitSuffix sfx = new EnExplicitSuffix();
        sfx.setContent(suffix);
        sfx.setPartType("SFX");
        namelist.add(factory.createENExplicitSuffix(sfx));

        patientPerson.getName().add(name);
        //------------------------------------------------------------


        //Date of Birth
        TSExplicit valueTSExplicit = new TSExplicit();
        valueTSExplicit.setValue(dob);
        patientPerson.setBirthTime(valueTSExplicit);


        //Gender
        CE valueCE = new CE();
        valueCE.setCode(gender);
        patientPerson.setAdministrativeGenderCode(valueCE);

        //-------------------------------------------------------------
        //  build address
        ADExplicit addr = (ADExplicit) (factory.createADExplicit());
        List addrlist = addr.getContent();

        //address
        AdxpExplicitCity valueCity = new AdxpExplicitCity();
        valueCity.setContent(city);
        addrlist.add(factory.createADExplicitCity(valueCity));

        AdxpExplicitState valueState = new AdxpExplicitState();
        valueState.setContent(state);
        addrlist.add(factory.createADExplicitState(valueState));

        if (NullChecker.isNotNullOrEmpty(address)) {
            for (String a : address) {
                if (NullChecker.isNotNullOrEmpty(a)) {
                    AdxpExplicitStreetAddressLine line = new AdxpExplicitStreetAddressLine();
                    line.setContent(a);
                    addrlist.add(factory.createADExplicitStreetAddressLine(line));
                }
            }
        }
        
        AdxpExplicitPostalCode valueZip = new AdxpExplicitPostalCode();
        valueZip.setContent(zip);
        addrlist.add(factory.createADExplicitPostalCode(valueZip));


        patientPerson.getAddr().add(addr);
        //--------------------------------------------------------------


        //telephone
        TELExplicit valueTELE = new TELExplicit();
        valueTELE.setValue(phone);
        patientPerson.getTelecom().add(valueTELE);

        //multi birth
        BL valueBL = new BL();
        if (multiBirth == null || multiBirth.length() == 0 || multiBirth.startsWith("NO") || multiBirth.startsWith("no")) {
            valueBL.setValue(false);
        }
        else {
            valueBL.setValue(true);
        }
        patientPerson.setMultipleBirthInd(valueBL);  //BL value

        // marital status
        CE maritalStatusCode = new CE();
        maritalStatusCode.setCode(maritalStatus);
        patientPerson.setMaritalStatusCode(maritalStatusCode);

        return factory.createPRPAMT201301UV02PatientPatientPerson(patientPerson);
    }

    private AssertionType createAssertion(AnnouncePatientType announcePatient)
    {
        AssertionType ret = new AssertionType();
        Facility homeFacility = facilityManager.getFacilityByFacilityNumber("VA");

        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(homeFacility.getFullHomeCommunityId());
        homeCommunity.setName(homeFacility.getFacilityName());
        ret.setHomeCommunity(homeCommunity);

        PersonNameType personName = new PersonNameType();
        if (NullChecker.isNotNullOrEmpty(announcePatient.getUserInfo().getFullName())) {
            personName.setFamilyName(announcePatient.getUserInfo().getFullName());
        }
        else {
            personName.setFamilyName(announcePatient.getUserInfo().getUserId());
        }

        UserType user = new UserType();
        user.setUserName(announcePatient.getUserInfo().getUserId() + ", CN=" + personName.getFamilyName() + ", O=" + homeFacility.getFacilityName());
        user.setPersonName(personName);
        user.setOrg(homeCommunity);
        CeType roleCoded = new CeType();
        roleCoded.setCodeSystem("2.16.840.1.113883.6.96");
        roleCoded.setCodeSystemName("SNOMED_CT");
        roleCoded.setCode("224608005");
        DataQuery query = dataManager.getQuery("STS.lookupSNOMED");
        query.setParameter("code", roleCoded.getCode());
        List<Map> results = query.getResults();
        roleCoded.setDisplayName((String)results.get(0).get("name"));
        user.setRoleCoded(roleCoded);
        ret.setUserInfo(user);

        ret.getUniquePatientId().add(announcePatient.getPatientId() + "^^^&" + propertyLookup.getProperty("AssigningAuthority") + "&ISO");

        CeType p = new CeType();
        p.setCode("TREATMENT");
        p.setCodeSystem("2.16.840.1.113883.3.18.7.1");
        p.setCodeSystemName("nhin-purpose");
        p.setDisplayName("Treatment");
        ret.setPurposeOfDisclosureCoded(p);
        
        SamlIssuerType sit = new SamlIssuerType();
        sit.setIssuer(propertyLookup.getProperty("AssertionIssuer"));
        sit.setIssuerFormat(propertyLookup.getProperty("AssertionIssuerFormat"));
        ret.setSamlIssuer(sit);

        ret.setMessageId("urn:uuid:" + UUID.randomUUID().toString());
        
        return ret;
    }
    
    private Facility getHomeFacility()
    {
        return facilityManager.getFacilityByFacilityNumber("VA");
    }
}
