/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.adaptergateway.docretrieve;

import java.net.*;
import java.util.*;
import java.util.logging.*;

import javax.ejb.*;
import javax.jws.WebService;

import gov.hhs.fha.nhinc.adapterpolicyengine.*;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyRequestType;
import gov.hhs.fha.nhinc.common.nhinccommonadapter.CheckPolicyResponseType;
import gov.hhs.fha.nhinc.common.nhinccommon.*;
import gov.hhs.fha.nhinc.common.nhinccommonentity.*;
import gov.hhs.fha.nhinc.entitydocretrieve.*;
import ihe.iti.xds_b._2007.*;
import ihe.iti.xds_b._2007.RetrieveDocumentSetRequestType.*;
import ihe.iti.xds_b._2007.RetrieveDocumentSetResponseType.*;
import oasis.names.tc.ebxml_regrep.xsd.rs._3.*;
import oasis.names.tc.xacml._2_0.context.schema.os.*;

import gov.va.med.nhin.adapter.audit.*;
import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.datamanager.ejb.*;
import gov.va.med.nhin.adapter.documentrepository.*;
import gov.va.med.nhin.adapter.documentrepository.Document;
import gov.va.med.nhin.adapter.facilitymanager.*;
import gov.va.med.nhin.adapter.facilitymanager.Facility;
import gov.va.med.nhin.adapter.policyengine.*;
import gov.va.med.nhin.adapter.propertylookup.*;
import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author spawaradmin
 */
@WebService(serviceName = "EntityDocRetrieve",
            portName = "EntityDocRetrievePortSoap11",
            endpointInterface = "gov.hhs.fha.nhinc.entitydocretrieve.EntityDocRetrievePortType",
            targetNamespace = "urn:gov:hhs:fha:nhinc:entitydocretrieve",
            wsdlLocation = "META-INF/wsdl/EntityDocRetrieve.wsdl")
@Stateless
public class EntityDocRetrieveBean implements EntityDocRetrievePortType
{
    static private class InvalidDocIdException extends RuntimeException
    {
    }

    static private final Logger logger = Logger.getLogger(EntityDocRetrieveBean.class.getName());

    private FacilityManager facilityManager;
    private PropertyLookup propertyLookup;
    private AuditManager auditManager;
    private DocumentRepository documentRepository;
    private AdapterPolicyEnginePortType adapterPolicyEngine;
    private EntityDocRetrievePortType entityDocRetrieve;
    private DataManager dataManager;
    
    @EJB(beanInterface = FacilityManagerLocal.class, beanName = "FacilityManager")
    public void setFacilityManager(FacilityManager facilityManager)
    {
        this.facilityManager = facilityManager;
    }

    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }

    @EJB(beanInterface = AuditManagerLocal.class, beanName = "AuditManager")
    public void setAuditManager(AuditManager auditManager)
    {
        this.auditManager = auditManager;
    }

    @EJB(beanInterface = DocumentRepositoryLocal.class, beanName = "DocumentRepository")
    public void setDocumentRepository(DocumentRepository documentRepository)
    {
        this.documentRepository = documentRepository;
    }

    @EJB(beanInterface = AdapterPolicyEnginePortTypeLocal.class, beanName = "AdapterPolicyEngine")
    public void setAdapterPolicyEngine(AdapterPolicyEnginePortType adapterPolicyEngine)
    {
        this.adapterPolicyEngine = adapterPolicyEngine;
    }

    @EJB(beanInterface = EntityDocRetrievePortTypeLocal.class, beanName = "AdapterGatewayDocRetrieve")
    public void setEntityDocRetrieve(EntityDocRetrievePortType entityDocRetrieve)
    {
        this.entityDocRetrieve = entityDocRetrieve;
    }

    @EJB(beanInterface = DataManagerLocal.class, beanName = "DataManager")
    public void setDataManager(DataManager dataManager)
    {
        this.dataManager = dataManager;
    }
    
    public RetrieveDocumentSetResponseType respondingGatewayCrossGatewayRetrieve(RespondingGatewayCrossGatewayRetrieveRequestType respondingGatewayCrossGatewayRetrieveRequest)
    {
        logger.entering(getClass().getName(), "respondingGatewayCrossGatewayRetrieve");

        RetrieveDocumentSetResponseType ret;

        AssertionType assertion = respondingGatewayCrossGatewayRetrieveRequest.getAssertion();
        RetrieveDocumentSetRequestType body = respondingGatewayCrossGatewayRetrieveRequest.getRetrieveDocumentSetRequest();

        try {
            if (checkPolicy(assertion)) {
                gov.hhs.fha.nhinc.common.nhinccommonentity.ObjectFactory objFactory = new gov.hhs.fha.nhinc.common.nhinccommonentity.ObjectFactory();
                RespondingGatewayCrossGatewayRetrieveRequestType request = objFactory.createRespondingGatewayCrossGatewayRetrieveRequestType();
                Map<String, Document> documents = new HashMap<String, Document>();

                request.setRetrieveDocumentSetRequest(createRetrieveDocumentSetRequest(body, documents));
                request.setAssertion(createAssertion(assertion, documents.values()));

                RetrieveDocumentSetResponseType retrieveResponse =
                    entityDocRetrieve.respondingGatewayCrossGatewayRetrieve(request);

                auditRetrieve(retrieveResponse, request.getAssertion(), assertion, documents);

                ret = createRetrieveDocumentSetResponse(retrieveResponse, documents);
            }
            else {
                ret = createRetrieveDocumentSetResponseError();
            }
        }
        catch (Throwable t) {
            ret = createRetrieveDocumentSetResponseError();
        }
        finally {
            logger.exiting(getClass().getName(), "respondingGatewayCrossGatewayRetrieve");
        }

        return ret;
    }

    private RetrieveDocumentSetRequestType createRetrieveDocumentSetRequest(RetrieveDocumentSetRequestType fromDocumentSetRequest,
                                                                            Map<String, Document> documents)
    {
        RetrieveDocumentSetRequestType ret = new RetrieveDocumentSetRequestType();
        ret.getDocumentRequest().addAll(createDocumentRequests(fromDocumentSetRequest.getDocumentRequest(), documents));
        return ret;
    }

    private List<DocumentRequest> createDocumentRequests(List<DocumentRequest> fromDocumentRequests,
                                                         Map<String, Document> documents)
    {
        List<DocumentRequest> ret = new ArrayList<DocumentRequest>();

        for (DocumentRequest documentRequest : fromDocumentRequests) {
            ret.add(createDocumentRequest(documentRequest, documents));
        }

        return ret;
    }

    private DocumentRequest createDocumentRequest(DocumentRequest fromDocumentRequest,
                                                  Map<String, Document> documents)
    {
        DocumentRequest ret = new DocumentRequest();

        Document document = documentRepository.getDocumentByDocumentUniqueId(fromDocumentRequest.getDocumentUniqueId());
        if (document == null) {
            throw new InvalidDocIdException();
        }

        Map<String, String> params = queryParamsToMap(document.getDocGenQueryParams());

        ret.setRepositoryUniqueId(params.get("documentRepositoryId"));
        ret.setHomeCommunityId(params.get("homeCommunityId"));
        ret.setDocumentUniqueId(params.get("documentUniqueId"));

        documents.put(ret.getDocumentUniqueId(), document);

        return ret;
    }

    private Map<String, String> queryParamsToMap(String queryParams)
    {
        HashMap<String, String> ret = new HashMap<String, String>();

        for (String param : queryParams.split(",")) {
            String[] p = param.split("=");
            ret.put(p[0], p[1]);
        }

        return ret;
    }

    private AssertionType createAssertion(AssertionType fromAssertion, Collection<Document> documents)
    {
        AssertionType ret = new AssertionType();
        Facility homeFacility = facilityManager.getFacilityByFacilityNumber("VA");

        ret.setAuthorized(true);

        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(homeFacility.getFullHomeCommunityId());
        homeCommunity.setName(homeFacility.getFacilityName());
        ret.setHomeCommunity(homeCommunity);

        UserType user = new UserType();
        CeType roleCoded = new CeType();
        roleCoded.setCode("224608005");
        if (fromAssertion.getUserInfo() != null) {
            user.setUserName(fromAssertion.getUserInfo().getUserName());
            user.setPersonName(fromAssertion.getUserInfo().getPersonName());
            user.setOrg(fromAssertion.getUserInfo().getOrg());
            if (fromAssertion.getUserInfo().getRoleCoded() != null) {
                roleCoded.setCode(fromAssertion.getUserInfo().getRoleCoded().getCode());
            }
        }
        else {
            user.setUserName("VA_USER");
            PersonNameType person = new PersonNameType();
            person.setGivenName("VA");
            person.setFamilyName("User");
        }

        if (user.getPersonName() != null
            && (NullChecker.isNotNullOrEmpty(user.getPersonName().getFamilyName())
                || NullChecker.isNotNullOrEmpty(user.getPersonName().getSecondNameOrInitials())
                || NullChecker.isNotNullOrEmpty(user.getPersonName().getGivenName()))) {
            user.setUserName(user.getUserName() + ", CN=" + createFullName(user.getPersonName()) + ", O=" + homeFacility.getFacilityName());
        }
        else {
            user.setUserName(user.getUserName() + ", CN=" + user.getUserName() + ", O=" + homeFacility.getFacilityName());
        }

        roleCoded.setCodeSystem("2.16.840.1.113883.6.96");
        roleCoded.setCodeSystemName("SNOMED_CT");
        DataQuery query = dataManager.getQuery("STS.lookupSNOMED");
        query.setParameter("code", roleCoded.getCode());
        List<Map> results = query.getResults();
        roleCoded.setDisplayName((String)results.get(0).get("name"));
        user.setRoleCoded(roleCoded);
        //if (user.getOrg() == null) {
            user.setOrg(homeCommunity);
        //}
        ret.setUserInfo(user);

        for (Document document : documents) {
            ret.getUniquePatientId().add(document.getPatientId());
        }

        CeType p = new CeType();
        p.setCodeSystem("2.16.840.1.113883.3.18.7.1");
        p.setCodeSystemName("nhin-purpose");
        p.setDisplayName("Treatment");
        if (fromAssertion.getPurposeOfDisclosureCoded() != null) {
            p.setCode(fromAssertion.getPurposeOfDisclosureCoded().getCode());
        }
        else {
            p.setCode("TREATMENT");
        }
        ret.setPurposeOfDisclosureCoded(p);

        SamlIssuerType sit = new SamlIssuerType();
        sit.setIssuer(propertyLookup.getProperty("AssertionIssuer"));
        sit.setIssuerFormat(propertyLookup.getProperty("AssertionIssuerFormat"));
        ret.setSamlIssuer(sit);

        ret.setMessageId("urn:uuid:" + UUID.randomUUID().toString());

        return ret;
    }

    private RetrieveDocumentSetResponseType createRetrieveDocumentSetResponse(RetrieveDocumentSetResponseType fromDocumentSetResponse,
                                                                              Map<String, Document> documents)
    {
        ihe.iti.xds_b._2007.ObjectFactory objFactory = new ihe.iti.xds_b._2007.ObjectFactory();
        RetrieveDocumentSetResponseType ret = objFactory.createRetrieveDocumentSetResponseType();
        ret.setRegistryResponse(createRegistryResponse(fromDocumentSetResponse.getRegistryResponse()));
        ret.getDocumentResponse().addAll(createDocumentResponses(fromDocumentSetResponse.getDocumentResponse(), documents));
        return ret;
    }

    private RegistryResponseType createRegistryResponse(RegistryResponseType fromRegistryResponse)
    {
        RegistryResponseType ret;

        if (fromRegistryResponse != null) {
            ret = fromRegistryResponse;
        }
        else {
            ret = new RegistryResponseType();
            ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success");
        }

        return ret;
    }

    private List<DocumentResponse> createDocumentResponses(List<DocumentResponse> fromDocumentResponses,
                                                           Map<String, Document> documents)
    {
        List<DocumentResponse> ret = new ArrayList<DocumentResponse>();

        if (!NullChecker.isNullOrEmpty(fromDocumentResponses)) {
            for (DocumentResponse documentResponse : fromDocumentResponses) {
                ret.add(createDocumentResponse(documentResponse, documents));
            }
        }

        return ret;
    }

    private DocumentResponse createDocumentResponse(DocumentResponse fromDocumentResponse,
                                                    Map<String, Document> documents)
    {
        DocumentResponse ret = new DocumentResponse();

        ret.setDocument(fromDocumentResponse.getDocument());
        ret.setHomeCommunityId(fromDocumentResponse.getHomeCommunityId());
        ret.setMimeType(fromDocumentResponse.getMimeType());
        ret.setDocumentUniqueId(documents.get(fromDocumentResponse.getDocumentUniqueId()).getDocumentUniqueId());

        return ret;
    }

    private RetrieveDocumentSetResponseType createRetrieveDocumentSetResponseError()
    {
        ihe.iti.xds_b._2007.ObjectFactory objFactory = new ihe.iti.xds_b._2007.ObjectFactory();
        RetrieveDocumentSetResponseType ret = objFactory.createRetrieveDocumentSetResponseType();
        ret.setRegistryResponse(createRegistryResponseError());
        return ret;
    }

    private RegistryResponseType createRegistryResponseError()
    {
        RegistryResponseType ret = new RegistryResponseType();
        ret.setStatus("urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Failure");
        ret.setRegistryErrorList(createRegistryErrorList());
        return ret;
    }

    private RegistryErrorList createRegistryErrorList()
    {
        RegistryErrorList ret = new RegistryErrorList();
        ret.getRegistryError().add(createRegistryError());
        ret.setHighestSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        return ret;
    }

    private RegistryError createRegistryError()
    {
        RegistryError ret = new RegistryError();
        ret.setErrorCode("XDSRepositoryError");
        ret.setCodeContext("Internal Registry/Repository Error");
        ret.setSeverity("urn:oasis:names:tc:ebxml-regrep:ErrorSeverityType:Error");
        return ret;
    }

    private void auditRetrieve(RetrieveDocumentSetResponseType response, AssertionType assertion, AssertionType origAssertion, Map<String, Document> documents)
    {
        if (!NullChecker.isNullOrEmpty(response.getDocumentResponse())) {
            for (DocumentResponse d : response.getDocumentResponse()) {
                Date creationTime = new Date();
                Document document = documents.get(d.getDocumentUniqueId());
                document.setRawData(d.getDocument());
                document.setSize(d.getDocument().length);
                document.setAvailabilityStatus("urn:oasis:names:tc:ebxmlregrep:StatusType:Approved");
                document.setLastAccessedTime(creationTime);
                documentRepository.storeDocument(document);

                Audit audit = new Audit();
                audit.setAction("RetrieveDocumentOut");
                audit.setAuditTime(new Date());
                audit.setDocumentId(document.getDocumentUniqueId());
                audit.setRemoteDocumentId(d.getDocumentUniqueId());
                audit.setRemoteDocumentRepositoryId(d.getRepositoryUniqueId());
                audit.setRemoteOrganizationId(d.getHomeCommunityId());
                audit.setUserId(assertion.getUserInfo().getUserName());
                audit.setUserRole(assertion.getUserInfo().getRoleCoded().getCode());
                audit.setUserFacilityNumber(origAssertion.getUserInfo().getOrg().getHomeCommunityId());
                audit.setUserFacilityName(origAssertion.getUserInfo().getOrg().getName());
                if (assertion.getUserInfo().getPersonName() != null) {
                    PersonNameType personName = assertion.getUserInfo().getPersonName();
                    if (!NullChecker.isNullOrEmpty(personName.getFullName())) {
                        audit.setUserName(personName.getFullName());
                    }
                    else {
                        audit.setUserName(personName.getGivenName() + " " + personName.getFamilyName());
                    }
                }
                audit.setPurposeForUse(assertion.getPurposeOfDisclosureCoded().getCode());
                audit.setOrganizationId(assertion.getHomeCommunity().getHomeCommunityId());
                audit.setPatientId(document.getPatientId());
                audit.setPatientSSN(document.getPatientSSN());
                audit.setPatientGivenName(document.getPatientGivenName());
                audit.setPatientLastName(document.getPatientLastName());
                audit.setPatientFacilityNumber(document.getPatientPreferredFacilityNumber());
                audit.setPatientFacilityName(document.getPatientPreferredFacilityName());
                auditManager.storeAudit(audit);
            }
        }
    }

    private boolean checkPolicy(AssertionType assertion)
    {
        boolean ret = false;

        if (assertion.getUserInfo() != null
            && !NullChecker.isNullOrEmpty(assertion.getUserInfo().getUserName())) {
            RequestType request =
                    CheckPolicyRequestBuilder.buildNHINOutCheckPolicyRequest(assertion.getUserInfo().getUserName(), getFullHomeCommunityId());
            CheckPolicyRequestType checkPolicyRequest = new CheckPolicyRequestType();
            checkPolicyRequest.setRequest(request);
            CheckPolicyResponseType checkPolicyResponse = adapterPolicyEngine.checkPolicy(checkPolicyRequest);
            if (checkPolicyResponse != null
                && !NullChecker.isNullOrEmpty(checkPolicyResponse.getResponse())
                && !NullChecker.isNullOrEmpty(checkPolicyResponse.getResponse().getResult())) {
                ret = checkPolicyResponse.getResponse().getResult().get(0).getDecision() == DecisionType.PERMIT;
            }
        }

        return ret;
    }

    private String getFullHomeCommunityId()
    {
        String ret = null;
        Facility facility = facilityManager.getFacilityByFacilityNumber("VA");
        if (facility != null) {
            ret = facility.getFullHomeCommunityId();
        }
        return ret;
    }

    private String createFullName(PersonNameType personName)
    {
        StringBuffer ret = new StringBuffer();

        if (NullChecker.isNotNullOrEmpty(personName.getGivenName())) {
            ret.append(personName.getGivenName());
        }

        if (NullChecker.isNotNullOrEmpty(personName.getSecondNameOrInitials())) {
            if (ret.length() > 0) {
                ret.append(' ');
            }
            ret.append(personName.getSecondNameOrInitials());
        }

        if (NullChecker.isNotNullOrEmpty(personName.getFamilyName())) {
            if (ret.length() > 0) {
                ret.append(' ');
            }
            ret.append(personName.getFamilyName());
        }

        return ret.toString();
    }
}
