/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.adaptergateway.docquery;

import java.net.*;
import java.net.URL;

import javax.ejb.*;
import javax.xml.namespace.*;

import gov.hhs.fha.nhinc.common.nhinccommon.*;
import gov.hhs.fha.nhinc.nhincproxydocquery.*;
import oasis.names.tc.ebxml_regrep.xsd.query._3.*;

import gov.va.med.nhin.adapter.propertylookup.*;

/**
 *
 * @author David Vazquez
 */
@Stateless(name = "NhincProxyNHINDocQueryRequestSender")
public class NhincProxyNHINDocQueryRequestSender implements NHINDocQueryRequestSender
{
    private NhincProxyDocQuery docQuery;
    private PropertyLookup propertyLookup;
    
    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }
    
    public AdhocQueryResponse sendRequest(AdhocQueryRequest adhocQueryRequest, AssertionType assertion, String remoteHomeCommunityId)
        throws Exception
    {
        AdhocQueryResponse ret;
        final gov.hhs.fha.nhinc.common.nhinccommonproxy.RespondingGatewayCrossGatewayQueryRequestType request =
            new gov.hhs.fha.nhinc.common.nhinccommonproxy.RespondingGatewayCrossGatewayQueryRequestType();
        request.setAdhocQueryRequest(adhocQueryRequest);
        request.setAssertion(assertion);
        request.setNhinTargetSystem(createNhinTarget(remoteHomeCommunityId));
        ret = getDocQueryPort().respondingGatewayCrossGatewayQuery(request);
        return ret;
    }

    private NhinTargetSystemType createNhinTarget(String homeCommunityId)
    {
        HomeCommunityType homeCommunity = new HomeCommunityType();
        homeCommunity.setHomeCommunityId(homeCommunityId);
        NhinTargetSystemType ret = new NhinTargetSystemType();
        ret.setHomeCommunity(homeCommunity);
        return ret;
    }

    private NhincProxyDocQueryPortType getDocQueryPort()
        throws MalformedURLException
    {
        if (docQuery == null) {
            docQuery = new NhincProxyDocQuery(new URL(propertyLookup.getProperty("DocQueryProxyWSDL")),
                                              new QName("urn:gov:hhs:fha:nhinc:nhincproxydocquery", "NhincProxyDocQuery"));
        }

        return docQuery.getNhincProxyDocQueryPortSoap();
    }
}
