/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.terminology;

import java.sql.*;

import javax.annotation.*;
import javax.ejb.*;
import javax.persistence.*;
import javax.sql.*;
import javax.jws.*;

/**
 *
 * @author David Vazquez
 */
@WebService(serviceName = "TerminologyService",
            wsdlLocation = "META-INF/wsdl/Terminology.wsdl",
            portName = "TerminologyPort",
            endpointInterface = "gov.va.med.nhin.adapter.terminology.TerminologyPortType",
            targetNamespace = "urn:gov:va:med:nhin:adapter:terminology")
@Stateless(name="Terminology", mappedName="Terminology")
public class TerminologyBean implements TerminologyLocal, TerminologyRemote, TerminologyPortType
{
    @Resource(name = "jdbc/NHIN")
    private DataSource dataSource;

    @PersistenceContext
    private EntityManager entityManager;

    public String lookup(String codeSet,
                         String code,
                         String field)
    {
        String ret = "";
        Connection connection = null;

        try {
            connection = getConnection();
            Codeset codeset = getCodeset(codeSet);
            if (codeset != null) {
                ret = getValue(connection, codeset, code, field);
            }
        }
        catch (SQLException se) {
            throw new RuntimeException("A database error occurred.", se);
        }
        finally {
            closeConnection(connection);
        }

        return ret;
    }

    public String translate(String sourceCodeset,
                            String code,
                            String targetCodeset,
                            String field)
    {
        String ret = "";
        Connection connection = null;

        try {
            connection = getConnection();
            Translation translation = getTranslation(sourceCodeset, code, targetCodeset);
            if (translation != null) {
                Codeset codeset = getCodeset(translation.getTargetCodeset());
                if (codeset != null) {
                    ret = getValue(connection, codeset, translation.getTargetCode(), field);
                }
            }
        }
        catch (SQLException se) {
            throw new RuntimeException("A database error occurred.", se);
        }
        finally {
            closeConnection(connection);
        }

        return ret;
    }

    private Connection getConnection()
        throws SQLException
    {
        return dataSource.getConnection();
    }

    private void closeConnection(Connection connection)
    {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException se) {
        }
    }

    private Codeset getCodeset(String codeset)
    {
        Codeset ret = null;
        Query query = entityManager.createNamedQuery("Codeset.findByCodeset");
        query.setParameter("codeset", codeset);
        try {
            ret = (Codeset)query.getSingleResult();
        }
        catch (NoResultException nre) {}
        return ret;
    }

    private String getValue(Connection connection, Codeset codeset, String code, String field)
        throws SQLException
    {
        String ret = null;
        String sql = "select " + field + " from "  + codeset.getLookupTable() + " where " + codeset.getKeyField() + "= ?";
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, code);
        ResultSet rs = statement.executeQuery();
        if (rs.next()) {
            ret = rs.getString(1);
        }
        return ret;
    }

    private Translation getTranslation(String sourceCodeset, String sourceCode, String targetCodeset)
    {
        Translation ret = null;
        Query query = entityManager.createNamedQuery("Translation.findTranslation");
        query.setParameter("sourceCodeset", sourceCodeset);
        query.setParameter("sourceCode", sourceCode);
        query.setParameter("targetCodeset", targetCodeset);
        try {
            ret = (Translation)query.getSingleResult();
        }
        catch (NoResultException nre) {}
        return ret;
    }
}
