/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package gov.va.med.nhin.adapter.datamanager.translators;

import java.util.*;

import javax.naming.*;

import gov.va.med.nhin.adapter.datamanager.*;
import gov.va.med.nhin.adapter.datamanager.Reference;
import gov.va.med.nhin.adapter.terminology.*;
import gov.va.med.nhin.adapter.utils.config.*;

/**
 *
 * @author David Vazquez
 */
public class TerminologyEJBDataTranslator implements DataTranslator
{
    private InitialContext context;

    public Object translate(Object input, Object result, Reference translationType, DataQuery dataQuery)
    {
        Object ret = input;

        try {
            String sourceCodeset = translationType.getProperty("sourceCodeset");
            String targetCodeset = translationType.getProperty("targetCodeset");
            String field = translationType.getProperty("field");
            Terminology t = getTerminology(translationType);
            ret = t.translate(sourceCodeset, (String)input, targetCodeset, field);
        }
        catch (Throwable t) {
            throw new DataManagerException("An error occured when translating.", t);
        }

        return ret;
    }

    private Terminology getTerminology(Reference translationType)
        throws Exception
    {
        if (context == null) {
            context = getInitialContext(translationType);
        }
        Terminology ret = (Terminology)context.lookup("Terminology#gov.va.med.nhin.adapter.terminology.TerminologyRemote");
        return ret;
    }

    private InitialContext getInitialContext(Reference translationType) throws Exception
    {
        InitialContext ret;

        PropertiesType propertiesType = translationType.getProperties("initialContextProperties");
        if (propertiesType != null) {
            Properties properties = PropertyTypeUtils.toProperties(propertiesType);
            ret = new InitialContext(properties);
        }
        else {
            ret = new InitialContext();
        }

        return ret;
    }
}
