/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package gov.va.med.nhin.adapter.audit;

import java.util.*;
import java.util.logging.*;

import javax.ejb.*;
import javax.jws.*;
import javax.persistence.*;
import javax.xml.datatype.*;

import gov.va.med.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
@WebService(serviceName = "AuditManagerService",
            wsdlLocation = "META-INF/wsdl/AuditManager.wsdl",
            portName = "AuditManagerPort",
            endpointInterface = "gov.va.med.nhin.adapter.audit.AuditManagerPortType",
            targetNamespace = "urn:gov:va:med:nhin:adapter:audit")
@Stateless(name = "AuditManager", mappedName = "AuditManager")
public class AuditManagerBean implements AuditManagerRemote, AuditManagerLocal, AuditManagerPortType
{
    static private final Logger logger = Logger.getLogger(AuditManagerBean.class.getName());
    
    private EntityManager entityManager;
    
    @PersistenceContext
    public void setEntityManager(EntityManager entityManager)
    {
        this.entityManager = entityManager;
    }

    public List getAuditsByICN(String icn, Date fromDate, Date toDate)
    {
        Query query;
        if (fromDate != null && toDate != null) {
            query = entityManager.createNamedQuery("Audit.findByIcnAndDate");
            query.setParameter("fromDate", fromDate);
            query.setParameter("toDate", toDate);
        }
        else {
            query = entityManager.createNamedQuery("Audit.findByIcn");
        }

        query.setParameter("icn", icn);
        return query.getResultList();
    }

    public List getAuditsByICN(String icn, Date fromDate, Date toDate, String action)
    {
        Query query;
        if (fromDate != null && toDate != null) {
            query = entityManager.createNamedQuery("Audit.findByIcnAndActionAndDate");
            query.setParameter("fromDate", fromDate);
            query.setParameter("toDate", toDate);
        }
        else {
            query = entityManager.createNamedQuery("Audit.findByIcnAndAction");
        }

        query.setParameter("icn", icn);
        query.setParameter("action", action);
        return query.getResultList();
    }

    public List getAuditsByICN(String icn, Date fromDate, Date toDate, String[] actions)
    {
        return getAudits(fromDate, toDate, new String[]{icn}, false, null, false, null, false, actions, false, -1, -1);
    }

    public List getAuditsByUserId(String userId, Date fromDate, Date toDate)
    {
        Query query;
        if (fromDate != null && toDate != null) {
            query = entityManager.createNamedQuery("Audit.findByUserIdAndDate");
            query.setParameter("fromDate", fromDate);
            query.setParameter("toDate", toDate);
        }
        else {
            query = entityManager.createNamedQuery("Audit.findByUserId");
        }

        query.setParameter("userId", userId);
        return query.getResultList();
    }

    public GetAuditsResponseType getAudits(GetAuditsType body)
    {
        GetAuditsResponseType ret = new GetAuditsResponseType();
        Date fromDate = null, toDate = null;
        String[] patientIds = null;
        boolean notPatientIds = false;
        String[] patientSSNs = null;
        boolean notPatientSSNs = false;
        String[] patientGivenNames = null;
        boolean notPatientGivenNames = false;
        String[] patientLastNames = null;
        boolean notPatientLastNames = false;
        String[] patientFacilityNumbers = null;
        boolean notPatientFacilityNumbers = false;
        String[] organizations = null;
        boolean notOrganizations = false;
        String[] remoteOrganizations = null;
        boolean notRemoteOrganizations = false;
        String[] userIds = null;
        boolean notUserIds = false;
        String[] userNames = null;
        boolean notUserNames = false;
        String[] userFacilityNumbers = null;
        boolean notUserFacilityNumbers = false;
        String[] actions = null;
        boolean notActions = false;
        String details = null;
        int pageSize = -1, pageNumber = 0;
        SortFieldsType sortFields = null;
        
        try {
            if (body.getFromDate() != null) {
                fromDate = body.getFromDate().toGregorianCalendar().getTime();
            }

            if (body.getToDate() != null) {
                toDate = body.getToDate().toGregorianCalendar().getTime();
            }

            if (body.getPatientIds() != null) {
                patientIds = body.getPatientIds().getValue().toArray(new String[body.getPatientIds().getValue().size()]);
                notPatientIds = body.getPatientIds().isNotIn();
            }

            if (body.getPatientSSNs() != null) {
                patientSSNs = body.getPatientSSNs().getValue().toArray(new String[body.getPatientSSNs().getValue().size()]);
                notPatientSSNs = body.getPatientSSNs().isNotIn();
            }
            if (body.getPatientGivenNames() != null) {
                patientGivenNames = body.getPatientGivenNames().getValue().toArray(new String[body.getPatientGivenNames().getValue().size()]);
                notPatientGivenNames = body.getPatientGivenNames().isNotIn();
            }
            if (body.getPatientLastNames() != null) {
                patientLastNames = body.getPatientLastNames().getValue().toArray(new String[body.getPatientLastNames().getValue().size()]);
                notPatientLastNames = body.getPatientLastNames().isNotIn();
            }
            
            if (body.getPatientFacilityNumbers() != null) {
                patientFacilityNumbers = body.getPatientFacilityNumbers().getValue().toArray(new String[body.getPatientFacilityNumbers().getValue().size()]);
                notPatientFacilityNumbers = body.getPatientFacilityNumbers().isNotIn();
            }
            
            if (body.getOrganizationIds() != null) {
                organizations = body.getOrganizationIds().getValue().toArray(new String[body.getOrganizationIds().getValue().size()]);
                notOrganizations = body.getOrganizationIds().isNotIn();
            }

            if (body.getRemoteOrganizationIds() != null) {
                remoteOrganizations = body.getRemoteOrganizationIds().getValue().toArray(new String[body.getRemoteOrganizationIds().getValue().size()]);
                notRemoteOrganizations = body.getRemoteOrganizationIds().isNotIn();
            }

            if (body.getUserIds() != null) {
                userIds = body.getUserIds().getValue().toArray(new String[body.getUserIds().getValue().size()]);
                notUserIds = body.getUserIds().isNotIn();
            }

            if (body.getUserNames() != null) {
                userNames = body.getUserNames().getValue().toArray(new String[body.getUserNames().getValue().size()]);
                notUserNames = body.getUserNames().isNotIn();
            }
            
            if (body.getUserFacilityNumbers() != null) {
                userFacilityNumbers = body.getUserFacilityNumbers().getValue().toArray(new String[body.getUserFacilityNumbers().getValue().size()]);
                notUserIds = body.getUserFacilityNumbers().isNotIn();
            }
            
            if (body.getActions() != null) {
                actions = new String[body.getActions().getValue().size()];
                for (int i = 0;  i < actions.length;  ++i) {
                    actions[i] = body.getActions().getValue().get(i).value();
                }
                notActions = body.getActions().isNotIn();
            }

            details = body.getDetails();

            if (body.getPageInfo() != null) {
                PageInfoType pageInfo = body.getPageInfo();
                pageSize = pageInfo.getPageSize();
                pageNumber = pageInfo.getPageNumber();
            }
            else {
                pageSize = -1;
                pageNumber = 0;
            }
            
            if (body.getSortFields() != null && !NullChecker.isNullOrEmpty(body.getSortFields().getSortField())) {
                sortFields = body.getSortFields();
            }
            
            List<AuditsReport> audits = getAudits(fromDate, toDate,
                                                  patientIds, notPatientIds,
                                                  patientSSNs, notPatientSSNs,
                                                  patientGivenNames, notPatientGivenNames,
                                                  patientLastNames, notPatientLastNames,
                                                  patientFacilityNumbers, notPatientFacilityNumbers,
                                                  organizations, notOrganizations,
                                                  remoteOrganizations, notRemoteOrganizations,
                                                  userIds, notUserIds,
                                                  userNames, notUserNames,
                                                  userFacilityNumbers, notUserFacilityNumbers,
                                                  actions, notActions,
                                                  details, sortFields,
                                                  pageSize, pageNumber);

            PageInfoType pageInfo = new PageInfoType();
            pageInfo.setPageSize(pageSize != -1 ? Math.min(pageSize, audits.size()) : audits.size());
            pageInfo.setPageNumber(pageNumber);
            ret.setPageInfo(pageInfo);

            if (!NullChecker.isNullOrEmpty(audits)) {
                DatatypeFactory df = DatatypeFactory.newInstance();
                AuditsType auditsType = new AuditsType();
                ret.setAudits(auditsType);
                for (AuditsReport audit : audits) {
                    AuditType auditType = new AuditType();

                    auditType.setAuditId(audit.getAuditId().longValue());
                    auditType.setAction(ActionType.fromValue(audit.getActionName()));
                    Calendar auditTime = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
                    auditTime.setTime(audit.getAuditTime());
                    auditType.setAuditTime(df.newXMLGregorianCalendar((GregorianCalendar)auditTime));
                    auditType.setDocumentId(audit.getDocumentId());
                    auditType.setDocumentTitle(audit.getDocumentTitle());
                    auditType.setSourcePatientId(audit.getDocumentSourcePatientId());
                    auditType.setOptOutReason(audit.getOptOutReasonText());
                    auditType.setOrganizationId(audit.getOrganizationId());
                    auditType.setOrganizationName(audit.getOrganizationName());
                    auditType.setPatientId(audit.getPatientId());
                    auditType.setPatientSSN(audit.getPatientSSN());
                    auditType.setPatientGivenName(audit.getPatientGivenName());
                    auditType.setPatientLastName(audit.getPatientLastName());
                    auditType.setPatientFacilityNumber(audit.getPatientFacilityNumber());
                    auditType.setPatientFacilityName(audit.getPatientFacilityName());
                    auditType.setPurposeForUse(audit.getPurposeForUse());
                    auditType.setRemoteDocumentId(audit.getRemoteDocId());
                    auditType.setRemoteDocumentRepositoryId(audit.getRemoteDocRepositoryId());
                    auditType.setRemoteOrganizationId(audit.getRemoteOrganizationId());
                    auditType.setRemoteOrganizationName(audit.getRemoteOrganizationName());
                    auditType.setUserId(audit.getUserId());
                    auditType.setUserName(audit.getUserName());
                    auditType.setUserFacilityNumber(audit.getUserFacilityNumber());
                    auditType.setUserFacilityName(audit.getUserFacilityName());
                    auditType.setUserRole(audit.getUserRole());
                    auditType.setDetails(audit.getDetails());
                    auditsType.getAudit().add(auditType);
                }
            }
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException("There was an error process this request.", t);
        }

        return ret;
    }

    public List getAudits(Date fromDate, Date toDate,
                          String[] patientIds, boolean notPatientIds,
                          String[] organizations, boolean notOrganizations,
                          String[] remoteOrganizations, boolean notRemoteOrganizations,
                          String[] actions, boolean notActions,
                          int pageSize, int pageNumber)
    {
        return getAudits(fromDate, toDate,
                         patientIds, notPatientIds,
                         null, false,
                         null, false,
                         null, false,
                         null, false,
                         organizations, notOrganizations,
                         remoteOrganizations, notRemoteOrganizations,
                         null, false,
                         null, false,
                         null, false,
                         actions, notActions, 
                         null, null,
                         pageSize, pageNumber);
    }

    public List getAudits(Date fromDate, Date toDate,
                          String[] patientIds, boolean notPatientIds,
                          String[] organizations, boolean notOrganizations,
                          String[] remoteOrganizations, boolean notRemoteOrganizations,
                          String[] actions, boolean notActions,
                          String detailsSearch,
                          int pageSize, int pageNumber)
    {
        return getAudits(fromDate, toDate, 
                         patientIds, notPatientIds,
                         null, false,
                         null, false,
                         null, false,
                         null, false,
                         organizations, notOrganizations,
                         remoteOrganizations, notRemoteOrganizations,
                         null, false,
                         null, false,
                         null, false,
                         actions, notActions,
                         detailsSearch, null,
                         pageSize, pageNumber);
    }
    
    static private final Map<String, String> fields = new HashMap<String, String>();
    
    static {
        fields.put("auditTime", "a.auditTime");
        fields.put("action", "a.actionName");
        fields.put("userId", "a.userId");
        fields.put("userName", "a.userName");
        fields.put("userFacilityNumber", "a.userFacilityNumber");
        fields.put("organizationId", "a.organizationId");
        fields.put("organizationName", "a.organizationName");
        fields.put("patientId", "a.patientId");
        fields.put("patientSSN", "a.patientSSN");
        fields.put("patientLastName", "a.patientLastName");
        fields.put("patientGivenName", "a.patientGivenName");
        fields.put("patientFacilityNumber", "a.patientFacilityNumber");
        fields.put("patientFacilityName", "a.patientFacilityName");
        fields.put("purposeForUse", "a.purposeForUse");
        fields.put("remoteOrganizationId", "a.remoteOrganizationId");
        fields.put("remoteOrganizationName", "a.remoteOrganizationName");
        fields.put("optOutReason", "a.optOutReasonText");
        fields.put("documentId", "a.documentId");
        fields.put("documentTitle", "a.documentTitle");
    }
    
    public List getAudits(Date fromDate, Date toDate,
                          String[] patientIds, boolean notPatientIds,
                          String[] patientSSNs, boolean notPatientSSNs,
                          String[] patientGivenNames, boolean notPatientGivenNames,
                          String[] patientLastNames, boolean notPatientLastNames,
                          String[] patientFacilityNumbers, boolean notPatientFacilityNumbers,
                          String[] organizations, boolean notOrganizations,
                          String[] remoteOrganizations, boolean notRemoteOrganizations,
                          String[] userIds, boolean notUserIds,
                          String[] userNames, boolean notUserNames,
                          String[] userFacilityNumbers, boolean notUserFacilityNumbers,
                          String[] actions, boolean notActions,
                          String detailsSearch,
                          SortFieldsType sortFields,
                          int pageSize, int pageNumber)
    {
        HashMap<String, Object> setParams = new HashMap<String, Object>();
        String whereClause = buildWhereClause(fromDate, toDate,
                                              patientIds, notPatientIds,
                                              patientSSNs, notPatientSSNs,
                                              patientGivenNames, notPatientGivenNames,
                                              patientLastNames, notPatientLastNames,
                                              patientFacilityNumbers, notPatientFacilityNumbers,
                                              organizations, notOrganizations,
                                              remoteOrganizations, notRemoteOrganizations,
                                              userIds, notUserIds,
                                              userNames, notUserIds,
                                              userFacilityNumbers, notUserFacilityNumbers,
                                              actions, notActions,
                                              detailsSearch,
                                              setParams);

        String orderByClause = null;
        if (sortFields != null && !NullChecker.isNullOrEmpty(sortFields.getSortField())) {
            for (SortFieldType sortField : sortFields.getSortField()) {
                String field = null;
                if (sortField.getField() != null && (field = fields.get(sortField.getField().value())) != null) {
                    if (orderByClause == null) {
                        orderByClause = "ORDER BY ";
                    }
                    else {
                        orderByClause += ",";
                    }

                    orderByClause += field + (sortField.getDirection() == SortDirection.DESC ? " DESC" : " ASC");
                }
                else {
                    throw new RuntimeException("Invalid field name was used as sortField.");
                }
            }
        }
        else {
            orderByClause = "ORDER BY a.auditTime DESC";
        }
       
        String q = "SELECT a FROM AuditsReport a " + whereClause + " " + orderByClause;
        logger.log(Level.FINEST, "Query: {0}", q);
        
        Query query = entityManager.createQuery(q);

        if (pageSize > 0 && pageNumber >= 0) {
            query.setFirstResult(pageNumber * pageSize);
            query.setMaxResults(pageSize + 1);
        }

        for (Map.Entry<String, Object> entry : setParams.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }

        return query.getResultList();
    }

    private String buildWhereClause(Date fromDate, Date toDate,
                                    String[] patientIds, boolean notPatientIds,
                                    String[] patientSSNs, boolean notPatientSSNs,
                                    String[] patientGivenNames, boolean notPatientGivenNames,
                                    String[] patientLastNames, boolean notPatientLastNames,
                                    String[] patientFacilityNumbers, boolean notPatientFacilityNumbers,
                                    String[] organizations, boolean notOrganizations,
                                    String[] remoteOrganizations, boolean notRemoteOrganizations,
                                    String[] userIds, boolean notUserIds,
                                    String[] userNames, boolean notUserNames,
                                    String[] userFacilityNumbers, boolean notUserFacilityNumbers,
                                    String[] actions, boolean notActions,
                                    String detailsSearch,
                                    HashMap<String, Object> setParams)
    {
        StringBuffer whereClause = new StringBuffer();

        if (fromDate != null) {
            appendWhereClause(whereClause, "a.auditTime >= :fromDate");
            setParams.put("fromDate", fromDate);
        }

        if (toDate != null) {
            appendWhereClause(whereClause, "a.auditTime <= :toDate");
            setParams.put("toDate", toDate);
        }

        if (!NullChecker.isNullOrEmpty(patientIds)) {
            if (!notPatientIds) {
                appendWhereClause(whereClause, "a.patientId in (:icn0");
            }
            else {
                appendWhereClause(whereClause, "a.patientId not in (:icn0");
            }
            setParams.put("icn0", patientIds[0]);

            for (int i = 1; i < patientIds.length; ++i) {
                whereClause.append(",:icn").append(i);
                setParams.put("icn" + i, patientIds[i]);
            }

            whereClause.append(')');
        }

        if (!NullChecker.isNullOrEmpty(patientSSNs)) {
            if (!notPatientSSNs) {
                appendWhereClause(whereClause, "a.patientSSN in (:patientSSN0");
            }
            else {
                appendWhereClause(whereClause, "a.patientSSN not in (:patientSSN0");
            }
            setParams.put("patientSSN0", patientSSNs[0]);

            for (int i = 1; i < patientSSNs.length; ++i) {
                whereClause.append(",:patientSSN").append(i);
                setParams.put("patientSSN" + i, patientSSNs[i]);
            }

            whereClause.append(')');
        }
        
        if (!NullChecker.isNullOrEmpty(patientGivenNames)) {
            if (!notPatientGivenNames) {
                appendWhereClause(whereClause, "UPPER(a.patientGivenName) in (:patientGivenName0");
            }
            else {
                appendWhereClause(whereClause, "UPPER(a.patientGivenName) not in (:patientGivenName0");
            }
            setParams.put("patientGivenName0", patientGivenNames[0].toUpperCase());

            for (int i = 1; i < patientGivenNames.length; ++i) {
                whereClause.append(",:patientGivenName").append(i);
                setParams.put("patientGivenName" + i, patientGivenNames[i].toUpperCase());
            }

            whereClause.append(')');
        }
        
        if (!NullChecker.isNullOrEmpty(patientLastNames)) {
            if (!notPatientLastNames) {
                appendWhereClause(whereClause, "UPPER(a.patientLastName) in (:patientLastName0");
            }
            else {
                appendWhereClause(whereClause, "UPPER(a.patientLastName) not in (:patientLastName0");
            }
            setParams.put("patientLastName0", patientLastNames[0].toUpperCase());

            for (int i = 1; i < patientLastNames.length; ++i) {
                whereClause.append(",:patientLastName").append(i);
                setParams.put("patientLastName" + i, patientLastNames[i].toUpperCase());
            }

            whereClause.append(')');
        }
        
        if (!NullChecker.isNullOrEmpty(patientFacilityNumbers)) {
            if (!notPatientFacilityNumbers) {
                appendWhereClause(whereClause, "UPPER(a.patientFacilityNumber) in (:patientFacilityNumber0");
            }
            else {
                appendWhereClause(whereClause, "UPPER(a.patientFacilityNumber) not in (:patientFacilityNumber0");
            }
            setParams.put("patientFacilityNumber0", patientFacilityNumbers[0].toUpperCase());

            for (int i = 1; i < patientFacilityNumbers.length; ++i) {
                whereClause.append(",:patientFacilityNumber").append(i);
                setParams.put("patientFacilityNumber" + i, patientFacilityNumbers[i].toUpperCase());
            }

            whereClause.append(')');
        }
        
        if (!NullChecker.isNullOrEmpty(organizations) || !NullChecker.isNullOrEmpty(remoteOrganizations)) {
            appendWhereClause(whereClause, "(");
            StringBuffer inClause = new StringBuffer();

            if (!NullChecker.isNullOrEmpty(organizations)) {
                if (!notOrganizations) {
                    appendWhereClause(inClause, "a.organizationId like :organization0", "", " OR ");
                }
                else {
                    appendWhereClause(inClause, "not (a.organizationId like :organization0", "", " OR ");
                }
                setParams.put("organization0", organizations[0]);

                for (int i = 1; i < organizations.length; ++i) {
                    inClause.append(" OR a.organizationId like :organization").append(i);
                    setParams.put("organization" + i, organizations[i]);
                }

                if (notOrganizations) {
                    inClause.append(')');
                }
            }

            if (!NullChecker.isNullOrEmpty(remoteOrganizations)) {
                if (!notRemoteOrganizations) {
                    appendWhereClause(inClause, "a.remoteOrganizationId like :remoteOrganization0", "", " OR ");
                }
                else {
                    appendWhereClause(inClause, "not (a.remoteOrganizationId like :remoteOrganization0", "", " OR ");
                }
                setParams.put("remoteOrganization0", remoteOrganizations[0]);

                for (int i = 1; i < remoteOrganizations.length; ++i) {
                    inClause.append(" OR a.remoteOrganizationId LIKE :remoteOrganization").append(i);
                    setParams.put("remoteOrganization" + i, remoteOrganizations[i]);
                }

                if (notRemoteOrganizations) {
                    inClause.append(')');
                }
            }

            whereClause.append(inClause).append(")");
        }

        if (!NullChecker.isNullOrEmpty(userIds)) {
            if (!notUserIds) {
                appendWhereClause(whereClause, "UPPER(a.userId) in (:userId0");
            }
            else {
                appendWhereClause(whereClause, "UPPER(a.useId) not in (:userId0");
            }
            setParams.put("userId0", userIds[0].toUpperCase());
            
            for (int i = 1;  i < userIds.length;  ++i) {
                whereClause.append(",:userId").append(i);
                setParams.put("userId" + i, userIds[i].toUpperCase());
            }
            
            whereClause.append(")");
        }
        
        if (!NullChecker.isNullOrEmpty(userNames)) {
            if (!notUserNames) {
                appendWhereClause(whereClause, "UPPER(a.userName) in (:userName0");
            }
            else {
                appendWhereClause(whereClause, "UPPER(a.useName) not in (:userName0");
            }
            setParams.put("userName0", userNames[0].toUpperCase());
            
            for (int i = 1;  i < userNames.length;  ++i) {
                whereClause.append(",:userName").append(i);
                setParams.put("userName" + i, userNames[i].toUpperCase());
            }
            
            whereClause.append(")");
        }
        
        if (!NullChecker.isNullOrEmpty(userFacilityNumbers)) {
            if (!notUserNames) {
                appendWhereClause(whereClause, "UPPER(a.userFacilityNumber) in (:userFacilityNumber0");
            }
            else {
                appendWhereClause(whereClause, "UPPER(a.useFacilityNumber) not in (:userFacilityNumber0");
            }
            setParams.put("userFacilityNumber0", userFacilityNumbers[0].toUpperCase());
            
            for (int i = 1;  i < userFacilityNumbers.length;  ++i) {
                whereClause.append(",:userFacilityNumber").append(i);
                setParams.put("userFacilityNumber" + i, userFacilityNumbers[i].toUpperCase());
            }
            
            whereClause.append(")");
        }
        
        if (!NullChecker.isNullOrEmpty(actions)) {
            if (!notActions) {
                appendWhereClause(whereClause, "a.actionName in (:action0");
            }
            else {
                appendWhereClause(whereClause, "a.actionName not in (:action0");
            }
            setParams.put("action0", actions[0]);

            for (int i = 1; i < actions.length; ++i) {
                whereClause.append(",:action").append(i);
                setParams.put("action" + i, actions[i]);
            }

            whereClause.append(")");
        }

        if (detailsSearch != null) {
            String search = "%" + detailsSearch.trim() + "%";
            appendWhereClause(whereClause, "a.details LIKE :search");
            setParams.put("search", search);
        }
        
        return whereClause.toString();
    }
    
    private void appendWhereClause(StringBuffer buffer, String str)
    {
        appendWhereClause(buffer, str, "WHERE ", " AND ");
    }

    private void appendWhereClause(StringBuffer buffer, String str, String empty, String notEmpty)
    {
        if (buffer.length() > 0) {
            buffer.append(notEmpty);
        }
        else {
            buffer.append(empty);
        }
        buffer.append(str);
    }

    public void storeAudit(Audit audit)
    {
        audit.setAuditTime(new Date());
        
        if (audit.getAuditId() == null) {
            entityManager.persist(audit);
        }
        else {
            entityManager.merge(audit);
        }
    }

    public GetAuditsSummaryResponseType getAuditsSummary(GetAuditsSummaryType body)
    {
        GetAuditsSummaryResponseType ret = new GetAuditsSummaryResponseType();
        Date fromDate = null, toDate = null;
        String[] patientIds = null;
        boolean notPatientIds = false;
        String[] patientSSNs = null;
        boolean notPatientSSNs = false;
        String[] patientGivenNames = null;
        boolean notPatientGivenNames = false;
        String[] patientLastNames = null;
        boolean notPatientLastNames = false;
        String[] patientFacilityNumbers = null;
        boolean notPatientFacilityNumbers = false;
        String[] organizations = null;
        boolean notOrganizations = false;
        String[] remoteOrganizations = null;
        boolean notRemoteOrganizations = false;
        String[] userIds = null;
        boolean notUserIds = false;
        String[] userNames = null;
        boolean notUserNames = false;
        String[] userFacilityNumbers = null;
        boolean notUserFacilityNumbers = false;
        String[] actions = null;
        boolean notActions = false;
        String details = null;
        GroupByFieldsType groupByFields = null;
        
        try {
            if (body.getFromDate() != null) {
                fromDate = body.getFromDate().toGregorianCalendar().getTime();
            }

            if (body.getToDate() != null) {
                toDate = body.getToDate().toGregorianCalendar().getTime();
            }

            if (body.getPatientIds() != null) {
                patientIds = body.getPatientIds().getValue().toArray(new String[body.getPatientIds().getValue().size()]);
                notPatientIds = body.getPatientIds().isNotIn();
            }

            if (body.getPatientSSNs() != null) {
                patientSSNs = body.getPatientSSNs().getValue().toArray(new String[body.getPatientSSNs().getValue().size()]);
                notPatientSSNs = body.getPatientSSNs().isNotIn();
            }
            if (body.getPatientGivenNames() != null) {
                patientGivenNames = body.getPatientGivenNames().getValue().toArray(new String[body.getPatientGivenNames().getValue().size()]);
                notPatientGivenNames = body.getPatientGivenNames().isNotIn();
            }
            if (body.getPatientLastNames() != null) {
                patientLastNames = body.getPatientLastNames().getValue().toArray(new String[body.getPatientLastNames().getValue().size()]);
                notPatientLastNames = body.getPatientLastNames().isNotIn();
            }

            if (body.getPatientFacilityNumbers() != null) {
                patientFacilityNumbers = body.getPatientFacilityNumbers().getValue().toArray(new String[body.getPatientFacilityNumbers().getValue().size()]);
                notPatientFacilityNumbers = body.getPatientFacilityNumbers().isNotIn();
            }
            
            if (body.getOrganizationIds() != null) {
                organizations = body.getOrganizationIds().getValue().toArray(new String[body.getOrganizationIds().getValue().size()]);
                notOrganizations = body.getOrganizationIds().isNotIn();
            }

            if (body.getRemoteOrganizationIds() != null) {
                remoteOrganizations = body.getRemoteOrganizationIds().getValue().toArray(new String[body.getRemoteOrganizationIds().getValue().size()]);
                notRemoteOrganizations = body.getRemoteOrganizationIds().isNotIn();
            }

            if (body.getUserIds() != null) {
                userIds = body.getUserIds().getValue().toArray(new String[body.getUserIds().getValue().size()]);
                notUserIds = body.getUserIds().isNotIn();
            }

            if (body.getUserNames() != null) {
                userNames = body.getUserNames().getValue().toArray(new String[body.getUserNames().getValue().size()]);
                notUserNames = body.getUserNames().isNotIn();
            }
            
            if (body.getUserFacilityNumbers() != null) {
                userFacilityNumbers = body.getUserFacilityNumbers().getValue().toArray(new String[body.getUserFacilityNumbers().getValue().size()]);
                notUserIds = body.getUserFacilityNumbers().isNotIn();
            }

            if (body.getActions() != null) {
                actions = new String[body.getActions().getValue().size()];
                for (int i = 0;  i < actions.length;  ++i) {
                    actions[i] = body.getActions().getValue().get(i).value();
                }
                notActions = body.getActions().isNotIn();
            }

            details = body.getDetails();


            if (body.getGroupByFields() != null && !NullChecker.isNullOrEmpty(body.getGroupByFields().getGroupByField())) {
                groupByFields = body.getGroupByFields();
            }
            
            List<Object> results = getAuditsSummary(fromDate, toDate,
                                                    patientIds, notPatientIds,
                                                    patientSSNs, notPatientSSNs,
                                                    patientGivenNames, notPatientGivenNames,
                                                    patientLastNames, notPatientLastNames,
                                                    patientFacilityNumbers, notPatientFacilityNumbers,
                                                    organizations, notOrganizations,
                                                    remoteOrganizations, notRemoteOrganizations,
                                                    userIds, notUserIds,
                                                    userNames, notUserNames,
                                                    userFacilityNumbers, notUserFacilityNumbers,
                                                    actions, notActions,
                                                    details, groupByFields);

            ret.setGroupByFields(groupByFields);
            
            if (!NullChecker.isNullOrEmpty(results)) {
                AuditSummariesType auditSummaries = new AuditSummariesType();
                ret.setAuditSummaries(auditSummaries);
                for (Object result : results) {
                    AuditSummaryType auditSummary = new AuditSummaryType();
                    if (groupByFields != null) {
                        Object[] r = (Object[])result;
                        SummaryFieldsType g = new SummaryFieldsType();
                        auditSummary.setSummaryFields(g);
                        for (int i = 0;  i < r.length - 1;  ++i) {
                            if (r[i] != null) {
                                g.getSummaryField().add(r[i].toString());
                            }
                            else {
                                g.getSummaryField().add("NULL");
                            }
                        }
                        auditSummary.setCount((Long)r[r.length-1]);
                    }
                    else {
                        auditSummary.setCount((Long)result);
                    }
                    
                    auditSummaries.getAuditSummary().add(auditSummary);
                }
            }
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException("There was an error process this request.", t);
        }

        return ret;
    }

    public List getAuditsSummary(Date fromDate, Date toDate,
                                 String[] patientIds, boolean notPatientIds,
                                 String[] patientSSNs, boolean notPatientSSNs,
                                 String[] patientGivenNames, boolean notPatientGivenNames,
                                 String[] patientLastNames, boolean notPatientLastNames,
                                 String[] patientFacilityNumbers, boolean notPatientFacilityNumbers,
                                 String[] organizations, boolean notOrganizations,
                                 String[] remoteOrganizations, boolean notRemoteOrganizations,
                                 String[] userIds, boolean notUserIds,
                                 String[] userNames, boolean notUserNames,
                                 String[] userFacilityNumbers, boolean notUserFacilityNumbers,
                                 String[] actions, boolean notActions,
                                 String detailsSearch,
                                 GroupByFieldsType groupByFields)
    {
        HashMap<String, Object> setParams = new HashMap<String, Object>();
        String whereClause = buildWhereClause(fromDate, toDate,
                                              patientIds, notPatientIds,
                                              patientSSNs, notPatientSSNs,
                                              patientGivenNames, notPatientGivenNames,
                                              patientLastNames, notPatientLastNames,
                                              patientFacilityNumbers, notPatientFacilityNumbers,
                                              organizations, notOrganizations,
                                              remoteOrganizations, notRemoteOrganizations,
                                              userIds, notUserIds,
                                              userNames, notUserNames,
                                              userFacilityNumbers, notUserFacilityNumbers,
                                              actions, notActions,
                                              detailsSearch,
                                              setParams);
        String selectClause = null;
        String groupByClause = null;
        
        if (groupByFields != null && !NullChecker.isNullOrEmpty(groupByFields.getGroupByField())) {
            for (FieldType groupByField : groupByFields.getGroupByField()) {
                String field = null;
                if (groupByField != null && (field = fields.get(groupByField.value())) != null) {
                    if (selectClause == null) {
                        selectClause = field;
                        groupByClause = "GROUP BY " + field;
                    }
                    else {
                        selectClause += "," + field;
                        groupByClause += "," + field;
                    }
                }
                else {
                    throw new RuntimeException("Invalid field name was used as groupByField.");
                }
            }
            selectClause += ",COUNT(a.auditId)";
        }
        else {
            selectClause = "COUNT(a.auditId)";
            groupByClause = "";
        }
        
        String q = "SELECT " + selectClause + " FROM AuditsReport a " + whereClause + " " + groupByClause;
        logger.log(Level.FINEST, "Query: {0}", q);
        
        Query query = entityManager.createQuery(q);
        
        for (Map.Entry<String, Object> entry : setParams.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }

        return query.getResultList();
    }
}
