CREATE USER ADAPTER
  IDENTIFIED BY adapter
  DEFAULT TABLESPACE USERS
  TEMPORARY TABLESPACE TEMP
  PROFILE DEFAULT
  ACCOUNT UNLOCK;
  -- 2 Roles for ADAPTER 
  GRANT CONNECT TO ADAPTER;
  GRANT RESOURCE TO ADAPTER;
  ALTER USER ADAPTER DEFAULT ROLE ALL;
  -- 206 System Privileges for ADAPTER 
  GRANT ALTER PUBLIC DATABASE LINK TO ADAPTER;
  GRANT CREATE CUBE DIMENSION TO ADAPTER;
  GRANT EXECUTE ANY ASSEMBLY TO ADAPTER;
  GRANT ALTER ANY EDITION TO ADAPTER;
  GRANT EXEMPT IDENTITY POLICY TO ADAPTER;
  GRANT CREATE ANY SQL PROFILE TO ADAPTER;
  GRANT ADMINISTER ANY SQL TUNING SET TO ADAPTER;
  GRANT DROP ANY SQL PROFILE TO ADAPTER;
  GRANT EXECUTE ANY CLASS TO ADAPTER;
  BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.DROP_ANY_RULE,
  GRANTEE      => 'ADAPTER',
  GRANT_OPTION => FALSE);
END;
/
  BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.ALTER_ANY_RULE,
  GRANTEE      => 'ADAPTER',
  GRANT_OPTION => FALSE);
END;
/
  BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.DROP_ANY_RULE_SET,
  GRANTEE      => 'ADAPTER',
  GRANT_OPTION => FALSE);
END;
/
  BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.ALTER_ANY_RULE_SET,
  GRANTEE      => 'ADAPTER',
  GRANT_OPTION => FALSE);
END;
/
  GRANT FLASHBACK ANY TABLE TO ADAPTER;
  GRANT ALTER ANY OUTLINE TO ADAPTER;
  GRANT EXECUTE ANY INDEXTYPE TO ADAPTER;
  GRANT DROP ANY INDEXTYPE TO ADAPTER;
  GRANT ALTER ANY INDEXTYPE TO ADAPTER;
  GRANT CREATE INDEXTYPE TO ADAPTER;
  GRANT EXECUTE ANY OPERATOR TO ADAPTER;
  GRANT DROP ANY MATERIALIZED VIEW TO ADAPTER;
  GRANT AUDIT ANY TO ADAPTER;
  GRANT DROP ANY ROLE TO ADAPTER;
  GRANT CREATE PUBLIC DATABASE LINK TO ADAPTER;
  GRANT DROP ANY VIEW TO ADAPTER;
  GRANT UPDATE ANY TABLE TO ADAPTER;
  GRANT BECOME USER TO ADAPTER;
  GRANT UNLIMITED TABLESPACE TO ADAPTER;
  GRANT CREATE ANY MEASURE FOLDER TO ADAPTER;
  GRANT ALTER ANY CUBE TO ADAPTER;
  GRANT COMMENT ANY MINING MODEL TO ADAPTER;
  GRANT CREATE ANY ASSEMBLY TO ADAPTER;
  GRANT ADMINISTER SQL TUNING SET TO ADAPTER;
  GRANT ALTER ANY SQL PROFILE TO ADAPTER;
  GRANT MANAGE SCHEDULER TO ADAPTER;
  GRANT IMPORT FULL DATABASE TO ADAPTER;
  GRANT EXPORT FULL DATABASE TO ADAPTER;
  BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.CREATE_ANY_RULE_SET,
  GRANTEE      => 'ADAPTER',
  GRANT_OPTION => FALSE);
END;
/
  BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.EXECUTE_ANY_EVALUATION_CONTEXT,
  GRANTEE      => 'ADAPTER',
  GRANT_OPTION => FALSE);
END;
/
  BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.DROP_ANY_EVALUATION_CONTEXT,
  GRANTEE      => 'ADAPTER',
  GRANT_OPTION => FALSE);
END;
/
  BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.CREATE_ANY_EVALUATION_CONTEXT,
  GRANTEE      => 'ADAPTER',
  GRANT_OPTION => FALSE);
END;
/
  GRANT DEBUG CONNECT SESSION TO ADAPTER;
  GRANT CREATE ANY DIMENSION TO ADAPTER;
  GRANT DROP ANY LIBRARY TO ADAPTER;
  GRANT EXECUTE ANY TYPE TO ADAPTER;
  GRANT CREATE ANY TYPE TO ADAPTER;
  GRANT CREATE TYPE TO ADAPTER;
  GRANT CREATE MATERIALIZED VIEW TO ADAPTER;
  GRANT DROP PROFILE TO ADAPTER;
  GRANT ALTER PROFILE TO ADAPTER;
  GRANT CREATE ANY PROCEDURE TO ADAPTER;
  GRANT FORCE ANY TRANSACTION TO ADAPTER;
  GRANT FORCE TRANSACTION TO ADAPTER;
  GRANT DROP PUBLIC DATABASE LINK TO ADAPTER;
  GRANT CREATE DATABASE LINK TO ADAPTER;
  GRANT SELECT ANY SEQUENCE TO ADAPTER;
  GRANT CREATE ANY SEQUENCE TO ADAPTER;
  GRANT CREATE PUBLIC SYNONYM TO ADAPTER;
  GRANT ALTER ANY INDEX TO ADAPTER;
  GRANT ALTER USER TO ADAPTER;
  GRANT CREATE TABLESPACE TO ADAPTER;
  GRANT ALTER SYSTEM TO ADAPTER;
  GRANT CREATE ANY CUBE BUILD PROCESS TO ADAPTER;
  GRANT UPDATE ANY CUBE TO ADAPTER;
  GRANT DROP ANY CUBE DIMENSION TO ADAPTER;
  GRANT EXECUTE ASSEMBLY TO ADAPTER;
  GRANT CREATE ANY EDITION TO ADAPTER;
  GRANT CREATE JOB TO ADAPTER;
  GRANT ANALYZE ANY DICTIONARY TO ADAPTER;
  BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.CREATE_RULE_SET_OBJ,
  GRANTEE      => 'ADAPTER',
  GRANT_OPTION => FALSE);
END;
/
  GRANT SELECT ANY DICTIONARY TO ADAPTER;
  GRANT ADMINISTER DATABASE TRIGGER TO ADAPTER;
  GRANT DROP ANY OUTLINE TO ADAPTER;
  GRANT DROP ANY CONTEXT TO ADAPTER;
  GRANT ALTER ANY DIMENSION TO ADAPTER;
  GRANT CREATE ANY INDEXTYPE TO ADAPTER;
  GRANT UNDER ANY TYPE TO ADAPTER;
  GRANT DROP ANY DIRECTORY TO ADAPTER;
  GRANT ANALYZE ANY TO ADAPTER;
  GRANT CREATE PROFILE TO ADAPTER;
  GRANT ALTER ANY ROLE TO ADAPTER;
  GRANT GRANT ANY ROLE TO ADAPTER;
  GRANT CREATE ROLE TO ADAPTER;
  GRANT CREATE VIEW TO ADAPTER;
  GRANT CREATE SYNONYM TO ADAPTER;
  GRANT DROP ANY CLUSTER TO ADAPTER;
  GRANT CREATE CLUSTER TO ADAPTER;
  GRANT SELECT ANY TABLE TO ADAPTER;
  GRANT CREATE USER TO ADAPTER;
  GRANT ALTER DATABASE LINK TO ADAPTER;
  GRANT UPDATE ANY CUBE BUILD PROCESS TO ADAPTER;
  GRANT DROP ANY MEASURE FOLDER TO ADAPTER;
  GRANT ALTER ANY CUBE DIMENSION TO ADAPTER;
  GRANT ALTER ANY MINING MODEL TO ADAPTER;
  GRANT SELECT ANY MINING MODEL TO ADAPTER;
  GRANT DROP ANY ASSEMBLY TO ADAPTER;
  GRANT DROP ANY EDITION TO ADAPTER;
  GRANT MANAGE FILE GROUP TO ADAPTER;
  GRANT SELECT ANY TRANSACTION TO ADAPTER;
  GRANT EXECUTE ANY PROGRAM TO ADAPTER;
  GRANT ADVISOR TO ADAPTER;
  GRANT GRANT ANY OBJECT PRIVILEGE TO ADAPTER;
  GRANT EXEMPT ACCESS POLICY TO ADAPTER;
  BEGIN
SYS.DBMS_AQADM.GRANT_SYSTEM_PRIVILEGE (
  PRIVILEGE    => 'MANAGE_ANY',
  GRANTEE      => 'ADAPTER',
  ADMIN_OPTION => FALSE);
END;
/
  GRANT GLOBAL QUERY REWRITE TO ADAPTER;
  GRANT CREATE ANY OPERATOR TO ADAPTER;
  GRANT CREATE ANY LIBRARY TO ADAPTER;
  GRANT CREATE ANY DIRECTORY TO ADAPTER;
  GRANT ALTER RESOURCE COST TO ADAPTER;
  GRANT DROP ANY TRIGGER TO ADAPTER;
  GRANT CREATE PROCEDURE TO ADAPTER;
  GRANT DROP PUBLIC SYNONYM TO ADAPTER;
  GRANT CREATE ANY INDEX TO ADAPTER;
  GRANT CREATE ANY CLUSTER TO ADAPTER;
  GRANT COMMENT ANY TABLE TO ADAPTER;
  GRANT MANAGE TABLESPACE TO ADAPTER;
  GRANT ALTER TABLESPACE TO ADAPTER;
  GRANT UPDATE ANY CUBE DIMENSION TO ADAPTER;
  GRANT CREATE MEASURE FOLDER TO ADAPTER;
  GRANT CREATE CUBE TO ADAPTER;
  GRANT CREATE EXTERNAL JOB TO ADAPTER;
  GRANT CHANGE NOTIFICATION TO ADAPTER;
  GRANT CREATE ANY JOB TO ADAPTER;
  BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.CREATE_ANY_RULE,
  GRANTEE      => 'ADAPTER',
  GRANT_OPTION => FALSE);
END;
/
  BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.CREATE_RULE_OBJ,
  GRANTEE      => 'ADAPTER',
  GRANT_OPTION => FALSE);
END;
/
  GRANT CREATE ANY OUTLINE TO ADAPTER;
  BEGIN
SYS.DBMS_AQADM.GRANT_SYSTEM_PRIVILEGE (
  PRIVILEGE    => 'DEQUEUE_ANY',
  GRANTEE      => 'ADAPTER',
  ADMIN_OPTION => FALSE);
END;
/
  GRANT DROP ANY DIMENSION TO ADAPTER;
  GRANT CREATE OPERATOR TO ADAPTER;
  GRANT ALTER ANY LIBRARY TO ADAPTER;
  GRANT ALTER ANY MATERIALIZED VIEW TO ADAPTER;
  GRANT CREATE ANY MATERIALIZED VIEW TO ADAPTER;
  GRANT ALTER ANY PROCEDURE TO ADAPTER;
  GRANT ALTER DATABASE TO ADAPTER;
  GRANT DELETE ANY TABLE TO ADAPTER;
  GRANT DROP ANY TABLE TO ADAPTER;
  GRANT DROP TABLESPACE TO ADAPTER;
  GRANT AUDIT SYSTEM TO ADAPTER;
  GRANT DROP ANY CUBE BUILD PROCESS TO ADAPTER;
  GRANT CREATE CUBE BUILD PROCESS TO ADAPTER;
  GRANT INSERT ANY MEASURE FOLDER TO ADAPTER;
  GRANT DELETE ANY MEASURE FOLDER TO ADAPTER;
  GRANT DROP ANY CUBE TO ADAPTER;
  GRANT DELETE ANY CUBE DIMENSION TO ADAPTER;
  GRANT CREATE ANY CUBE DIMENSION TO ADAPTER;
  GRANT CREATE ANY MINING MODEL TO ADAPTER;
  GRANT ALTER ANY ASSEMBLY TO ADAPTER;
  GRANT MANAGE ANY FILE GROUP TO ADAPTER;
  BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.EXECUTE_ANY_RULE,
  GRANTEE      => 'ADAPTER',
  GRANT_OPTION => FALSE);
END;
/
  BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.EXECUTE_ANY_RULE_SET,
  GRANTEE      => 'ADAPTER',
  GRANT_OPTION => FALSE);
END;
/
  BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.ALTER_ANY_EVALUATION_CONTEXT,
  GRANTEE      => 'ADAPTER',
  GRANT_OPTION => FALSE);
END;
/
  BEGIN
SYS.DBMS_RULE_ADM.GRANT_SYSTEM_PRIVILEGE(
  PRIVILEGE    => SYS.DBMS_RULE_ADM.CREATE_EVALUATION_CONTEXT_OBJ,
  GRANTEE      => 'ADAPTER',
  GRANT_OPTION => FALSE);
END;
/
  GRANT DEBUG ANY PROCEDURE TO ADAPTER;
  GRANT RESUMABLE TO ADAPTER;
  GRANT MERGE ANY VIEW TO ADAPTER;
  GRANT UNDER ANY TABLE TO ADAPTER;
  GRANT DROP ANY OPERATOR TO ADAPTER;
  GRANT ALTER ANY OPERATOR TO ADAPTER;
  GRANT EXECUTE ANY LIBRARY TO ADAPTER;
  GRANT ALTER ANY TRIGGER TO ADAPTER;
  GRANT CREATE ANY TRIGGER TO ADAPTER;
  GRANT ALTER ANY SEQUENCE TO ADAPTER;
  GRANT CREATE SEQUENCE TO ADAPTER;
  GRANT ALTER ANY CLUSTER TO ADAPTER;
  GRANT INSERT ANY TABLE TO ADAPTER;
  GRANT LOCK ANY TABLE TO ADAPTER;
  GRANT DROP ROLLBACK SEGMENT TO ADAPTER;
  GRANT ALTER ROLLBACK SEGMENT TO ADAPTER;
  GRANT RESTRICTED SESSION TO ADAPTER;
  GRANT ALTER SESSION TO ADAPTER;
  GRANT FLASHBACK ARCHIVE ADMINISTER TO ADAPTER;
  GRANT INSERT ANY CUBE DIMENSION TO ADAPTER;
  GRANT DROP ANY MINING MODEL TO ADAPTER;
  GRANT CREATE ASSEMBLY TO ADAPTER;
  GRANT ON COMMIT REFRESH TO ADAPTER;
  BEGIN
SYS.DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SYSTEM_PRIVILEGE
  (GRANTEE_NAME   => 'ADAPTER', 
   PRIVILEGE_NAME => 'ADMINISTER_RESOURCE_MANAGER',
   ADMIN_OPTION   => FALSE);
END;
/
  GRANT CREATE ANY CONTEXT TO ADAPTER;
  BEGIN
SYS.DBMS_AQADM.GRANT_SYSTEM_PRIVILEGE (
  PRIVILEGE    => 'ENQUEUE_ANY',
  GRANTEE      => 'ADAPTER',
  ADMIN_OPTION => FALSE);
END;
/
  GRANT CREATE DIMENSION TO ADAPTER;
  GRANT DROP ANY TYPE TO ADAPTER;
  GRANT ALTER ANY TYPE TO ADAPTER;
  GRANT GRANT ANY PRIVILEGE TO ADAPTER;
  GRANT CREATE TRIGGER TO ADAPTER;
  GRANT EXECUTE ANY PROCEDURE TO ADAPTER;
  GRANT CREATE ANY VIEW TO ADAPTER;
  GRANT DROP ANY SYNONYM TO ADAPTER;
  GRANT BACKUP ANY TABLE TO ADAPTER;
  GRANT ALTER ANY TABLE TO ADAPTER;
  GRANT CREATE ANY TABLE TO ADAPTER;
  GRANT CREATE TABLE TO ADAPTER;
  GRANT CREATE ROLLBACK SEGMENT TO ADAPTER;
  GRANT DROP USER TO ADAPTER;
  GRANT CREATE SESSION TO ADAPTER;
  GRANT ADMINISTER SQL MANAGEMENT OBJECT TO ADAPTER;
  GRANT SELECT ANY CUBE TO ADAPTER;
  GRANT CREATE ANY CUBE TO ADAPTER;
  GRANT SELECT ANY CUBE DIMENSION TO ADAPTER;
  GRANT CREATE MINING MODEL TO ADAPTER;
  GRANT READ ANY FILE GROUP TO ADAPTER;
  GRANT QUERY REWRITE TO ADAPTER;
  GRANT UNDER ANY VIEW TO ADAPTER;
  GRANT CREATE LIBRARY TO ADAPTER;
  GRANT DROP ANY PROCEDURE TO ADAPTER;
  GRANT DROP ANY SEQUENCE TO ADAPTER;
  GRANT CREATE ANY SYNONYM TO ADAPTER;
  GRANT DROP ANY INDEX TO ADAPTER;
  -- 1 Tablespace Quota for ADAPTER 
  ALTER USER ADAPTER QUOTA UNLIMITED ON USERS;
