CREATE TABLE TRANSLATIONS
(
  TRANSLATION_ID  NUMBER,
  SOURCE_CODESET  VARCHAR2(255 BYTE) CONSTRAINT TRANSLATIONS_NN1 NOT NULL,
  SOURCE_CODE     VARCHAR2(255 BYTE) CONSTRAINT TRANSLATIONS_NN2 NOT NULL,
  TARGET_CODESET  VARCHAR2(255 BYTE) CONSTRAINT TRANSLATIONS_NN3 NOT NULL,
  TARGET_CODE     VARCHAR2(255 BYTE) CONSTRAINT TRANSLATIONS_NN4 NOT NULL
);


CREATE UNIQUE INDEX TRANSLATIONS_PK ON TRANSLATIONS
(TRANSLATION_ID);


CREATE OR REPLACE TRIGGER TRANSLATION_ID_TRG
BEFORE INSERT
ON TRANSLATIONS
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
DECLARE
  N NUMBER;
BEGIN
-- For Toad:  Highlight column TRANSLATION_ID
  if :NEW.TRANSLATION_ID is null then
    Select TRANSLATION_ID_SEQ.nextval into n from dual;
    :new.TRANSLATION_ID := N;
  end if;
END TRANSLATION_ID_TRG;
/


ALTER TABLE TRANSLATIONS ADD (
  CONSTRAINT TRANSLATIONS_PK
  PRIMARY KEY
  (TRANSLATION_ID)
  USING INDEX TRANSLATIONS_PK
  ENABLE VALIDATE);
