CREATE TABLE FACILITIES
(
  FACILITY_ID             NUMBER,
  FACILITY_NUMBER         VARCHAR2(10 BYTE) CONSTRAINT FACILITIES_NN1 NOT NULL,
  HOME_COMMUNITY_ID       VARCHAR2(255 BYTE) CONSTRAINT FACILITIES_NN2 NOT NULL,
  FACILITY_NAME           VARCHAR2(255 BYTE) CONSTRAINT FACILITIES_NN3 NOT NULL,
  FULL_HOME_COMMUNITY_ID  VARCHAR2(255 BYTE)
);


CREATE UNIQUE INDEX FACILITIES_PK ON FACILITIES
(FACILITY_ID);


CREATE OR REPLACE TRIGGER FACILITY_ID_TRG
BEFORE INSERT
ON FACILITIES 
REFERENCING NEW AS NEW OLD AS OLD
FOR EACH ROW
declare
  N NUMBER;
begin
    if :NEW.FACILITY_ID is null then
        select FACILITY_ID_SEQ.NEXTVAL into N from DUAL;
        :new.FACILITY_ID := N;
    end if;
end FACILITY_ID_TRG;
/


ALTER TABLE FACILITIES ADD (
  CONSTRAINT FACILITIES_PK
  PRIMARY KEY
  (FACILITY_ID)
  USING INDEX FACILITIES_PK
  ENABLE VALIDATE);
