/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.xmlutils;

/**
 *
 * @author David Vazquez
 */
public class XMLUtilsException extends RuntimeException
{
    private String mappingProperty;
    private String mappingXPath;
    private String mappingXPathEntry;
    private String mappingXPathParent;
    private String mappingIdString;
    private String mappingSortString;

    /**
     * Creates a new instance of <code>XMLUtilsException</code> without detail message.
     */
    public XMLUtilsException()
    {
    }

    /**
     * Constructs an instance of <code>XMLUtilsException</code> with the specified detail message.
     * @param msg the detail message.
     */
    public XMLUtilsException(String msg)
    {
        super(msg);
    }

    public XMLUtilsException(String msg, String mappingProperty, String mappingXPath)
    {
        this(msg);
        this.mappingProperty = mappingProperty;
        this.mappingXPath = mappingXPath;
    }

    public XMLUtilsException(String msg, String mappingProperty, String mappingXPath, String mappingXPathEntry)
    {
        this(msg);
        this.mappingProperty = mappingProperty;
        this.mappingXPath = mappingXPath;
        this.mappingXPathEntry = mappingXPathEntry;
    }

    public XMLUtilsException(Throwable t)
    {
        super(t);
    }

    public XMLUtilsException(String msg, Throwable t)
    {
        super(msg, t);
    }

    public XMLUtilsException(String msg, Throwable t, String mappingProperty, String mappingXPath)
    {
        this(msg, t);
        this.mappingProperty = mappingProperty;
        this.mappingXPath = mappingXPath;
    }

    public String getMappingIdString()
    {
        return mappingIdString;
    }

    public void setMappingIdString(String mappingIdString)
    {
        this.mappingIdString = mappingIdString;
    }

    public String getMappingProperty()
    {
        return mappingProperty;
    }

    public void setMappingProperty(String mappingProperty)
    {
        this.mappingProperty = mappingProperty;
    }

    public String getMappingSortString()
    {
        return mappingSortString;
    }

    public void setMappingSortString(String mappingSortString)
    {
        this.mappingSortString = mappingSortString;
    }

    public String getMappingXPath()
    {
        return mappingXPath;
    }

    public void setMappingXPath(String mappingXPath)
    {
        this.mappingXPath = mappingXPath;
    }

    public void setMappingXPathEntry(String mappingXPathEntry)
    {
        this.mappingXPathEntry = mappingXPathEntry;
    }

    public void setMappingXPathParent(String mappingXPathParent)
    {
        this.mappingXPathParent = mappingXPathParent;
    }

    @Override
    public String toString()
    {
        String ret = super.toString();

        if (mappingProperty != null) {
            ret += "\n\tmappingProperty=" + mappingProperty;
        }

        if (mappingXPath != null) {
            ret += "\n\tmappingXPath=" + mappingXPath;
        }

        if (mappingIdString != null) {
            ret += "\n\tmappingIdString=" + mappingIdString;
        }

        if (mappingSortString != null) {
            ret += "\n\tmappingSortString=" + mappingSortString;
        }

        if (mappingXPathEntry != null) {
            ret += "\n\tmappingXPathEntry=" + mappingXPathEntry;
        }

        if (mappingXPathParent != null) {
            ret += "\n\tmappingXPathParent=" + mappingXPathParent;
        }

        return ret;
    }
}
