/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.xmlutils;

import java.util.*;

import javax.xml.*;
import javax.xml.namespace.*;


/**
 *
 * @author David Vazquez
 */
public class XMLNamespaceContext implements NamespaceContext
{
    private final HashMap<String, String> namespaceMapping = new HashMap<String, String>();
    private final HashMap<String, String> reverseMapping = new HashMap<String, String>();

    public void addMapping(String prefix, String namespaceURI)
    {
        namespaceMapping.put(prefix, namespaceURI);
        reverseMapping.put(namespaceURI, prefix);
    }

    public String getNamespaceURI(String prefix)
    {
        String ret = namespaceMapping.get(prefix);
        return ret != null ? ret : XMLConstants.NULL_NS_URI;
    }

    public String getPrefix(String namespaceURI)
    {
        return reverseMapping.get(namespaceURI);
    }

    public Iterator getPrefixes(String namespaceURI)
    {
        ArrayList<String> ret = new ArrayList<String>();

        String s = getPrefix(namespaceURI);
        if (s != null) ret.add(s);

        return ret.iterator();
    }
}
