/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.utils.transceiver;

import java.io.*;
import java.nio.*;
import java.net.*;
import java.util.*;
import java.util.logging.*;

/**
 *
 * @author David Vazquez
 */
public abstract class SocketTransceiver implements Transceiver
{
    static private Logger logger = Logger.getLogger(SocketTransceiver.class.getName());

    static private int BUFFER_SIZE = 512;

    private String host;
    private int port;
    private int timeout;
    private Socket socket;
    private Reader reader;
    private Writer writer;

    public SocketTransceiver(String host, int port, int timeout)
    {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    protected void connect()
    {
        try {
            if (socket == null) {
                InetSocketAddress socketAddress = new InetSocketAddress(host, port);
                socket = new Socket();
                socket.setSoTimeout(timeout);
                socket.connect(socketAddress);
                reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            }
            else {
                throw new TransceiverException("Already connected.", null);
            }
        }
        catch (Throwable t) {
            throw new TransceiverException("An error occured connecting to " + host + ":" + port, t);
        }
    }

    protected void disconnect()
    {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Throwable t) {
                logger.warning("Error closing socket.");
            }
            finally {
                socket = null;
            }
        }
        else {
            throw new TransceiverException("Already disconnect.", null);
        }
    }

    protected void send(String data)
    {
        try {
            writer.write(data);
            writer.flush();
        }
        catch (Throwable t) {
            throw new TransceiverException("An error occurred writing.", t);
        }
    }

    protected String receive(String endMarker)
    {
        StringBuffer ret = new StringBuffer();

        try {
            char[] buffer = new char[BUFFER_SIZE];
            int count = 0;
            while (count != -1 && ret.indexOf(endMarker) == -1) {
                count = reader.read(buffer);
                if (count != -1) {
                    ret.append(buffer, 0, count);
                }
            }
        }
        catch (Throwable t) {
            throw new TransceiverException("An error occurred writing.", t);
        }

        return ret.toString();
    }
}
