/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.utils.encoders;

import java.util.logging.*;

/**
 *
 * @author David Vazquez
 */
public class MLLPEncoder
{
    static Logger logger = Logger.getLogger(MLLPEncoder.class.getName());

    static public final String VT = "\u000B";
    static public final String FSCR = "\u001C\r";

    static public String encode(String message)
    {
        return VT + message + FSCR;
    }

    static public String decode(String message)
    {
        String ret;

        if (message.startsWith(VT)
            && message.endsWith(FSCR)) {
            ret =  message.substring(1, message.length() - 2);
        }
        else {
            logger.warning("Malformed MLLP message.");
            ret = message;
        }

        return ret;
    }
}
