/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.utils.config;

import java.util.*;

/**
 *
 * @author David Vazquez
 */
public class PropertyTypeUtils
{
    static public Map toMap(PropertiesType propertiesType)
    {
        HashMap<String, String> ret = new HashMap<String, String>();

        for (PropertyType propertyType : propertiesType.getProperty()) {
            ret.put(propertyType.getName(), propertyType.getValue());
        }

        return ret;
    }

    static public Properties toProperties(PropertiesType propertiesType)
    {
        Properties ret = new Properties();

        for (PropertyType propertyType : propertiesType.getProperty()) {
            ret.setProperty(propertyType.getName(), propertyType.getValue());
        }
        
        return ret;
    }

    static public Map toMap(PropertiesType propertiesType, String[] excludeKeys)
    {
        Map ret = toMap(propertiesType);

        for (String excludeKey : excludeKeys) {
            ret.remove(excludeKey);
        }

        return ret;
    }

    static public String getProperty(PropertiesType propertiesType, String name)
    {
        String ret = null;

        if (propertiesType != null) {
            PropertyType property = findProperty(propertiesType, name);
            if (property != null) {
                ret = property.getValue();
            }
        }
        
        return ret;
    }

    static public Integer getPropertyAsInteger(PropertiesType propertiesType, String name)
    {
        Integer ret = null;
        
        if (propertiesType != null) {
            PropertyType property = findProperty(propertiesType, name);
            if (property != null) {
                String s = property.getValue();
                try {
                    ret = Integer.parseInt(s);
                }
                catch (NumberFormatException nfe) {
                    // just return null.
                }
            }
        }
        
        return ret;
    }
    
    static public PropertiesType getProperties(PropertiesType propertiesType, String name)
    {
        PropertiesType ret = null;

        if (propertiesType != null) {
            PropertyType property = findProperty(propertiesType, name);
            if (property != null) {
                ret = property.getProperties();
            }
        }

        return ret;
    }

    static private PropertyType findProperty(PropertiesType propertiesType, String name)
    {
        PropertyType ret = null;

        for (PropertyType property : propertiesType.getProperty()) {
            if (property.getName().equals(name)) {
                ret = property;
                break;
            }
        }

        return ret;
    }
}
