/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.utils;

import java.io.*;
import java.net.*;

import javax.xml.bind.*;
import javax.xml.parsers.*;
import javax.xml.transform.dom.*;

import org.w3c.dom.*;
import org.xml.sax.*;

/**
 *
 * @author David Vazquez
 */
public class XMLUtils
{
    static public boolean isAttributeSet(Node property, String name)
    {
        Node attr = property.getAttributes().getNamedItem(name);
        return attr != null && attr.getTextContent().equalsIgnoreCase("true");
    }

    static public Document parse(String filename)
        throws Exception
    {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(getEntityResolver());
        return db.parse(Utils.getResourceAsStream(filename));
    }


    static public <T extends Object> T load(String filename, Class<T> cls)
        throws Exception
    {
        return load(Utils.getResourceAsStream(filename), cls);
    }

    static public <T extends Object> T load(InputStream in, Class<T> cls)
        throws Exception
    {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(getEntityResolver());
        Document doc = db.parse(in);

        DOMSource source = new DOMSource(doc);

        return JAXB.unmarshal(source, cls);
    }

    static public void save(String filename, Object obj)
        throws Exception
    {
        URL url = Utils.getResource(filename);
        File f = new File(url.getPath());
        JAXB.marshal(obj, f);
    }
    static public EntityResolver getEntityResolver()
    {
        return new EntityResolver()
        {
            public InputSource resolveEntity(String publicId, String systemId)
            {
                if (publicId != null) {
                    return null;
                }
                else {
                    try {
                        return new InputSource(Utils.getResourceAsStream(systemId));
                    }
                    catch (Throwable e) {
                        return null;
                    }
                }
            }
        };
    }
}
