/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.datamanager.translators;

import ext.domain.nhin.adapter.datamanager.*;

/**
 *
 * @author David Vazquez
 */
public class SubstringDataTranslator implements DataTranslator
{
    public Object translate(Object input, Object result, Reference translationType, DataQuery dataQuery)
    {
        String ret = null;
        
        if (input != null) {
            if (!(input instanceof String)) {
                throw new DataManagerException("input must be of type java.lang.String");
            }
            
            String inputAsString = (String)input;
            Integer beginIndex = translationType.getPropertyAsInteger("beginIndex");
            Integer endIndex = translationType.getPropertyAsInteger("endIndex");

            if (beginIndex == null) {
                throw new DataManagerException("beginIndex property is required.");
            }

            try {
                if (endIndex == null) {
                    ret = inputAsString.substring(beginIndex);
                }
                else {
                    ret = inputAsString.substring(beginIndex, endIndex);
                }
            }
            catch (IndexOutOfBoundsException iobe) {
                ret = "";
            }
        }
        
        return ret;
    }
}
