package ext.domain.nhin.adapter.datamanager.translators;

import java.io.*;
import java.util.*;
import java.util.logging.*;

import ext.domain.sts.webservice.ct.*;

public class SerializableMapEntryValueListTransfer extends MapEntryValueListTransfer
{
    static private final Logger logger = Logger.getLogger(SerializableMapEntryValueListTransfer.class.getName());
    
    public SerializableMapEntryValueListTransfer(MapEntryValueListTransfer mapEntryValueListTransfer)
    {
        setTotalNumberOfRecords(mapEntryValueListTransfer.getTotalNumberOfRecords());
        getMapEntryValues().addAll(mapEntryValueListTransfer.getMapEntryValues());
    }

    private void writeObject(ObjectOutputStream out) throws IOException
    {
        logger.entering(getClass().getName(), "writeObject");
        out.writeObject(getTotalNumberOfRecords());
        out.writeObject((Serializable)getMapEntryValues());
        logger.exiting(getClass().getName(), "writeObject");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException
    {
        logger.entering(getClass().getName(), "readObject");
        setTotalNumberOfRecords((Long)in.readObject());
        mapEntryValues = (List<MapEntryValueTransfer>)in.readObject();
        logger.exiting(getClass().getName(), "readObject");
    }
}
