/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.datamanager.translators;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author VHAISBVAZQUD
 */
public class FirstNotBlankDataTranslator implements DataTranslator
{
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        Object ret = null;
        String propertyNames = translation.getProperty("propertyNames");
        
        if (NullChecker.isNullOrEmpty(propertyNames)) {
            throw new DataManagerException("proertyNames property must be set.");
        }
        
        for (String propertyName : propertyNames.split(",")) {
            Object value = translation.getValue(propertyName);
            if (NullChecker.isNotNullOrEmpty(value)) {
                ret = value;
                break;
            }
        }
        
        return ret;
    }
}
