/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager.translators;

import java.util.logging.*;

import org.apache.commons.beanutils.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class FilterDataTranslator implements DataTranslator
{
    static private final Logger logger = Logger.getLogger(FilterDataTranslator.class.getName());
    
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        logger.entering(getClass().getName(), "translate", new Object[]{input, result, translation, dataQuery});

        Object ret = null;
        String whereProperty = translation.getProperty("whereProperty");
        String wherePropertyValue = translation.getProperty("wherePropertyValue");
        String resultProperty = translation.getProperty("resultProperty");
        
        logger.log(Level.FINEST, "whereProperty={0}", whereProperty);
        logger.log(Level.FINEST, "wherePropertyValue={0}", wherePropertyValue);
        logger.log(Level.FINEST, "resultProperty={0}", resultProperty);

        try {
            if (input != null) {
                if (!Utils.isCollection(input)) {
                    throw new RuntimeException("input must be a collection.");
                }

                for (int i = 0;  i < Utils.getCollectionLength(input);  ++i) {
                    Object obj = PropertyUtils.getIndexedProperty(input, "", i);
                    Object value = PropertyUtils.getProperty(obj, whereProperty);
                    logger.log(Level.FINEST, "value={0}", value);
                    if (NullChecker.isNotNullOrEmpty(value)
                        && value.equals(wherePropertyValue)) {
                        ret = NullChecker.isNotNullOrEmpty(resultProperty) ? PropertyUtils.getProperty(obj, resultProperty) : obj;
                        break;
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new DataManagerException("There was an error.", t);
        }
        finally {
            logger.exiting(getClass().getName(), "translate", ret);
        }

        return ret;
    }
}
