/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager.translators;

import java.text.*;
import java.util.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class DateFileManDataTranslator implements DataTranslator
{
    static private final String FILEMAN_DATE_PATTERN = "yyyyMMdd.HHmmss";

    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        String ret = null;
        String targetDateFormat = translation.getProperty("targetDateFormat");

        if (input != null) {
            if (!(input instanceof Date)) {
                throw new RuntimeException("input must be of type java.util.Date.");
            }

            if (!NullChecker.isNullOrEmpty(targetDateFormat)) {
                if (!FILEMAN_DATE_PATTERN.startsWith(targetDateFormat)) {
                    throw new RuntimeException("targetDateFormat is invalid.");
                }
            }
            else {
                targetDateFormat = FILEMAN_DATE_PATTERN;
            }

            Date d = (Date)input;
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(d);
            cal.add(Calendar.YEAR, -1700);

            SimpleDateFormat formatter = new SimpleDateFormat(targetDateFormat);
            ret = formatter.format(cal.getTime());
        }
        
        return ret;
    }
}
