/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager.translators;

import java.util.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class DateAddDataTranslator implements DataTranslator
{
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        Date ret = null;
        String value = translation.getProperty("value");
        String field = translation.getProperty("field");

        if (input != null) {
            if (!(input instanceof Date)) {
                throw new RuntimeException("input must be of type java.util.Date");
            }

            if (NullChecker.isNullOrEmpty(field) || !(field.equals("MONTH") || field.equals("DAY") || field.equals("YEAR"))) {
                throw new RuntimeException("field property must be one of DAY, MONTH, or YEAR.");
            }

            int f = 0;
            if (field.equals("DAY")) {
                f = Calendar.DATE;
            }
            else if (field.equals("MONTH")) {
                f = Calendar.MONTH;
            }
            else if (field.equals("YEAR")) {
                f = Calendar.YEAR;
            }

            int v = Integer.parseInt(value);

            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime((Date)input);
            cal.add(f, v);
            ret = cal.getTime();
        }
        
        return ret;
    }
}
