/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.datamanager.translators;

import java.io.*;

import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;
import org.w3c.dom.*;

import ext.domain.nhin.adapter.datamanager.*;

/**
 *
 * @author VHAISBVAZQUD
 */
public class DOMToFileDataTranslator implements DataTranslator
{
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        String path = translation.getProperty("path");
        
        if (input != null) {
            if (!(input instanceof Document)) {
                throw new DataManagerException("input must be of type org.w3c.dom.Document.");
            }

            try {
                Source source = new DOMSource((Document)input);

                FileOutputStream fos = new FileOutputStream(path);
                Result rslt = new StreamResult(fos);

                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.transform(source, rslt);
            }
            catch (Throwable t) {
                throw new DataManagerException("An error occurred.", t);
            }
        }
        
        return input;
    }
}
