/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager.translators;

import org.apache.commons.beanutils.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class ConcatenateDataTranslator implements DataTranslator
{
    public Object translate(Object input, Object result, Reference translation, DataQuery dataQuery)
    {
        String ret;
        String fields = translation.getProperty("fields");
        String separator = translation.getProperty("separator");
        String initialValueFromInput = translation.getProperty("initialValueFromInput");

        if (NullChecker.isNullOrEmpty(separator)) {
            separator = ",";
        }

        if (NullChecker.isNotNullOrEmpty(initialValueFromInput)
            && NullChecker.isNotNullOrEmpty(input)) {
            ret = (String)input;
        }
        else {
            ret = "";
        }

        for (String field : fields.split(separator)) {
            try {
                if (field.startsWith("'") && field.endsWith("'")) {
                    ret += field.substring(1, field.length()-1);
                }
                else {
                    Object value = translation.getValue(field);
                    if (!NullChecker.isNullOrEmpty(value)) {
                        ret += value;
                    }
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Error contenating property.", t);
            }
        }

        return ret;
    }
}
