/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager.parsers;

import java.lang.reflect.*;
import java.util.*;

import org.apache.commons.beanutils.*;
import org.w3c.dom.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.utils.*;
import ext.domain.nhin.adapter.xmlutils.*;

/**
 *
 * @author David Vazquez
 */
public class XMLTemplateDataParser implements DataParser
{
    public List parse(List dataResults, Reference parser, DataQuery dataQuery)
    {
        List ret = new ArrayList<Map>();
        String configFilename = parser.getProperty("configFilename");
        String metaDataFields = parser.getProperty("metaDataFields");
        XMLTemplate xmlTemplate = XMLTemplateFactory.getXMLTemplate(configFilename);
   
        for (Object dataResult : dataResults) {
            HashMap result = new HashMap();
            Document document = xmlTemplate.fillIn(dataResult);
            result.put("document", document);

            if (!NullChecker.isNullOrEmpty(metaDataFields)) {
                for (String metaDataField : metaDataFields.split(",")) {
                    try {
                        result.put(metaDataField, PropertyUtils.getProperty(dataResult, metaDataField));
                    }
                    catch (IllegalAccessException iae) {}
                    catch (InvocationTargetException ite) {}
                    catch (NoSuchMethodException nsme) {}
                }
            }

            ret.add(result);
        }

        return ret;
    }
}
