/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager.parsers;

import java.io.*;
import java.util.*;

import org.apache.commons.beanutils.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.datamanager.config.*;
import ext.domain.nhin.adapter.utils.*;
import ext.domain.nhin.adapter.utils.config.*;

/**
 *
 * @author David Vazquez
 */
public class JAXBDataParser implements DataParser
{
    public List parse(List dataResults, Reference parser, DataQuery dataQuery)
    {
        List ret;
        String className = parser.getProperty("className");
        String returnProperty = parser.getProperty("returnProperty");
        String results = (String)dataResults.get(0);

        Class cls;
        try {
            cls = Class.forName(className);
        }
        catch (Throwable t) {
            throw new DataManagerException("Unable to find class, " + className + ".", t);
        }

        Object result;
        try {
            result = XMLUtils.load(new StringBufferInputStream(results), cls);
        }
        catch (Throwable t) {
            throw new DataManagerException("Unable to unmarshal results.", t);
        }

        
        if (!NullChecker.isNullOrEmpty(returnProperty)) {
            Object obj;
            try {
                obj = PropertyUtils.getProperty(result, returnProperty);
            }
            catch (Throwable t) {
                throw new DataManagerException("Error getting returnProperty from unmarshalled xml object.", t);
            }

            if (!Utils.isCollection(obj)) {
                throw new DataManagerException("Object returned by returnProperty must be a collection.");
            }
            
            ret = (List)obj;
        }
        else {
            ret = new ArrayList();
            ret.add(result);
        }
        
        return ret;
    }
}
