/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager.filters;

import java.util.*;

import org.apache.commons.beanutils.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class MostRecentDateDataFilter implements DataFilter
{
    public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
    {
        boolean ret = true;
        
        try {
            if (!results.isEmpty()) {
                String fieldNames = filterType.getProperty("fieldNames");
                String[] fieldNamesArray = fieldNames.split(",");

                int newTestPosition = getTestPosition(fieldNamesArray, result);
                Date newValue = (Date)getTestValue(result, fieldNamesArray, newTestPosition);

                for (Object curResult : results) {
                    int curTestPosition = getTestPosition(fieldNamesArray, curResult);
                    Date curValue = (Date)getTestValue(curResult, fieldNamesArray, curTestPosition);

                    ret &= (newTestPosition < curTestPosition
                            || (newTestPosition == curTestPosition
                                && (newTestPosition == Integer.MAX_VALUE || newValue.after(curValue))));
                    if (!ret) break;
                }
            }
        }
        catch (Throwable t) {
            throw new DataManagerException("An error occurred processing filter.", t);
        }

        return ret;
    }

    private int getTestPosition(String[] fieldNamesArray, Object result)
    {
        int ret = Integer.MAX_VALUE;

        for (int i = 0;  i < fieldNamesArray.length;  ++i) {
            try {
                Object value = PropertyUtils.getProperty(result, fieldNamesArray[i]);
                if (!NullChecker.isNullOrEmpty(value)) {
                    ret = i;
                    break;
                }
            }
            catch (Throwable t) {
            }
        }

        return ret;
    }

    private Object getTestValue(Object result, String[] fieldNamesArray, int position)
        throws Exception
    {
        Object ret = null;

        if (position < fieldNamesArray.length) {
            ret = PropertyUtils.getProperty(result, fieldNamesArray[position]);
        }

        return ret;
    }
}
