/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager.filters;

import java.util.*;

import org.apache.commons.beanutils.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.utils.*;
import ext.domain.nhin.adapter.utils.Comparator;

/**
 *
 * @author David Vazquez
 */
public class MatchDataFilter implements DataFilter
{
    public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
    {
        boolean ret = true;
        String[] matchFields = dataQuery.getParameterNames();

        try {
            for (String matchField : matchFields) {
                Object leftValue = dataQuery.getParameter(matchField);
                Object rightValue = PropertyUtils.getProperty(result, matchField);
                
                if (!NullChecker.isNullOrEmpty(leftValue)
                    && dataQuery.isResult(matchField)
                    && !Comparator.equals(leftValue, rightValue)) {
                    ret = false;
                    break;
                }
            }
        }
        catch (Throwable t) {
            ret = false;
        }

        return ret;
    }
}
