/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager.filters;

import java.util.*;

import org.apache.commons.beanutils.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class FacilityNumberDataFilter implements DataFilter
{
    public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
    {
        try {
            String connectionFilename = filterType.getProperty("connectionFilename");
            String facilityNumberName = filterType.getProperty("facilityNumberName");
            Properties propertiesCollection =
                PropertiesCollectionFactory.getPropertiesCollection(connectionFilename);
            String facilityNumber = BeanUtils.getProperty(result, facilityNumberName);
            return !NullChecker.isNullOrEmpty(facilityNumber)
                   && propertiesCollection.containsKey(facilityNumber);
        }
        catch (Throwable t) {
            throw new DataManagerException("An error occurrend when processing filter.", t);
        }
    }
}
