/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager.filters;

import java.text.*;
import java.util.*;

import org.apache.commons.beanutils.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class DateBetweenDataFilter implements DataFilter
{
    public boolean test(Object result, List results, Reference filterType, DataQuery dataQuery)
    {
        boolean ret = false;

        try {
            String beginDateName = filterType.getProperty("beginDateName");
            String endDateName = filterType.getProperty("endDateName");
            String valueName = filterType.getProperty("valueName");
            String includeEndDateString = filterType.getProperty("includeEndDate");
            Date beginDate = (Date)dataQuery.getParameter(beginDateName);
            Date endDate = (Date)dataQuery.getParameter(endDateName);
            Date value = (Date)PropertyUtils.getProperty(result, valueName);
            boolean includeEndDate = NullChecker.isNotNullOrEmpty(includeEndDateString) && includeEndDateString.toUpperCase().equals("TRUE");
            
            ret = (NullChecker.isNullOrEmpty(beginDate) || value.equals(beginDate) || value.after(beginDate))
                  && (NullChecker.isNullOrEmpty(endDate) || includeEndDate && value.equals(endDate) || value.before(endDate));
        }
        catch (Throwable t) {
            throw new DataManagerException("There was an error during a filter test.", t);
        }

        return ret;
    }
}
