/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.datamanager.adapters;

import java.util.*;
import java.util.logging.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author VHAISBVAZQUD
 */
public class QueryAggregatorDataAdapter implements DataAdapter
{
    static private final Logger logger = Logger.getLogger(QueryAggregatorDataAdapter.class.getName());
    
    public List getData(DataQuery dataQuery)
    {
        ArrayList ret = new ArrayList();
        String[] queryNames = getQueryNames(dataQuery);
        
        if (queryNames != null) {
            for (String queryName : queryNames) {
                try {
                    DataQuery query = setUpQuery(dataQuery, queryName);
                    ret.addAll(query.getResults());
                }
                catch (QueryDoesNotExistException qdnee) {
                    logger.log(Level.FINEST, "Query {0} is not supported.", queryName);
                }
            }
        }
        
        return ret;
    }
    
    private String[] getQueryNames(DataQuery dataQuery)
    {
        String queryNames = (String)dataQuery.getParameter("queryNames");
        if (NullChecker.isNullOrEmpty(queryNames)) {
            queryNames = dataQuery.getProperty("queryNames");
        }
        return NullChecker.isNotNullOrEmpty(queryNames) ? queryNames.split(",") : null;
    }
    
    private DataQuery setUpQuery(DataQuery dataQuery, String queryName)
    {
        DataQuery ret = dataQuery.getDataManager().getQuery(queryName);
        for (String parameterName : dataQuery.getParameterBySourceNames()) {
            if (ret.isParameter(parameterName)) {
                ret.setParameter(parameterName, dataQuery.getParameterBySource(parameterName));
            }
        }
        return ret;
    }
}
