/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager.adapters;

import java.util.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public class PassThroughDataAdapter implements DataAdapter
{
    public List getData(DataQuery dataQuery)
    {
        String queryName = dataQuery.getProperty("queryName");

        if (NullChecker.isNullOrEmpty(queryName)) {
            throw new DataManagerException("queryName must be specified.");
        }

        DataQuery subQuery = dataQuery.getDataManager().getQuery(queryName);

        for (String parameterName : dataQuery.getParameterBySourceNames()) {
            if (subQuery.isParameter(parameterName)) {
                subQuery.setParameter(parameterName, dataQuery.getParameterBySource(parameterName));
            }
        }

        return subQuery.getResults();
    }
}
