/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager.adapters;

import java.util.*;
import java.util.logging.*;
import java.text.*;

import ca.uhn.hl7v2.model.*;
import ca.uhn.hl7v2.parser.*;
import ca.uhn.hl7v2.util.*;
import ca.uhn.hl7v2.validation.impl.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author David Vazquez
 */
public abstract class HL7DataAdapter implements DataAdapter
{
    static private final Logger logger = Logger.getLogger(HL7DataAdapter.class.getName());

    public List getData(DataQuery dataQuery)
    {
        logger.entering(getClass().getName(), "getData");

        try {
            String message = buildMessage(dataQuery);
            logger.finest("Request:\n" + addLFs(message));
            String response = sendMessage(dataQuery, message);
            logger.finest("Response:\n" + addLFs(response));
            return processResponse(dataQuery, response);
        }
        catch (DataManagerException dme) {
            throw dme;
        }
        catch (Throwable t) {
            DataManagerException dme = new DataManagerException(t);
            logger.throwing(getClass().getName(), "getData", dme);
            throw dme;
        }
        finally {
            logger.exiting(getClass().getName(), "getData");
        }
    }

    String buildMessage(DataQuery dataQuery)
        throws Exception
    {
        String template = dataQuery.getProperty("template").trim();

        GenericParser parser = new GenericParser();
        parser.setValidationContext(new NoValidation());
        Message message = parser.parse(template);
        Terser terser = new Terser(message);

        for (String p : dataQuery.getParameterBySourceNames()) {
            if (!NullChecker.isNullOrEmpty(dataQuery.getParameterBySource(p))) {
                terser.set(p, dataQuery.getParameterBySource(p).toString());
            }
        }

        return parser.encode(message);
    }

    List processResponse(DataQuery dataQuery, String response)
        throws Exception
    {
        List ret = new ArrayList<HashMap>();
        String rowCountLocation = dataQuery.getProperty("rowCountLocation");
        GenericParser parser = new GenericParser();
        Message message = parser.parse(response);
        Terser terser = new Terser(message);
        int rowCount;

        checkResponseStatus(dataQuery, terser);

        if (!NullChecker.isNullOrEmpty(rowCountLocation)) {
            rowCount = Integer.parseInt(terser.get(rowCountLocation));
        }
        else {
            rowCount = 1;
        }

        for (int i = 0;  i < rowCount;  ++i) {
            HashMap result = new HashMap();
            for (String source : dataQuery.getResultBySourceNames()) {
                String dataLocation = source.replaceAll("\\$index", Integer.toString(i));
                String value = terser.get(dataLocation);
                result.put(source, value);
            }
            ret.add(result);
        }

        return ret;
    }

    private void checkResponseStatus(DataQuery dataQuery, Terser terser)
        throws Exception
    {
        String statusLocation = dataQuery.getProperty("statusLocation");
        String statusAllowedValues = dataQuery.getProperty("statusAllowedValues");
        String statusErrorTextLocation = dataQuery.getProperty("statusErrorTextLocation");

        if (!NullChecker.isNullOrEmpty(statusLocation)
            && !NullChecker.isNullOrEmpty(statusAllowedValues)) {
            String status = terser.get(statusLocation);
            boolean foundIt = false;
            for (String statusAllowedValue : statusAllowedValues.split(",")) {
                if (status.equals(statusAllowedValue)) {
                    foundIt = true;
                    break;
                }
            }
            if (!foundIt) {
                String message = status;
                if (!NullChecker.isNullOrEmpty(statusErrorTextLocation)) {
                    message += " - " + terser.get(statusErrorTextLocation);
                }
                throw new ParseErrorException(message);
            }
        }
    }

    abstract String sendMessage(DataQuery dataQuery, String message) throws Exception;

    private String addLFs(String str)
    {
        return str.replaceAll("\r", "\r\n");
    }
}
