/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.datamanager.adapters;

import java.net.*;
import java.util.*;
import java.util.logging.Logger;
import java.util.logging.Level;

import javax.xml.namespace.QName;
import javax.xml.soap.*;
import javax.xml.ws.handler.*;
import javax.xml.ws.handler.soap.*;
import javax.xml.ws.soap.*;

import ext.domain.esr.webservices.jaxws.schemas.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.utils.*;

/**
 *
 * @author VHAISBVAZQUD
 */
public class ESRDataAdapter implements DataAdapter
{
    private class HeaderHandlerResolver implements HandlerResolver
    {
        private String username;
        private String password;

        public HeaderHandlerResolver(String username, String password)
        {
            this.username = username;
            this.password = password;
        }

        public List<Handler> getHandlerChain(PortInfo portInfo)
        {
            List<Handler> ret = new ArrayList<Handler>();
            ret.add(new HeaderHandler(username, password));
            return ret;
        }
    }

    private class HeaderHandler implements SOAPHandler<SOAPMessageContext>
    {
        private String un;
        private String pw;

        public HeaderHandler(String username, String password)
        {
            this.un = username;
            this.pw = password;
        }

        public Set<QName> getHeaders()
        {
            return null;
        }

        public void close(MessageContext context)
        {
        }

        public boolean handleFault(SOAPMessageContext context)
        {
            return true;
        }

        public boolean handleMessage(SOAPMessageContext smc)
        {
            Boolean outboundProperty = (Boolean)smc.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

            if (outboundProperty.booleanValue()) {
                try {
                    SOAPEnvelope envelope = smc.getMessage().getSOAPPart().getEnvelope();
                    SOAPHeader header = envelope.getHeader();
                    
                    if (header == null) {
                        header = envelope.addHeader();
                    }

                    SOAPElement security =
                            header.addChildElement("Security", "wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");

                    SOAPElement usernameToken =
                            security.addChildElement("UsernameToken", "wsse");
                    usernameToken.addAttribute(new QName("xmlns:wsu"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");

                    SOAPElement username =
                            usernameToken.addChildElement("Username", "wsse");
                    username.addTextNode(un);

                    SOAPElement password =
                            usernameToken.addChildElement("Password", "wsse");
                    password.setAttribute("Type", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
                    password.addTextNode(pw);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            return outboundProperty;
        }
    }
    
    static private final Logger logger = Logger.getLogger(ESRDataAdapter.class.getName());
    private EeSummaryPortService eeSummaryService = null;

    public List getData(DataQuery dataQuery)
    {
        ArrayList ret = new ArrayList();
        String icn = (String)dataQuery.getParameter("icn");
        String connectionFilename = dataQuery.getProperty("connectionFilename");
        String connection = dataQuery.getProperty("connection");

        GetEESummaryRequest eeSummaryRequest = new GetEESummaryRequest();
        eeSummaryRequest.setKey(icn);
        eeSummaryRequest.setKeyType("VPID");
        eeSummaryRequest.setRequestName("preferredFacility");

        GetEESummaryResponse eeSummaryResponse = null;
        try {
            Properties propertiesCollection = PropertiesCollectionFactory.getPropertiesCollection(connectionFilename);
            Properties connectionProperties = (Properties)propertiesCollection.get(connection);
            String wsdlURL = connectionProperties.getProperty("wsdlURL");
            String username = connectionProperties.getProperty("username");
            String password = connectionProperties.getProperty("password");

            eeSummaryResponse = getEESummaryPort(wsdlURL, username, password).getEESummary(eeSummaryRequest);
            if (eeSummaryResponse.getSummary() == null
                || eeSummaryResponse.getSummary().getDemographics() == null
                || NullChecker.isNullOrEmpty(eeSummaryResponse.getSummary().getDemographics().getPreferredFacility())) {
                eeSummaryResponse = createDefaultResponse("<UNKNOWN>", "<UNKNOWN>");
            }
        }
        catch (SOAPFaultException sfe) {
            if (sfe.getMessage().equals("PERSON_NOT_FOUND")) {
                logger.log(Level.FINEST, "ESR does not know patient with ICN={0}.", icn);
                eeSummaryResponse = createDefaultResponse("<UNKNOWN>", "<UNKNOWN>");
            }
            else {
                logger.log(Level.WARNING, "There was an error getting data from ESR.  Message={0}", sfe.getMessage());
                logger.logp(Level.FINEST, getClass().getName(), "getData", "Stack Trace", sfe);
                eeSummaryResponse = createDefaultResponse("<UNAVAILABLE>", "<UNAVAILABLE>");
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "There was an error getting data from ESR.  Message={0}", t.getMessage());
            logger.logp(Level.FINEST, getClass().getName(), "getData", "Stack Trace", t);
            eeSummaryResponse = createDefaultResponse("<UNAVAILABLE>", "<UNAVAILABLE>");
        }

        ret.add(eeSummaryResponse);

        return ret;
    }

    private synchronized EeSummaryPort getEESummaryPort(String eeSummaryServiceWSDL,
                                                        String username,
                                                        String password)
    {
        if (eeSummaryService == null) {
            try {
                eeSummaryService = new EeSummaryPortService(new URL(eeSummaryServiceWSDL),
                										    new QName("http://jaxws.webservices.esr.domain.ext/schemas", "eeSummaryPortService"));
                
                if (!NullChecker.isNullOrEmpty(username)
                    && !NullChecker.isNullOrEmpty(password)) {
                    eeSummaryService.setHandlerResolver(new HeaderHandlerResolver(username, password));
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Error getting EESummaryPort.", t);
            }
        }
        return eeSummaryService.getEeSummaryPortSoap11();
    }

    private GetEESummaryResponse createDefaultResponse(String facilityNumber, String facilityName)
    {
        GetEESummaryResponse eeSummaryResponse = new GetEESummaryResponse();

        EeSummary eeSummary = new EeSummary();
        eeSummaryResponse.setSummary(eeSummary);

        DemographicInfo demographicInfo = new DemographicInfo();
        eeSummary.setDemographics(demographicInfo);

        demographicInfo.setPreferredFacility(facilityNumber + " - " + facilityName);

        return eeSummaryResponse;
    }
}
