/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.datamanager.adapters;

import java.util.*;

import ext.domain.nhin.adapter.datamanager.*;
import ext.domain.nhin.adapter.utils.*;
import ext.domain.nhin.adapter.utils.config.*;

/**
 *
 * @author David Vazquez
 *
 */
public class CompositeDataAdapter implements DataAdapter
{
    public List getData(DataQuery dataQuery)
    {
        List ret = new ArrayList<Map>();
        DataManager dataManager = dataQuery.getDataManager();
        String queryNames = dataQuery.getProperty("queryNames");

        if (NullChecker.isNullOrEmpty(queryNames)) {
            throw new DataManagerException("queryNames must be specified");
        }

        HashMap<String, Object> result = new HashMap<String, Object>();

        for (String queryName : queryNames.split(",")) {
            DataQuery subQuery = dataManager.getQuery(queryName);
            for (String parameterName : dataQuery.getParameterBySourceNames()) {
                if (subQuery.isParameter(parameterName)) {
                    subQuery.setParameter(parameterName, dataQuery.getParameterBySource(parameterName));
                }
            }

            PropertiesType setProperties = dataQuery.getProperties(queryName + ".setProperties");
            if (setProperties != null) {
                for (PropertyType setProperty : setProperties.getProperty()) {
                    subQuery.setProperty(setProperty.getName(), dataQuery.getParameter(setProperty.getValue()).toString());
                }
            }

            List subResults = subQuery.getResults();
            if (!NullChecker.isNullOrEmpty(subResults)) {
                result.put(queryName, subResults);
            }
        }

        if (!result.isEmpty()) {
            ret.add(result);
        }

        return ret;
    }
}
