/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager;

import java.util.*;

import org.apache.commons.beanutils.*;

import ext.domain.nhin.adapter.datamanager.config.*;
import ext.domain.nhin.adapter.utils.*;
import ext.domain.nhin.adapter.utils.config.*;

/**
 *
 * @author David Vazquez
 */
public class Reference<T>
{
    private final ReferenceType reference;
    private final DeclarationType declaration;
    private final T obj;
    private final Object result;
    private final Object sourceResult;
    
    public Reference(ReferenceType reference, DeclarationType declaration, T obj)
    {
        this.reference = reference;
        this.declaration = declaration;
        this.obj = obj;
        this.result = this.sourceResult = null;
    }

    public Reference(ReferenceType reference, DeclarationType declaration, T obj, Object result, Object sourceResult)
    {
        this.reference = reference;
        this.declaration = declaration;
        this.obj = obj;
        this.result = result;
        this.sourceResult = sourceResult;
    }

    public DeclarationType getDeclaration()
    {
        return declaration;
    }

    public ReferenceType getReference()
    {
        return reference;
    }

    public String getProperty(String name)
    {
        String ret = null;

        if (reference != null) {
            ret = PropertyTypeUtils.getProperty(reference.getProperties(), name);
        }

        if (NullChecker.isNullOrEmpty(ret)) {
            if (declaration != null) {
                ret = PropertyTypeUtils.getProperty(declaration.getProperties(), name);
            }
        }

        return ret;
    }

    public Integer getPropertyAsInteger(String name)
    {
        Integer ret = null;
        
        if (reference != null) {
            ret = PropertyTypeUtils.getPropertyAsInteger(reference.getProperties(), name);
        }
        
        if (NullChecker.isNullOrEmpty(ret)) {
            if (declaration != null) {
                ret = PropertyTypeUtils.getPropertyAsInteger(declaration.getProperties(), name);
            }
        }
        
        return ret;
    }
    
    public PropertiesType getProperties(String name)
    {
        PropertiesType ret = null;

        if (reference != null) {
            ret = PropertyTypeUtils.getProperties(reference.getProperties(), name);
        }

        if (NullChecker.isNullOrEmpty(ret)) {
            if (declaration != null) {
                ret = PropertyTypeUtils.getProperties(declaration.getProperties(), name);
            }
        }

        return ret;
    }

    public T getObj()
    {
        return obj;
    }

    public Object getValue(String property)
    {
        Object ret = getProperty(result, property);
        if (ret == null){
            ret = getProperty(sourceResult, property);
        }

        return ret;
    }

    private Object getProperty(Object bean, String property)
    {
        Object ret;

        try {
            ret = PropertyUtils.getProperty(bean, property);
        }
        catch (Throwable t) {
            ret = null;
        }

        return ret;
    }
}
