/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package ext.domain.nhin.adapter.datamanager;

import java.util.*;

/**
 *
 * @author David Vazquez
 */
public class DataManagerFactory
{
    static private final HashMap<String, DataManagerImpl> dataManagerCache = new HashMap<String, DataManagerImpl>();

    static public synchronized DataManagerImpl getDataManager(String configFilename)
        throws DataManagerException
    {
        DataManagerImpl ret = dataManagerCache.get(configFilename);
        if (ret == null) {
            ret = new DataManagerImpl(configFilename);
            dataManagerCache.put(configFilename, ret);
        }

        return ret;
    }
}
