/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ext.domain.nhin.adapter.policyengine.pdpproxy;

import java.net.*;

import javax.ejb.*;
import javax.xml.namespace.QName;

import oasis.names.tc.xacml._2_0.context.schema.os.*;

import ext.domain.nhin.vap.server.service.permission.contexthandler.*;
import ext.domain.nhin.adapter.propertylookup.*;
/**
 *
 * @author VHAISBVAZQUD
 */
@Stateless(name = "PDPProxyVAP")
public class PDPProxyVAP implements PDPProxyLocal
{
    private XACMLContextHandlerService xacmlContextHandlerService;
    private PropertyLookup propertyLookup;
    
    @EJB(beanInterface = PropertyLookupLocal.class, beanName = "PropertyLookup")
    public void setPropertyLookup(PropertyLookup propertyLookup)
    {
        this.propertyLookup = propertyLookup;
    }
    
    public ResponseType checkPolicy(RequestType request)
    {
        return getXACMLContextHandlerPort().checkPolicy(request);
    }
    
    private XACMLContextHandlerPortType getXACMLContextHandlerPort()
    {
        if (xacmlContextHandlerService == null) {
            try {
                xacmlContextHandlerService = new XACMLContextHandlerService(new URL(propertyLookup.getProperty("XACMLContextHandlerServiceWSDL")),
                															new QName("http://contexthandler.permission.service.server.vap.nhin.domain.ext/", "XACMLContextHandlerService"));
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to get XACMLContextHandlerPort.");
            }
        }

        return xacmlContextHandlerService.getXACMLContextHandlerPort();
    }
}
